/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.SslConfigOptions;
import com.marklogic.mapreduce.utilities.TextArrayWritable;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.ValueFactory;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSBase64Binary;
import com.marklogic.xcc.types.XSBoolean;
import com.marklogic.xcc.types.XSDouble;
import com.marklogic.xcc.types.XSFloat;
import com.marklogic.xcc.types.XSHexBinary;
import com.marklogic.xcc.types.XSInteger;
import com.marklogic.xcc.types.XdmBinary;
import com.marklogic.xcc.types.XdmValue;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class InternalUtilities
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(InternalUtilities.class);
    static final String FOREST_HOST_MAP_QUERY = "import module namespace hadoop = \"http://marklogic.com/xdmp/hadoop\" at \"/MarkLogic/hadoop.xqy\";\nhadoop:get-forest-host-map()";
    private static SslConfigOptions inputSslOptions;
    private static SslConfigOptions outputSslOptions;
    private static Object sslOptionsMutex;

    public static ContentSource getInputContentSource(Configuration conf) throws URISyntaxException, XccConfigException, IOException {
        String host = conf.getStrings("mapreduce.marklogic.input.host")[0];
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("mapreduce.marklogic.input.host is not specified.");
        }
        return InternalUtilities.getInputContentSource(conf, host);
    }

    public static ContentSource getInputContentSource(Configuration conf, String host) throws XccConfigException, IOException {
        String user = conf.get("mapreduce.marklogic.input.username", "");
        String password = conf.get("mapreduce.marklogic.input.password", "");
        String port = conf.get("mapreduce.marklogic.input.port", "8000");
        String db = conf.get("mapreduce.marklogic.input.databasename");
        int portInt = Integer.parseInt(port);
        boolean useSsl = conf.getBoolean("mapreduce.marklogic.input.usessl", false);
        if (useSsl) {
            return InternalUtilities.getSecureContentSource(host, portInt, user, password, db, InternalUtilities.getInputSslOptions(conf));
        }
        return ContentSourceFactory.newContentSource((String)host, (int)portInt, (String)user, (char[])password.toCharArray(), (String)db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SslConfigOptions getInputSslOptions(Configuration conf) throws XccConfigException {
        if (null != inputSslOptions) {
            return inputSslOptions;
        }
        Object object = sslOptionsMutex;
        synchronized (object) {
            if (null != inputSslOptions) {
                return inputSslOptions;
            }
            Class sslOptionClass = conf.getClass("mapreduce.marklogic.input.ssloptionsclass", null, SslConfigOptions.class);
            if (sslOptionClass != null) {
                inputSslOptions = (SslConfigOptions)ReflectionUtils.newInstance((Class)sslOptionClass, (Configuration)conf);
            } else {
                String ssl_protocol = conf.get("mapreduce.marklogic.input.sslprotocol", "TLSv1.2");
                String keystore_path = conf.get("mapreduce.marklogic.input.keystorepath", null);
                String keystore_passwd = conf.get("mapreduce.marklogic.input.keystorepassword", null);
                String truststore_path = conf.get("mapreduce.marklogic.input.truststorepath", null);
                String truststore_passwd = conf.get("mapreduce.marklogic.input.truststorepassword", null);
                if (keystore_path == null && truststore_path == null) {
                    inputSslOptions = new TrustAnyoneOptions(ssl_protocol);
                } else {
                    KeyManager[] keyManager = null;
                    TrustManager[] trustManager = null;
                    if (keystore_path != null) {
                        if (keystore_passwd == null) throw new IllegalArgumentException("mapreduce.marklogic.input.keystorepassword is not specified.");
                        try {
                            keyManager = InternalUtilities.getUserKeyManager(keystore_path, keystore_passwd);
                        }
                        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                            throw new XccConfigException("Error constructing SecurityOptions", (Throwable)e);
                        }
                    }
                    if (truststore_path != null) {
                        if (truststore_passwd == null) throw new IllegalArgumentException("mapreduce.marklogic.input.truststorepassword is not specified.");
                        try {
                            trustManager = InternalUtilities.getUserTrustManager(truststore_path, truststore_passwd);
                        }
                        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                            throw new XccConfigException("Error constructing SecurityOptions", (Throwable)e);
                        }
                    } else {
                        trustManager = InternalUtilities.getTrustAnyoneManager();
                    }
                    inputSslOptions = new UserTrustOptions(ssl_protocol, keyManager, trustManager);
                }
            }
            return inputSslOptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SslConfigOptions getOutputSslOptions(Configuration conf) throws XccConfigException {
        if (null != outputSslOptions) {
            return outputSslOptions;
        }
        Object object = sslOptionsMutex;
        synchronized (object) {
            if (null != outputSslOptions) {
                return outputSslOptions;
            }
            Class sslOptionClass = conf.getClass("mapreduce.marklogic.output.ssloptionsclass", null, SslConfigOptions.class);
            if (sslOptionClass != null) {
                outputSslOptions = (SslConfigOptions)ReflectionUtils.newInstance((Class)sslOptionClass, (Configuration)conf);
            } else {
                String ssl_protocol = conf.get("mapreduce.marklogic.output.sslprotocol", "TLSv1.2");
                String keystore_path = conf.get("mapreduce.marklogic.output.keystorepath", null);
                String keystore_passwd = conf.get("mapreduce.marklogic.output.keystorepassword", null);
                String truststore_path = conf.get("mapreduce.marklogic.output.truststorepath", null);
                String truststore_passwd = conf.get("mapreduce.marklogic.output.truststorepassword", null);
                if (keystore_path == null && truststore_path == null) {
                    outputSslOptions = new TrustAnyoneOptions(ssl_protocol);
                } else {
                    KeyManager[] keyManager = null;
                    TrustManager[] trustManager = null;
                    if (keystore_path != null) {
                        if (keystore_passwd == null) throw new IllegalArgumentException("mapreduce.marklogic.output.keystorepassword is not specified.");
                        try {
                            keyManager = InternalUtilities.getUserKeyManager(keystore_path, keystore_passwd);
                        }
                        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                            throw new XccConfigException("Error constructing SecurityOptions", (Throwable)e);
                        }
                    }
                    if (truststore_path != null) {
                        if (truststore_passwd == null) throw new IllegalArgumentException("mapreduce.marklogic.output.truststorepassword is not specified.");
                        try {
                            trustManager = InternalUtilities.getUserTrustManager(truststore_path, truststore_passwd);
                        }
                        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                            throw new XccConfigException("Error constructing SecurityOptions", (Throwable)e);
                        }
                    } else {
                        trustManager = InternalUtilities.getTrustAnyoneManager();
                    }
                    outputSslOptions = new UserTrustOptions(ssl_protocol, keyManager, trustManager);
                }
            }
            return outputSslOptions;
        }
    }

    private static KeyManager[] getUserKeyManager(String path, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream ksFile = new FileInputStream(path);
        ks.load(ksFile, password.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, password.toCharArray());
        ksFile.close();
        return kmf.getKeyManagers();
    }

    private static TrustManager[] getUserTrustManager(String path, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream ksFile = new FileInputStream(path);
        ks.load(ksFile, password.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ks);
        ksFile.close();
        return tmf.getTrustManagers();
    }

    private static TrustManager[] getTrustAnyoneManager() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        }};
    }

    static ContentSource getSecureContentSource(String host, int port, String user, String password, String db, SslConfigOptions sslOptions) throws XccConfigException {
        SecurityOptions options;
        ContentSource contentSource = null;
        try {
            options = new SecurityOptions(sslOptions.getSslContext());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new XccConfigException("Error constructing SecurityOptions", (Throwable)e);
        }
        options.setEnabledCipherSuites(sslOptions.getEnabledCipherSuites());
        options.setEnabledProtocols(sslOptions.getEnabledProtocols());
        contentSource = ContentSourceFactory.newContentSource((String)host, (int)port, (String)user, (char[])password.toCharArray(), (String)db, (SecurityOptions)options);
        return contentSource;
    }

    public static <VALUEIN> void assignResultValue(Class<? extends Writable> valueClass, ResultItem result, VALUEIN value) {
        if (valueClass.equals(Text.class)) {
            ((Text)value).set(result.asString());
        } else if (valueClass.equals(IntWritable.class) && result.getValueType() == ValueType.XS_INTEGER) {
            XSInteger intItem = (XSInteger)result.getItem();
            ((IntWritable)value).set(intItem.asPrimitiveInt());
        } else if (valueClass.equals(VIntWritable.class) && result.getValueType() == ValueType.XS_INTEGER) {
            XSInteger intItem = (XSInteger)result.getItem();
            ((VIntWritable)value).set(intItem.asPrimitiveInt());
        } else if (valueClass.equals(LongWritable.class) && result.getValueType() == ValueType.XS_INTEGER) {
            XSInteger intItem = (XSInteger)result.getItem();
            ((LongWritable)value).set(intItem.asLong().longValue());
        } else if (valueClass.equals(VLongWritable.class) && result.getValueType() == ValueType.XS_INTEGER) {
            XSInteger intItem = (XSInteger)result.getItem();
            ((VLongWritable)value).set(intItem.asLong().longValue());
        } else if (valueClass.equals(BooleanWritable.class) && result.getValueType() == ValueType.XS_BOOLEAN) {
            XSBoolean boolItem = (XSBoolean)result.getItem();
            ((BooleanWritable)value).set(boolItem.asPrimitiveBoolean());
        } else if (valueClass.equals(FloatWritable.class) && result.getValueType() == ValueType.XS_FLOAT) {
            XSFloat floatItem = (XSFloat)result.getItem();
            ((FloatWritable)value).set(floatItem.asPrimitiveFloat());
        } else if (valueClass.equals(DoubleWritable.class) && result.getValueType() == ValueType.XS_DOUBLE) {
            XSDouble doubleItem = (XSDouble)result.getItem();
            ((DoubleWritable)value).set(doubleItem.asPrimitiveDouble());
        } else if (valueClass.equals(BytesWritable.class) && result.getValueType() == ValueType.XS_HEX_BINARY) {
            XSHexBinary binItem = (XSHexBinary)result.getItem();
            byte[] bytes = binItem.asBinaryData();
            ((BytesWritable)value).set(bytes, 0, bytes.length);
        } else if (valueClass.equals(BytesWritable.class) && result.getValueType() == ValueType.XS_BASE64_BINARY) {
            XSBase64Binary binItem = (XSBase64Binary)result.getItem();
            byte[] bytes = binItem.asBinaryData();
            ((BytesWritable)value).set(bytes, 0, bytes.length);
        } else if (valueClass.equals(BytesWritable.class) && result.getValueType() == ValueType.BINARY) {
            byte[] bytes = ((XdmBinary)result.getItem()).asBinaryData();
            ((BytesWritable)value).set(bytes, 0, bytes.length);
        } else if (valueClass.equals(MarkLogicNode.class) && (result.getValueType() == ValueType.NODE || result.getValueType() == ValueType.ELEMENT || result.getValueType() == ValueType.DOCUMENT || result.getValueType() == ValueType.ATTRIBUTE || result.getValueType() == ValueType.TEXT)) {
            ((MarkLogicNode)value).set(result);
        } else if (valueClass.equals(DatabaseDocument.class)) {
            ((DatabaseDocument)value).set(result);
        } else {
            throw new UnsupportedOperationException("Value " + valueClass + " is unsupported for result type: " + result.getValueType());
        }
    }

    public static ContentSource getOutputContentSource(Configuration conf, String hostName) throws XccConfigException, IOException {
        String user = conf.get("mapreduce.marklogic.output.username", "");
        String password = conf.get("mapreduce.marklogic.output.password", "");
        String port = conf.get("mapreduce.marklogic.output.port", "8000");
        String db = conf.get("mapreduce.marklogic.output.databasename");
        int portInt = Integer.parseInt(port);
        boolean useSsl = conf.getBoolean("mapreduce.marklogic.output.usessl", false);
        if (useSsl) {
            return InternalUtilities.getSecureContentSource(hostName, portInt, user, password, db, InternalUtilities.getOutputSslOptions(conf));
        }
        return ContentSourceFactory.newContentSource((String)hostName, (int)portInt, (String)user, (char[])password.toCharArray(), (String)db);
    }

    public static String getHost(TextArrayWritable hosts) throws IOException {
        String[] hostStrings = hosts.toStrings();
        if (hostStrings == null || hostStrings.length == 0) {
            throw new IOException("Number of forests is 0: check forests in database");
        }
        int count = hostStrings.length;
        int position = (int)(Math.random() * (double)count);
        return hostStrings[position];
    }

    public static XdmValue newValue(ValueType valueType, Object value) {
        if (value instanceof Text) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((Text)value).toString());
        }
        if (value instanceof BytesWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((BytesWritable)value).getBytes());
        }
        if (value instanceof IntWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((IntWritable)value).get());
        }
        if (value instanceof LongWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((LongWritable)value).get());
        }
        if (value instanceof VIntWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((VIntWritable)value).get());
        }
        if (value instanceof VLongWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((VLongWritable)value).get());
        }
        if (value instanceof BooleanWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((BooleanWritable)value).get());
        }
        if (value instanceof FloatWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)Float.valueOf(((FloatWritable)value).get()));
        }
        if (value instanceof DoubleWritable) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((DoubleWritable)value).get());
        }
        if (value instanceof MarkLogicNode) {
            return ValueFactory.newValue((ValueType)valueType, (Object)((MarkLogicNode)value).get());
        }
        throw new UnsupportedOperationException("Value " + value.getClass().getName() + " is unsupported.");
    }

    public static String unparse(String s) {
        int cp;
        int len = s.length();
        StringBuilder buf = new StringBuilder(len * 2);
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            if (cp >= 32 && cp < 128) {
                switch (cp) {
                    case 34: {
                        buf.append("&quot;");
                        break;
                    }
                    case 38: {
                        buf.append("&amp;");
                        break;
                    }
                    default: {
                        buf.append(s.charAt(i));
                        break;
                    }
                }
                continue;
            }
            buf.append("&#x");
            buf.append(Long.toString(cp, 16));
            buf.append(';');
        }
        return buf.toString();
    }

    public static String getUriWithOutputDir(DocumentURI key, String outputDir) {
        String uri = key.getUri();
        if (outputDir != null && !outputDir.isEmpty()) {
            uri = outputDir.endsWith("/") || uri.startsWith("/") ? outputDir + uri : outputDir + '/' + uri;
            key.setUri(uri);
            key.validate();
        }
        return uri;
    }

    public static int compareUnsignedLong(long x, long y) {
        return x == y ? 0 : (x < y ^ x < 0L != y < 0L ? -1 : 1);
    }

    public static void checkQueryLanguage(String s) {
        if (!s.equalsIgnoreCase("xquery") && !s.equalsIgnoreCase("javascript")) {
            throw new IllegalArgumentException("Invalid output query language:" + s);
        }
    }

    public static void verifyHosts(String hostList, String portStr) {
        String[] hosts = hostList.split(",");
        int port = Integer.parseInt(portStr);
        for (String host : hosts) {
            InetSocketAddress address = new InetSocketAddress(host, port);
            if (!address.isUnresolved()) continue;
            throw new IllegalArgumentException("host " + host + " is not resolvable");
        }
    }

    public static void sleep(long millis) throws InterruptedException {
        String shutdown;
        while (millis > 0L && (shutdown = System.getProperty("mlcp.shutdown")) == null) {
            if (millis > 1000L) {
                Thread.sleep(1000L);
                millis -= 1000L;
                continue;
            }
            Thread.sleep(millis);
            millis = 0L;
        }
    }

    static {
        sslOptionsMutex = new Object();
    }

    static class TrustAnyoneOptions
    implements SslConfigOptions {
        String sslprotocol;

        public TrustAnyoneOptions(String sslprotocol) {
            this.sslprotocol = sslprotocol;
        }

        @Override
        public SSLContext getSslContext() throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext sslContext = SSLContext.getInstance(this.sslprotocol);
            sslContext.init(null, InternalUtilities.getTrustAnyoneManager(), null);
            return sslContext;
        }

        @Override
        public String[] getEnabledProtocols() {
            return null;
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return null;
        }
    }

    static class UserTrustOptions
    implements SslConfigOptions {
        String sslprotocol;
        KeyManager[] keymanager;
        TrustManager[] trustmanager;

        public UserTrustOptions(String sslprotocol, KeyManager[] keymanager, TrustManager[] trustmanager) {
            this.sslprotocol = sslprotocol;
            this.keymanager = keymanager;
            this.trustmanager = trustmanager;
        }

        @Override
        public SSLContext getSslContext() throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext sslContext = SSLContext.getInstance(this.sslprotocol);
            sslContext.init(this.keymanager, this.trustmanager, null);
            return sslContext;
        }

        @Override
        public String[] getEnabledProtocols() {
            return null;
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return null;
        }
    }
}

