/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AccountCacheEntity;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.Authority;
import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.B2CAuthority;
import com.microsoft.aad.msal4j.HttpEvent;
import com.microsoft.aad.msal4j.IdToken;
import com.microsoft.aad.msal4j.JsonHelper;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.aad.msal4j.MsalServiceExceptionFactory;
import com.microsoft.aad.msal4j.OAuthHttpRequest;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TelemetryHelper;
import com.microsoft.aad.msal4j.TokenResponse;
import com.microsoft.aad.msal4j.XmsClientTelemetryInfo;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenRequest {
    Logger log = LoggerFactory.getLogger(TokenRequest.class);
    final Authority requestAuthority;
    private final MsalRequest msalRequest;
    private final ServiceBundle serviceBundle;

    TokenRequest(Authority requestAuthority, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        this.requestAuthority = requestAuthority;
        this.serviceBundle = serviceBundle;
        this.msalRequest = msalRequest;
    }

    AuthenticationResult executeOauthRequestAndProcessResponse() throws ParseException, MsalServiceException, SerializeException, IOException {
        HttpEvent httpEvent = this.createHttpEvent();
        try (TelemetryHelper telemetryHelper = this.serviceBundle.getTelemetryManager().createTelemetryHelper(this.msalRequest.requestContext().getTelemetryRequestId(), this.msalRequest.application().clientId(), httpEvent, false);){
            AccountCacheEntity accountCacheEntity;
            String refreshToken;
            OIDCTokens tokens;
            TokenResponse response;
            HTTPResponse httpResponse = this.toOauthHttpRequest().send();
            this.addResponseHeadersToHttpEvent(httpEvent, httpResponse);
            if (httpResponse.getStatusCode() == 200) {
                response = TokenResponse.parseHttpResponse(httpResponse);
                tokens = response.getOIDCTokens();
                refreshToken = null;
                if (tokens.getRefreshToken() != null) {
                    refreshToken = tokens.getRefreshToken().getValue();
                }
                accountCacheEntity = null;
                if (tokens.getIDToken() != null) {
                    String idTokenJson = tokens.getIDToken().getParsedParts()[1].decodeToString();
                    IdToken idToken = JsonHelper.convertJsonToObject(idTokenJson, IdToken.class);
                    if (!StringHelper.isBlank(response.getClientInfo())) {
                        AuthorityType type = this.msalRequest.application().authenticationAuthority.authorityType;
                        if (type == AuthorityType.B2C) {
                            B2CAuthority authority = (B2CAuthority)this.msalRequest.application().authenticationAuthority;
                            accountCacheEntity = AccountCacheEntity.create(response.getClientInfo(), this.requestAuthority.host(), idToken, authority.policy);
                        } else {
                            accountCacheEntity = AccountCacheEntity.create(response.getClientInfo(), this.requestAuthority.host(), idToken);
                        }
                    }
                }
            } else {
                MsalServiceException exception = MsalServiceExceptionFactory.fromHttpResponse(httpResponse);
                httpEvent.setOauthErrorCode(exception.errorCode());
                throw exception;
            }
            long currTimestampSec = new Date().getTime() / 1000L;
            AuthenticationResult result = AuthenticationResult.builder().accessToken(tokens.getAccessToken().getValue()).refreshToken(refreshToken).familyId(response.getFoci()).idToken(tokens.getIDTokenString()).environment(this.requestAuthority.host()).expiresOn(currTimestampSec + response.getExpiresIn()).extExpiresOn(response.getExtExpiresIn() > 0L ? currTimestampSec + response.getExtExpiresIn() : 0L).accountCacheEntity(accountCacheEntity).scopes(response.getScope()).build();
            AuthenticationResult authenticationResult = result;
            return authenticationResult;
        }
    }

    private void addResponseHeadersToHttpEvent(HttpEvent httpEvent, HTTPResponse httpResponse) {
        XmsClientTelemetryInfo xmsClientTelemetryInfo;
        httpEvent.setHttpResponseStatus(httpResponse.getStatusCode());
        if (!StringHelper.isBlank(httpResponse.getHeaderValue("User-Agent"))) {
            httpEvent.setUserAgent(httpResponse.getHeaderValue("User-Agent"));
        }
        if (!StringHelper.isBlank(httpResponse.getHeaderValue("x-ms-request-id"))) {
            httpEvent.setRequestIdHeader(httpResponse.getHeaderValue("x-ms-request-id"));
        }
        if (!StringHelper.isBlank(httpResponse.getHeaderValue("x-ms-clitelem")) && (xmsClientTelemetryInfo = XmsClientTelemetryInfo.parseXmsTelemetryInfo(httpResponse.getHeaderValue("x-ms-clitelem"))) != null) {
            httpEvent.setXmsClientTelemetryInfo(xmsClientTelemetryInfo);
        }
    }

    private HttpEvent createHttpEvent() throws MalformedURLException {
        HttpEvent httpEvent = new HttpEvent();
        httpEvent.setHttpMethod("POST");
        try {
            httpEvent.setHttpPath(this.requestAuthority.tokenEndpointUrl().toURI());
            if (!StringHelper.isBlank(this.requestAuthority.tokenEndpointUrl().getQuery())) {
                httpEvent.setQueryParameters(this.requestAuthority.tokenEndpointUrl().getQuery());
            }
        }
        catch (URISyntaxException ex) {
            this.log.warn(LogHelper.createMessage("Setting URL telemetry fields failed: " + LogHelper.getPiiScrubbedDetails(ex), this.msalRequest.headers().getHeaderCorrelationIdValue()));
        }
        return httpEvent;
    }

    OAuthHttpRequest toOauthHttpRequest() throws SerializeException, MalformedURLException {
        if (this.requestAuthority.tokenEndpointUrl() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        OAuthHttpRequest oauthHttpRequest = new OAuthHttpRequest(HTTPRequest.Method.POST, this.requestAuthority.tokenEndpointUrl(), this.msalRequest.headers().getReadonlyHeaderMap(), this.serviceBundle);
        oauthHttpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, List<String>> params = this.msalRequest.msalAuthorizationGrant().toParameters();
        oauthHttpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.msalRequest.application().clientAuthentication != null) {
            this.msalRequest.application().clientAuthentication.applyTo((HTTPRequest)oauthHttpRequest);
        }
        return oauthHttpRequest;
    }

    Logger getLog() {
        return this.log;
    }

    Authority getRequestAuthority() {
        return this.requestAuthority;
    }

    MsalRequest getMsalRequest() {
        return this.msalRequest;
    }

    ServiceBundle getServiceBundle() {
        return this.serviceBundle;
    }
}

