/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.inject.Key;
import com.google.inject.name.Names;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import java.lang.annotation.Annotation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedContext {
    private ThreadDelegatedContext plate = null;
    private final Key<String> fooStringKey = Key.get(String.class, (Annotation)Names.named((String)"foo"));
    private final Key<String> barStringKey = Key.get(String.class, (Annotation)Names.named((String)"bar"));

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.plate);
        this.plate = new ThreadDelegatedContext();
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.plate);
        this.plate = null;
    }

    @Test
    public void testEmptyPlate() {
        Assert.assertEquals((long)0L, (long)this.plate.size());
        Assert.assertFalse((boolean)this.plate.containsKey(Key.get(String.class)));
    }

    @Test
    public void testSimplePut() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        this.plate.put(this.fooStringKey, (Object)"hallo");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"hallo", (Object)this.plate.get(this.fooStringKey));
    }

    @Test
    public void testDoubleSamePut() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        this.plate.put(this.fooStringKey, (Object)"hallo");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"hallo", (Object)this.plate.get(this.fooStringKey));
        this.plate.put(this.fooStringKey, (Object)"hallo");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"hallo", (Object)this.plate.get(this.fooStringKey));
    }

    @Test
    public void testOverridePut() {
        this.plate.put(this.fooStringKey, (Object)"hallo");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"hallo", (Object)this.plate.get(this.fooStringKey));
        this.plate.put(this.fooStringKey, (Object)"world");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"world", (Object)this.plate.get(this.fooStringKey));
    }

    @Test
    public void testDoublePut() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertFalse((boolean)this.plate.containsKey(this.barStringKey));
        this.plate.put(this.fooStringKey, (Object)"hallo");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"hallo", (Object)this.plate.get(this.fooStringKey));
        this.plate.put(this.barStringKey, (Object)"world");
        Assert.assertEquals((long)2L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.barStringKey));
        Assert.assertEquals((Object)"world", (Object)this.plate.get(this.barStringKey));
    }

    @Test
    public void testNullValue() {
        this.plate.put(this.fooStringKey, null);
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertNull((Object)this.plate.get(this.fooStringKey));
        this.plate.put(this.fooStringKey, (Object)"world");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"world", (Object)this.plate.get(this.fooStringKey));
    }

    @Test
    public void testClear() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertFalse((boolean)this.plate.containsKey(this.barStringKey));
        this.plate.put(this.fooStringKey, (Object)"hallo");
        Assert.assertEquals((long)1L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertEquals((Object)"hallo", (Object)this.plate.get(this.fooStringKey));
        this.plate.put(this.barStringKey, (Object)"world");
        Assert.assertEquals((long)2L, (long)this.plate.size());
        Assert.assertTrue((boolean)this.plate.containsKey(this.barStringKey));
        Assert.assertEquals((Object)"world", (Object)this.plate.get(this.barStringKey));
        this.plate.clear();
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        Assert.assertFalse((boolean)this.plate.containsKey(this.barStringKey));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullKeyGet() {
        this.plate.get(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullKeyPut() {
        this.plate.put(null, (Object)"Hello");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullKeyContains() {
        this.plate.containsKey(null);
    }
}

