/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.inject.Key;
import com.google.inject.name.Names;
import com.nesscomputing.scopes.threaddelegate.EventRecordingObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import java.lang.annotation.Annotation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedContextEvents {
    private ThreadDelegatedContext plate = null;
    private final Key<String> fooStringKey = Key.get(String.class, (Annotation)Names.named((String)"foo"));
    private final Key<String> barStringKey = Key.get(String.class, (Annotation)Names.named((String)"bar"));

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.plate);
        this.plate = new ThreadDelegatedContext();
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.plate);
        this.plate = null;
    }

    @Test
    public void testPutEvent() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        EventRecordingObject eventTest = new EventRecordingObject();
        this.plate.put(this.fooStringKey, (Object)eventTest);
        Assert.assertEquals((long)1L, (long)eventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)eventTest.getLastEvent());
    }

    @Test
    public void testDoublePutEvent() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        EventRecordingObject fooEventTest = new EventRecordingObject();
        this.plate.put(this.fooStringKey, (Object)fooEventTest);
        Assert.assertEquals((long)1L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        Assert.assertFalse((boolean)this.plate.containsKey(this.barStringKey));
        EventRecordingObject barEventTest = new EventRecordingObject();
        this.plate.put(this.barStringKey, (Object)barEventTest);
        Assert.assertEquals((long)1L, (long)barEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)barEventTest.getLastEvent());
        Assert.assertEquals((long)1L, (long)fooEventTest.getEventCount());
    }

    @Test
    public void testEventNotify() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        EventRecordingObject fooEventTest = new EventRecordingObject();
        this.plate.put(this.fooStringKey, (Object)fooEventTest);
        Assert.assertEquals((long)1L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.plate.event(ThreadDelegatedContext.ScopeEvent.ENTER);
        Assert.assertEquals((long)2L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.plate.event(ThreadDelegatedContext.ScopeEvent.LEAVE);
        Assert.assertEquals((long)3L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.LEAVE, (Object)fooEventTest.getLastEvent());
    }

    @Test
    public void testEventClear() {
        Assert.assertFalse((boolean)this.plate.containsKey(this.fooStringKey));
        EventRecordingObject fooEventTest = new EventRecordingObject();
        this.plate.put(this.fooStringKey, (Object)fooEventTest);
        Assert.assertEquals((long)1L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.plate.clear();
        Assert.assertEquals((long)0L, (long)this.plate.size());
        Assert.assertEquals((long)2L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.LEAVE, (Object)fooEventTest.getLastEvent());
    }
}

