/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceFilter;
import com.nesscomputing.scopes.threaddelegate.ScopedObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScopeModule;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedScopeModule {
    private Injector injector = null;

    @Before
    public void setUp() {
        ThreadDelegatedScope.SCOPE.changeScope(null);
        ScopedObject.TestObjectProvider.reset();
    }

    @After
    public void tearDown() {
        if (this.injector != null) {
            GuiceFilter filter = (GuiceFilter)this.injector.getInstance(GuiceFilter.class);
            filter.destroy();
        }
        ThreadDelegatedScope.SCOPE.changeScope(null);
    }

    @Test
    public void testSimple() {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule()});
        ThreadDelegatedScope scope = (ThreadDelegatedScope)this.injector.getInstance(ThreadDelegatedScope.class);
        Assert.assertNotNull((Object)scope);
        Assert.assertSame((Object)ThreadDelegatedScope.SCOPE, (Object)scope);
    }

    @Test
    public void testScopedObject() {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        ThreadDelegatedScope scope = (ThreadDelegatedScope)this.injector.getInstance(ThreadDelegatedScope.class);
        Assert.assertNotNull((Object)scope);
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        ScopedObject t2 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        Assert.assertNotNull((Object)t2);
        Assert.assertSame((Object)t1, (Object)t2);
    }

    @Test
    public void testScopeChange() {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        ThreadDelegatedScope scope = (ThreadDelegatedScope)this.injector.getInstance(ThreadDelegatedScope.class);
        Assert.assertNotNull((Object)scope);
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        scope.changeScope(null);
        ScopedObject t2 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t2);
        Assert.assertNotSame((Object)t1, (Object)t2);
    }

    @Test
    public void testScopeHandoff() {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        ThreadDelegatedScope scope = (ThreadDelegatedScope)this.injector.getInstance(ThreadDelegatedScope.class);
        Assert.assertNotNull((Object)scope);
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        ThreadDelegatedContext plate = scope.getContext();
        scope.changeScope(null);
        ScopedObject t2 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t2);
        Assert.assertNotSame((Object)t1, (Object)t2);
        scope.changeScope(plate);
        ScopedObject t3 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t3);
        Assert.assertSame((Object)t1, (Object)t3);
        Assert.assertNotSame((Object)t2, (Object)t3);
    }

    @Test
    public void testThreaded() throws Exception {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        ScopedObject testObject = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        int threadCount = 10;
        final CountDownLatch latch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ScopedObject testObject = (ScopedObject)TestThreadDelegatedScopeModule.this.injector.getInstance(ScopedObject.class);
                    Assert.assertEquals((long)0L, (long)testObject.getPerformances());
                    testObject.perform();
                    latch.countDown();
                }
            }).start();
        }
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)(threadCount + 1), (long)ScopedObject.TestObjectProvider.getHandouts());
        Assert.assertEquals((long)0L, (long)testObject.getPerformances());
    }

    @Test
    public void testThreadHandover() throws Exception {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        ScopedObject testObject = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertEquals((long)1L, (long)ScopedObject.TestObjectProvider.getHandouts());
        final ThreadDelegatedScope scope = (ThreadDelegatedScope)this.injector.getInstance(ThreadDelegatedScope.class);
        Assert.assertNotNull((Object)scope);
        int threadCount = 10;
        final ThreadDelegatedContext parentPlate = scope.getContext();
        final CountDownLatch latch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    scope.changeScope(parentPlate);
                    ScopedObject testObject = (ScopedObject)TestThreadDelegatedScopeModule.this.injector.getInstance(ScopedObject.class);
                    testObject.perform();
                    scope.changeScope(null);
                    latch.countDown();
                }
            }).start();
        }
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)ScopedObject.TestObjectProvider.getHandouts());
        Assert.assertEquals((long)threadCount, (long)testObject.getPerformances());
    }
}

