/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.nesscomputing.scopes.threaddelegate.ScopedObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import java.lang.annotation.Annotation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedScopeThreading {
    private ThreadDelegatedScope scope = null;
    private final Key<ScopedObject> fooTestObjectKey = Key.get(ScopedObject.class, (Annotation)Names.named((String)"foo"));

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.scope);
        this.scope = new ThreadDelegatedScope();
        ScopedObject.TestObjectProvider.reset();
        this.scope.changeScope(null);
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.scope);
        this.scope.changeScope(null);
        this.scope = null;
    }

    @Test
    public void testThreaded() throws Exception {
        ScopedObject.TestObjectProvider unscopedProvider = new ScopedObject.TestObjectProvider();
        final Provider scopedProvider = this.scope.scope(this.fooTestObjectKey, (Provider)unscopedProvider);
        int threadCount = 10;
        final CountDownLatch latch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ScopedObject testObject = (ScopedObject)scopedProvider.get();
                    Assert.assertEquals((long)0L, (long)testObject.getPerformances());
                    testObject.perform();
                    latch.countDown();
                }
            }).start();
        }
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)threadCount, (long)ScopedObject.TestObjectProvider.getHandouts());
        Assert.assertEquals((long)0L, (long)((ScopedObject)scopedProvider.get()).getPerformances());
    }

    @Test
    public void testThreadHandover() throws Exception {
        ScopedObject.TestObjectProvider unscopedProvider = new ScopedObject.TestObjectProvider();
        final Provider scopedProvider = this.scope.scope(this.fooTestObjectKey, (Provider)unscopedProvider);
        int threadCount = 10;
        final ThreadDelegatedContext parentPlate = this.scope.getContext();
        final CountDownLatch latch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TestThreadDelegatedScopeThreading.this.scope.changeScope(parentPlate);
                    ScopedObject testObject = (ScopedObject)scopedProvider.get();
                    testObject.perform();
                    TestThreadDelegatedScopeThreading.this.scope.changeScope(null);
                    latch.countDown();
                }
            }).start();
        }
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)ScopedObject.TestObjectProvider.getHandouts());
        Assert.assertEquals((long)threadCount, (long)((ScopedObject)scopedProvider.get()).getPerformances());
    }
}

