/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.tinyhttp.ssl;

import com.google.common.io.Resources;
import com.nesscomputing.tinyhttp.ssl.AlwaysTrustManager;
import com.nesscomputing.tinyhttp.ssl.MultiTrustManager;
import com.nesscomputing.tinyhttp.ssl.SSLConfig;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpsTrustManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpsTrustManagerFactory.class);

    private HttpsTrustManagerFactory() {
    }

    public static X509TrustManager getTrustManager(SSLConfig sslConfig) throws GeneralSecurityException, IOException {
        if (sslConfig.isSSLDisableVerification()) {
            return new AlwaysTrustManager();
        }
        if (sslConfig.getSSLTruststore() == null || sslConfig.getSSLTruststorePassword() == null) {
            LOG.trace("Not using custom truststore.");
            return HttpsTrustManagerFactory.getDefaultTrustManager();
        }
        LOG.trace("Using custom truststore %s.", (Object)sslConfig.getSSLTruststore());
        MultiTrustManager multiTrustManager = new MultiTrustManager();
        if (sslConfig.isSSLTruststoreFallback()) {
            LOG.trace("Adding fallback to default trust manager");
            multiTrustManager.addTrustManager(HttpsTrustManagerFactory.getDefaultTrustManager());
        }
        KeyStore keystore = HttpsTrustManagerFactory.loadKeystore(sslConfig.getSSLTruststore(), sslConfig.getSSLTruststoreType(), sslConfig.getSSLTruststorePassword());
        multiTrustManager.addTrustManager(HttpsTrustManagerFactory.trustManagerFromKeystore(keystore));
        return multiTrustManager;
    }

    @Nonnull
    public static X509TrustManager getDefaultTrustManager() throws GeneralSecurityException {
        return HttpsTrustManagerFactory.trustManagerFromKeystore(null);
    }

    @Nonnull
    private static KeyStore loadKeystore(@Nonnull String location, @Nonnull String keystoreType, @Nonnull String keystorePassword) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        URL keystoreUrl = StringUtils.startsWithIgnoreCase((CharSequence)location, (CharSequence)"classpath:") ? Resources.getResource(HttpsTrustManagerFactory.class, (String)location.substring(10)) : new URL(location);
        keystore.load(keystoreUrl.openStream(), keystorePassword.toCharArray());
        return keystore;
    }

    @Nonnull
    private static X509TrustManager trustManagerFromKeystore(KeyStore keystore) throws GeneralSecurityException {
        TrustManager[] tms;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        trustManagerFactory.init(keystore);
        for (TrustManager tm : tms = trustManagerFactory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            X509TrustManager manager = (X509TrustManager)X509TrustManager.class.cast(tm);
            X509Certificate[] acceptedIssuers = manager.getAcceptedIssuers();
            LOG.debug("Found TrustManager with %d authorities.", (Object)acceptedIssuers.length);
            for (int i = 0; i < acceptedIssuers.length; ++i) {
                X509Certificate issuer = acceptedIssuers[i];
                LOG.trace("Issuer #%d, subject DN=<%s>, serial=<%s>", new Object[]{i, issuer.getSubjectDN(), issuer.getSerialNumber()});
            }
            return manager;
        }
        throw new IllegalStateException("Could not locate X509TrustManager!");
    }
}

