/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es7.dao.index;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.es7.dao.query.parser.Expression;
import com.netflix.conductor.es7.dao.query.parser.internal.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;

abstract class ElasticSearchBaseDAO
implements IndexDAO {
    String indexPrefix;
    ObjectMapper objectMapper;

    ElasticSearchBaseDAO() {
    }

    String loadTypeMappingSource(String path) throws IOException {
        return this.applyIndexPrefixToTemplate(IOUtils.toString((InputStream)ElasticSearchBaseDAO.class.getResourceAsStream(path)));
    }

    private String applyIndexPrefixToTemplate(String text) throws JsonProcessingException {
        JsonNode indexPatternsNodeValue;
        String indexPatternsFieldName = "index_patterns";
        JsonNode root = this.objectMapper.readTree(text);
        if (root != null && (indexPatternsNodeValue = root.get(indexPatternsFieldName)) != null && indexPatternsNodeValue.isArray()) {
            ArrayList patternsWithPrefix = new ArrayList();
            indexPatternsNodeValue.forEach(v -> {
                String patternText = v.asText();
                StringBuilder sb = new StringBuilder();
                if (patternText.startsWith("*")) {
                    sb.append("*").append(this.indexPrefix).append("_").append(patternText.substring(1));
                } else {
                    sb.append(this.indexPrefix).append("_").append(patternText);
                }
                patternsWithPrefix.add(sb.toString());
            });
            ((ObjectNode)root).set(indexPatternsFieldName, this.objectMapper.valueToTree(patternsWithPrefix));
            System.out.println(this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)root));
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)root);
        }
        return text;
    }

    BoolQueryBuilder boolQueryBuilder(String expression, String queryString) throws ParserException {
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            Expression exp = Expression.fromString(expression);
            queryBuilder = exp.getFilterBuilder();
        }
        BoolQueryBuilder filterQuery = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder);
        QueryStringQueryBuilder stringQuery = QueryBuilders.queryStringQuery((String)queryString);
        return QueryBuilders.boolQuery().must((QueryBuilder)stringQuery).must((QueryBuilder)filterQuery);
    }

    protected String getIndexName(String documentType) {
        return this.indexPrefix + "_" + documentType;
    }
}

