/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.tag.Tag;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

final class ServoMaxGauge<T extends Number>
extends AbstractMonitor<Double>
implements Gauge,
ServoMeter,
NumericMonitor<Double> {
    private final Id id;
    private final Clock clock;
    private final MaxGauge impl;
    private final AtomicLong lastUpdated;

    ServoMaxGauge(Id id, Clock clock, MonitorConfig config) {
        super(config.withAdditionalTag((Tag)DataSourceType.GAUGE));
        this.id = id;
        this.clock = clock;
        this.impl = new MaxGauge(config);
        this.lastUpdated = new AtomicLong(clock.wallTime());
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        long now = this.clock.wallTime();
        return now - this.lastUpdated.get() > ServoRegistry.EXPIRATION_TIME_MILLIS;
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        double v = this.impl.getValue(0).longValue();
        return Collections.singleton(new Measurement(this.id(), now, v));
    }

    public void set(double v) {
        this.impl.update((long)v);
        this.lastUpdated.set(this.clock.wallTime());
    }

    public double value() {
        return this.hasExpired() ? Double.NaN : (double)this.impl.getValue(0).longValue();
    }

    public Double getValue(int pollerIndex) {
        return this.value();
    }

    @Override
    public void addMonitors(List<Monitor<?>> monitors) {
        monitors.add((Monitor<?>)this);
    }
}

