/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.browser;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.singlestore.jdbc.plugin.credential.Credential;
import com.singlestore.jdbc.plugin.credential.browser.ExpiringCredential;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TokenWaiterServer {
    private static final Logger logger = Loggers.getLogger(TokenWaiterServer.class);
    public static int WAIT_TIMEOUT = 300;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final String listenPath;
    private final HttpServer server;
    private ExpiringCredential credential;
    private IOException handleException;

    public TokenWaiterServer() throws SQLException {
        try {
            this.server = HttpServer.create(new InetSocketAddress("127.0.0.1", 0), 0);
        }
        catch (IOException e) {
            throw new SQLException("Could not create a local HTTP server while using identity plugin 'BROWSER_SSO'", e);
        }
        String path = "/" + this.randomAlphanumeric(20);
        this.server.createContext(path, new RequestHandler(this));
        this.listenPath = "http://127.0.0.1:" + this.server.getAddress().getPort() + path;
        this.server.start();
    }

    public ExpiringCredential WaitForCredential() throws InterruptedException, TimeoutException, IOException {
        try {
            boolean result = this.latch.await(WAIT_TIMEOUT, TimeUnit.SECONDS);
            if (!result) {
                throw new TimeoutException();
            }
            if (this.handleException != null) {
                throw this.handleException;
            }
            ExpiringCredential expiringCredential = this.credential;
            return expiringCredential;
        }
        finally {
            this.server.stop(0);
        }
    }

    public String getListenPath() {
        return this.listenPath;
    }

    public void setCredential(ExpiringCredential cred) {
        this.credential = cred;
        this.latch.countDown();
    }

    public void setHandleException(IOException e) {
        this.handleException = e;
        this.latch.countDown();
    }

    private String randomAlphanumeric(int len) {
        Random random = new Random();
        return random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(len).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static class DummyAlgorithm
    extends Algorithm {
        public DummyAlgorithm(String name) {
            super(name, "Does not do any signature verification. Used to only verify claims for a token");
        }

        public void verify(DecodedJWT decodedJWT) throws SignatureVerificationException {
        }

        public byte[] sign(byte[] bytes) throws SignatureGenerationException {
            return null;
        }
    }

    private static class RequestHandler
    implements HttpHandler {
        private final TokenWaiterServer server;

        public RequestHandler(TokenWaiterServer server) {
            this.server = server;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            DecodedJWT jwt;
            String raw;
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
            if (exchange.getRequestMethod().equals("OPTIONS")) {
                exchange.getResponseHeaders().set("Allow", "POST");
                exchange.sendResponseHeaders(204, -1L);
                exchange.close();
                return;
            }
            if (!exchange.getRequestMethod().equals("POST")) {
                this.error(exchange, 400, "POST expected");
                this.server.setHandleException(new IOException("POST request expected, got " + exchange.getRequestMethod()));
                return;
            }
            try {
                raw = ((Stream)new BufferedReader(new InputStreamReader(exchange.getRequestBody())).lines().parallel()).collect(Collectors.joining("\n"));
            }
            catch (Exception e) {
                this.error(exchange, 500, "Bad read from request");
                this.server.setHandleException(new IOException("Bad read from request: ", e));
                return;
            }
            try {
                jwt = JWT.decode((String)raw);
            }
            catch (JWTDecodeException e) {
                this.error(exchange, 400, "Could not parse claims: " + e.getMessage());
                this.server.setHandleException(new IOException("Could not parse claims: ", e));
                return;
            }
            JWTVerifier ver = JWT.require((Algorithm)new DummyAlgorithm(jwt.getAlgorithm())).withClaimPresence("email").build();
            try {
                ver.verify(jwt);
                if (jwt.getExpiresAt() == null) {
                    throw new JWTVerificationException("The Claim 'exp' is not present in the JWT.");
                }
                if (jwt.getClaim("sub").isNull() && jwt.getClaim("username").isNull()) {
                    throw new JWTVerificationException("One of claims 'sub' and 'username' must be present in the JWT.");
                }
            }
            catch (JWTVerificationException e) {
                this.error(exchange, 400, "Could not verify claims: " + e.getMessage());
                this.server.setHandleException(new IOException("Could not verify claims: ", e));
                return;
            }
            exchange.sendResponseHeaders(204, -1L);
            exchange.close();
            this.server.setCredential(new ExpiringCredential(new Credential(jwt.getClaim("username").isNull() ? jwt.getClaim("sub").asString() : jwt.getClaim("username").asString(), jwt.getToken()), jwt.getClaim("email").asString(), jwt.getExpiresAt().toInstant()));
        }

        private void error(HttpExchange exchange, int code, String errorMsg) throws IOException {
            exchange.getResponseHeaders().set("Content-Type", "text/plain; charset=utf-8");
            exchange.getResponseHeaders().set("X-Content-Type-Options", "nosniff");
            exchange.sendResponseHeaders(code, 0L);
            exchange.getResponseBody().write(errorMsg.getBytes(StandardCharsets.UTF_8));
            exchange.getResponseBody().close();
        }
    }
}

