/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.BaseCallableStatement;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.client.util.Parameter;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;

public class FunctionStatement
extends BaseCallableStatement
implements CallableStatement {
    public FunctionStatement(Connection con, String databaseName, String procedureName, String arguments, ReentrantLock lock, boolean canCachePrepStmts, int resultSetType, int resultSetConcurrency) throws SQLException {
        super("SELECT " + procedureName + arguments, con, lock, databaseName, procedureName, canCachePrepStmts, resultSetType, resultSetConcurrency, 0);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        super.registerOutParameter(index, sqlType);
    }

    @Override
    protected void executeInternal() throws SQLException {
        super.executeInternal();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("FunctionStatement{sql:'" + this.sql + "'");
        sb.append(", parameters:[");
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter param = this.parameters.get(i);
            if (param == null) {
                sb.append("null");
            } else {
                sb.append(param.bestEffortStringValue(this.con.getContext()));
            }
            if (i == this.parameters.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
        return sb.toString();
    }
}

