/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.export;

import com.singlestore.jdbc.HostAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;

public enum HaMode {
    REPLICATION("replication"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            HostAddress hostWithLessConnection = 1.getHostWithLessConnections(hostAddresses, denyList, primary);
            if (hostWithLessConnection != null) {
                return Optional.of(hostWithLessConnection);
            }
            return HaMode.getAvailableRoundRobinHost(this, hostAddresses, denyList, primary);
        }
    }
    ,
    SEQUENTIAL("sequential"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return 2.getAvailableHostInOrder(hostAddresses, denyList, primary);
        }
    }
    ,
    LOADBALANCE("load-balance"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            HostAddress hostWithLessConnection = 3.getHostWithLessConnections(hostAddresses, denyList, primary);
            if (hostWithLessConnection != null) {
                return Optional.of(hostWithLessConnection);
            }
            return HaMode.getAvailableRoundRobinHost(this, hostAddresses, denyList, primary);
        }
    }
    ,
    NONE(""){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return hostAddresses.isEmpty() ? Optional.empty() : Optional.of(hostAddresses.get(0));
        }
    };

    private final String value;
    private HostAddress lastRoundRobinPrimaryHost = null;
    private HostAddress lastRoundRobinSecondaryHost = null;

    private HaMode(String value) {
        this.value = value;
    }

    public static HaMode from(String value) {
        for (HaMode haMode : HaMode.values()) {
            if (!haMode.value.equalsIgnoreCase(value) && !haMode.name().equalsIgnoreCase(value)) continue;
            return haMode;
        }
        throw new IllegalArgumentException(String.format("Wrong argument value '%s' for HaMode", value));
    }

    public static Optional<HostAddress> getAvailableHostInOrder(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
        for (int i = 0; i < hostAddresses.size(); ++i) {
            HostAddress hostAddress = hostAddresses.get(i);
            if (hostAddress.primary != primary) continue;
            if (!denyList.containsKey(hostAddress)) {
                return Optional.of(hostAddress);
            }
            if ((Long)denyList.get(hostAddress) >= System.currentTimeMillis()) continue;
            denyList.remove(hostAddress);
            return Optional.of(hostAddress);
        }
        return Optional.empty();
    }

    public static HostAddress getHostWithLessConnections(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
        long currentTime = System.currentTimeMillis();
        HostAddress hostAddressWithLessConnections = null;
        for (HostAddress hostAddress : hostAddresses) {
            if (hostAddress.primary != primary) continue;
            if (denyList.containsKey(hostAddress)) {
                if ((Long)denyList.get(hostAddress) > System.currentTimeMillis()) continue;
                denyList.remove(hostAddress);
            }
            if (hostAddress.getThreadConnectedTimeout() == null || hostAddress.getThreadConnectedTimeout() < currentTime) {
                return null;
            }
            if (hostAddressWithLessConnections != null && hostAddressWithLessConnections.getThreadsConnected() <= hostAddress.getThreadsConnected()) continue;
            hostAddressWithLessConnections = hostAddress;
        }
        return hostAddressWithLessConnections;
    }

    public static Optional<HostAddress> getAvailableRoundRobinHost(HaMode haMode, List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
        List<HostAddress> loopList;
        HostAddress lastChosenHost;
        HostAddress hostAddress = lastChosenHost = primary ? haMode.lastRoundRobinPrimaryHost : haMode.lastRoundRobinSecondaryHost;
        if (lastChosenHost == null) {
            loopList = hostAddresses;
        } else {
            int lastChosenIndex = hostAddresses.indexOf(lastChosenHost);
            loopList = new ArrayList<HostAddress>();
            loopList.addAll(hostAddresses.subList(lastChosenIndex + 1, hostAddresses.size()));
            loopList.addAll(hostAddresses.subList(0, lastChosenIndex + 1));
        }
        for (HostAddress hostAddress2 : loopList) {
            if (hostAddress2.primary != primary) continue;
            if (denyList.containsKey(hostAddress2)) {
                if ((Long)denyList.get(hostAddress2) > System.currentTimeMillis()) continue;
                denyList.remove(hostAddress2);
            }
            if (primary) {
                haMode.lastRoundRobinPrimaryHost = hostAddress2;
            } else {
                haMode.lastRoundRobinSecondaryHost = hostAddress2;
            }
            return Optional.of(hostAddress2);
        }
        return Optional.empty();
    }

    public void resetLast() {
        this.lastRoundRobinPrimaryHost = null;
        this.lastRoundRobinSecondaryHost = null;
    }

    public abstract Optional<HostAddress> getAvailableHost(List<HostAddress> var1, ConcurrentMap<HostAddress, Long> var2, boolean var3);
}

