/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.server;

import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.message.ServerMessage;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;

public final class ErrorPacket
implements ServerMessage {
    private final short errorCode;
    private final String message;
    private final String sqlState;

    public ErrorPacket(ReadableByteBuf buf, Context context) {
        buf.skip();
        this.errorCode = buf.readShort();
        Logger logger = Loggers.getLogger(ErrorPacket.class);
        byte next = buf.getByte(buf.pos());
        if (next == 35) {
            buf.skip();
            this.sqlState = buf.readAscii(5);
            this.message = buf.readStringEof();
        } else {
            this.message = buf.readStringEof();
            this.sqlState = "HY000";
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Error: {}-{}: {}", this.errorCode, this.sqlState, this.message);
        }
        if (context != null) {
            int serverStatus = context.getServerStatus();
            context.setServerStatus(serverStatus |= 1);
        }
    }

    public short getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSqlState() {
        return this.sqlState;
    }
}

