/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.browser;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.plugin.Credential;
import com.singlestore.jdbc.plugin.CredentialPlugin;
import com.singlestore.jdbc.plugin.credential.browser.BrowserCredentialGenerator;
import com.singlestore.jdbc.plugin.credential.browser.ExpiringCredential;
import com.singlestore.jdbc.plugin.credential.browser.keyring.Keyring;
import java.sql.SQLException;

public class BrowserCredentialPlugin
implements CredentialPlugin {
    private static final String baseURL = "https://portal.singlestore.com/engine-sso";
    protected BrowserCredentialGenerator generator;
    private final Keyring keyring = Keyring.buildForCurrentOS();
    private String userEmail;
    private ExpiringCredential credential;

    @Override
    public String type() {
        return "BROWSER_SSO";
    }

    @Override
    public boolean mustUseSsl() {
        return true;
    }

    @Override
    public String defaultAuthenticationPluginType() {
        return "mysql_clear_password";
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) throws SQLException {
        this.generator = new BrowserCredentialGenerator(baseURL);
        return this;
    }

    @Override
    public synchronized Credential get() throws SQLException {
        if (this.credential != null && this.credential.isValid()) {
            return this.credential.getCredential();
        }
        ExpiringCredential cred = null;
        if (this.keyring != null) {
            cred = this.keyring.getCredential();
        }
        if (cred == null || !cred.isValid()) {
            cred = this.generator.getCredential(this.userEmail);
            if (this.keyring != null) {
                this.keyring.setCredential(cred);
            }
        }
        this.credential = cred;
        this.userEmail = cred.getEmail();
        return cred.getCredential();
    }

    public void clearLocalCache() {
        this.userEmail = null;
        this.credential = null;
    }

    public void clearKeyring() {
        if (this.keyring != null) {
            this.keyring.deleteCredential();
        }
    }
}

