/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util;

import com.singlestore.jdbc.util.Version;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class VersionFactory {
    private static Version instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Version getInstance() {
        Logger logger = Loggers.getLogger(VersionFactory.class);
        if (instance != null) return instance;
        Class<VersionFactory> clazz = VersionFactory.class;
        synchronized (VersionFactory.class) {
            if (instance != null) return instance;
            String tmpVersion = "unknown";
            try (InputStream inputStream = Version.class.getClassLoader().getResourceAsStream("singlestore-jdbc-client.properties");){
                if (inputStream == null) {
                    logger.warn("Property file 'singlestore-jdbc-client.properties' not found in the classpath");
                } else {
                    Properties prop = new Properties();
                    prop.load(inputStream);
                    String propVersion = prop.getProperty("version");
                    if (propVersion != null) {
                        tmpVersion = prop.getProperty("version");
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Failed to retrieve driver version: " + e.getMessage());
            }
            instance = new Version(tmpVersion);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }
}

