/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.block.composition.MarkdownTextObject;
import com.slack.api.model.block.composition.PlainTextObject;
import com.slack.api.model.block.composition.TextObject;
import com.slack.api.model.block.composition.UnknownTextObject;
import java.lang.reflect.Type;

public class GsonTextObjectFactory
implements JsonDeserializer<TextObject>,
JsonSerializer<TextObject> {
    private boolean failOnUnknownProperties;

    public GsonTextObjectFactory() {
        this(false);
    }

    public GsonTextObjectFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public TextObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String typeName = prim.getAsString();
        Class<? extends TextObject> clazz = this.getTextObjectClassInstance(typeName);
        return (TextObject)context.deserialize((JsonElement)jsonObject, clazz);
    }

    public JsonElement serialize(TextObject src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    private Class<? extends TextObject> getTextObjectClassInstance(String typeName) {
        switch (typeName) {
            case "plain_text": {
                return PlainTextObject.class;
            }
            case "mrkdwn": {
                return MarkdownTextObject.class;
            }
        }
        if (this.failOnUnknownProperties) {
            throw new JsonParseException("Unknown text object type: " + typeName);
        }
        return UnknownTextObject.class;
    }
}

