/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.RowAttachmentResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class RowAttachmentResourcesImpl
extends AbstractResources
implements RowAttachmentResources {
    public RowAttachmentResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public Attachment attachUrl(long sheetId, long rowId, Attachment attachment) throws SmartsheetException {
        return this.createResource(this.createPath(sheetId, rowId), Attachment.class, attachment);
    }

    @Override
    public PagedResult<Attachment> getAttachments(long sheetId, long rowId, PaginationParameters parameters) throws SmartsheetException {
        Object path = this.createPath(sheetId, rowId);
        if (parameters != null) {
            path = (String)path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper((String)path, Attachment.class);
    }

    @Override
    public Attachment attachFile(long sheetId, long rowId, File file, String contentType) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(sheetId, rowId, file, contentType);
        Util.throwIfEmpty(contentType);
        return this.attachFile(sheetId, rowId, new FileInputStream(file), contentType, file.length(), file.getName());
    }

    @Override
    public Attachment attachFile(long sheetId, long rowId, InputStream inputStream, String contentType, long contentLength, String attachmentName) throws SmartsheetException {
        Util.throwIfNull((Object)inputStream, (Object)contentType);
        return super.attachFile(this.createPath(sheetId, rowId), inputStream, contentType, contentLength, attachmentName);
    }

    private String createPath(long sheetId, long rowId) {
        return "sheets/" + sheetId + "/rows/" + rowId + "/attachments";
    }
}

