/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.ShareResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.WorkspaceFolderResources;
import com.smartsheet.api.WorkspaceResources;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.ShareResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.WorkspaceFolderResourcesImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.ContainerDestination;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Workspace;
import com.smartsheet.api.models.enums.CopyExclusion;
import com.smartsheet.api.models.enums.SourceInclusion;
import com.smartsheet.api.models.enums.WorkspaceCopyInclusion;
import com.smartsheet.api.models.enums.WorkspaceRemapExclusion;
import java.util.EnumSet;
import java.util.HashMap;

public class WorkspaceResourcesImpl
extends AbstractResources
implements WorkspaceResources {
    private static final String WORKSPACES = "workspaces";
    private WorkspaceFolderResources folders;
    private ShareResources shares;

    public WorkspaceResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.shares = new ShareResourcesImpl(smartsheet, WORKSPACES);
        this.folders = new WorkspaceFolderResourcesImpl(smartsheet);
    }

    @Override
    public PagedResult<Workspace> listWorkspaces(PaginationParameters parameters) throws SmartsheetException {
        Object path = WORKSPACES;
        if (parameters != null) {
            path = (String)path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper((String)path, Workspace.class);
    }

    @Override
    public Workspace getWorkspace(long id, Boolean loadAll, EnumSet<SourceInclusion> includes) throws SmartsheetException {
        String path = "workspaces/" + id;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        if (loadAll != null) {
            parameters.put("loadAll", Boolean.toString(loadAll));
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, Workspace.class);
    }

    @Override
    public Workspace createWorkspace(Workspace workspace) throws SmartsheetException {
        return this.createResource(WORKSPACES, Workspace.class, workspace);
    }

    @Override
    public Workspace updateWorkspace(Workspace workspace) throws SmartsheetException {
        return this.updateResource("workspaces/" + workspace.getId(), Workspace.class, workspace);
    }

    @Override
    public void deleteWorkspace(long id) throws SmartsheetException {
        this.deleteResource("workspaces/" + id, Workspace.class);
    }

    @Override
    public Workspace copyWorkspace(long workspaceId, ContainerDestination containerDestination, EnumSet<WorkspaceCopyInclusion> includes, EnumSet<WorkspaceRemapExclusion> skipRemap) throws SmartsheetException {
        return this.copyWorkspace(workspaceId, containerDestination, includes, skipRemap, null);
    }

    @Override
    @Deprecated(since="2.0.0", forRemoval=true)
    public Workspace copyWorkspace(long workspaceId, ContainerDestination containerDestination, EnumSet<WorkspaceCopyInclusion> includes, EnumSet<WorkspaceRemapExclusion> skipRemap, EnumSet<CopyExclusion> excludes) throws SmartsheetException {
        String path = "workspaces/" + workspaceId + "/copy";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("skipRemap", QueryUtil.generateCommaSeparatedList(skipRemap));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.createResource(path, Workspace.class, containerDestination);
    }

    @Override
    public WorkspaceFolderResources folderResources() {
        return this.folders;
    }

    @Override
    public ShareResources shareResources() {
        return this.shares;
    }
}

