/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.oauth;

import com.smartsheet.api.InvalidRequestException;
import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.http.HttpClientException;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.json.JSONSerializerException;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.oauth.AccessDeniedException;
import com.smartsheet.api.oauth.AccessScope;
import com.smartsheet.api.oauth.AuthorizationResult;
import com.smartsheet.api.oauth.InvalidOAuthClientException;
import com.smartsheet.api.oauth.InvalidOAuthGrantException;
import com.smartsheet.api.oauth.InvalidScopeException;
import com.smartsheet.api.oauth.InvalidTokenRequestException;
import com.smartsheet.api.oauth.OAuthAuthorizationCodeException;
import com.smartsheet.api.oauth.OAuthFlow;
import com.smartsheet.api.oauth.OAuthTokenException;
import com.smartsheet.api.oauth.Token;
import com.smartsheet.api.oauth.UnsupportedOAuthGrantTypeException;
import com.smartsheet.api.oauth.UnsupportedResponseTypeException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class OAuthFlowImpl
implements OAuthFlow {
    private HttpClient httpClient;
    private JsonSerializer jsonSerializer;
    private String clientId;
    private String clientSecret;
    private String redirectURL;
    private String authorizationURL;
    private String tokenURL;
    private static final String CODE = "code";
    private static final String CLIENT_ID = "client_id";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String ERROR = "error";
    private static final String REFRESH_TOKEN = "refresh_token";

    public OAuthFlowImpl(String clientId, String clientSecret, String redirectURL, String authorizationURL, String tokenURL, HttpClient httpClient, JsonSerializer jsonSerializer) {
        Util.throwIfNull(clientId, clientSecret, redirectURL, authorizationURL, tokenURL, httpClient, jsonSerializer);
        Util.throwIfEmpty(clientId, clientSecret, redirectURL, authorizationURL, tokenURL);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectURL = redirectURL;
        this.authorizationURL = authorizationURL;
        this.tokenURL = tokenURL;
        this.httpClient = httpClient;
        this.jsonSerializer = jsonSerializer;
    }

    @Override
    public String newAuthorizationURL(EnumSet<AccessScope> scopes, String state) {
        Util.throwIfNull(scopes);
        if (state == null) {
            state = "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("response_type", CODE);
        params.put(CLIENT_ID, this.clientId);
        params.put(REDIRECT_URI, this.redirectURL);
        params.put("state", state);
        StringBuilder scopeBuffer = new StringBuilder();
        for (AccessScope scope : scopes) {
            scopeBuffer.append(scope.name() + ",");
        }
        params.put("scope", scopeBuffer.substring(0, scopeBuffer.length() - 1));
        return QueryUtil.generateUrl(this.authorizationURL, params);
    }

    @Override
    public AuthorizationResult extractAuthorizationResult(String authorizationResponseURL) throws URISyntaxException, OAuthAuthorizationCodeException {
        Long expiresIn;
        Util.throwIfNull(authorizationResponseURL);
        Util.throwIfEmpty(authorizationResponseURL);
        URI uri = new URI(authorizationResponseURL);
        String query = uri.getQuery();
        if (query == null) {
            throw new OAuthAuthorizationCodeException("There must be a query string in the response URL");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : query.split("&")) {
            int index = param.indexOf(61);
            map.put(param.substring(0, index), param.substring(index + 1));
        }
        String error = (String)map.get(ERROR);
        if (error != null && !error.isEmpty()) {
            if ("access_denied".equals(error)) {
                throw new AccessDeniedException("Access denied.");
            }
            if ("unsupported_response_type".equals(error)) {
                throw new UnsupportedResponseTypeException("response_type must be set to \"code\".");
            }
            if ("invalid_scope".equals(error)) {
                throw new InvalidScopeException("One or more of the requested access scopes are invalid. Please check the list of access scopes");
            }
            throw new OAuthAuthorizationCodeException("An undefined error was returned of type: " + error);
        }
        AuthorizationResult authorizationResult = new AuthorizationResult();
        authorizationResult.setCode((String)map.get(CODE));
        authorizationResult.setState((String)map.get("state"));
        try {
            expiresIn = Long.parseLong((String)map.get("expires_in"));
        }
        catch (NumberFormatException ex) {
            expiresIn = 0L;
        }
        authorizationResult.setExpiresInSeconds(expiresIn);
        return authorizationResult;
    }

    @Override
    public Token obtainNewToken(AuthorizationResult authorizationResult) throws OAuthTokenException, JSONSerializerException, HttpClientException, URISyntaxException, InvalidRequestException {
        MessageDigest md;
        if (authorizationResult == null) {
            throw new IllegalArgumentException();
        }
        String doHash = this.clientSecret + "|" + authorizationResult.getCode();
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Your JVM does not support SHA-256, which is required for OAuth with Smartsheet.", e);
        }
        byte[] digest = md.digest(doHash.getBytes(StandardCharsets.UTF_8));
        String hash = Hex.encodeHexString((byte[])digest);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put(CLIENT_ID, this.clientId);
        params.put(CODE, authorizationResult.getCode());
        params.put(REDIRECT_URI, this.redirectURL);
        params.put("hash", hash);
        return this.requestToken(QueryUtil.generateUrl(this.tokenURL, params));
    }

    @Override
    public Token refreshToken(Token token) throws OAuthTokenException, JSONSerializerException, HttpClientException, URISyntaxException, InvalidRequestException {
        MessageDigest md;
        String doHash = this.clientSecret + "|" + token.getRefreshToken();
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Your JVM does not support SHA-256, which is required for OAuth with Smartsheet.", e);
        }
        byte[] digest = md.digest(doHash.getBytes(StandardCharsets.UTF_8));
        String hash = Hex.encodeHexString((byte[])digest);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", REFRESH_TOKEN);
        params.put(CLIENT_ID, this.clientId);
        params.put(REFRESH_TOKEN, token.getRefreshToken());
        params.put(REDIRECT_URI, this.redirectURL);
        params.put("hash", hash);
        return this.requestToken(QueryUtil.generateUrl(this.tokenURL, params));
    }

    private Token requestToken(String url) throws OAuthTokenException, JSONSerializerException, HttpClientException, URISyntaxException, InvalidRequestException {
        Long expiresIn;
        HttpRequest request = new HttpRequest();
        request.setUri(new URI(url));
        request.setMethod(HttpMethod.POST);
        request.setHeaders(new HashMap<String, String>());
        request.getHeaders().put("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse response = this.httpClient.request(request);
        InputStream inputStream = response.getEntity().getContent();
        Map<String, Object> map = this.jsonSerializer.deserializeMap(inputStream);
        this.httpClient.releaseConnection();
        if (response.getStatusCode() != 200 && map.get(ERROR) != null) {
            String errorDescription;
            String errorType = map.get(ERROR).toString();
            String string = errorDescription = map.get("message") == null ? "" : (String)map.get("message");
            if ("invalid_request".equals(errorType)) {
                throw new InvalidTokenRequestException(errorDescription);
            }
            if ("invalid_client".equals(errorType)) {
                throw new InvalidOAuthClientException(errorDescription);
            }
            if ("invalid_grant".equals(errorType)) {
                throw new InvalidOAuthGrantException(errorDescription);
            }
            if ("unsupported_grant_type".equals(errorType)) {
                throw new UnsupportedOAuthGrantTypeException(errorDescription);
            }
            throw new OAuthTokenException(errorDescription);
        }
        if (response.getStatusCode() != 200) {
            throw new OAuthTokenException("Token request failed with http error code: " + response.getStatusCode());
        }
        Token token = new Token();
        Object tempObj = map.get("access_token");
        token.setAccessToken(tempObj == null ? "" : (String)tempObj);
        tempObj = map.get("token_type");
        token.setTokenType(tempObj == null ? "" : (String)tempObj);
        tempObj = map.get(REFRESH_TOKEN);
        token.setRefreshToken(tempObj == null ? "" : (String)tempObj);
        try {
            expiresIn = Long.parseLong(String.valueOf(map.get("expires_in")));
        }
        catch (NumberFormatException nfe) {
            expiresIn = 0L;
        }
        token.setExpiresInSeconds(expiresIn);
        return token;
    }

    @Override
    public void revokeAccessToken(Token token) throws OAuthTokenException, JSONSerializerException, HttpClientException, URISyntaxException, InvalidRequestException {
        HttpRequest request = new HttpRequest();
        request.setUri(new URI(this.tokenURL));
        request.setMethod(HttpMethod.DELETE);
        request.setHeaders(new HashMap<String, String>());
        request.getHeaders().put("Authorization", "Bearer " + token.getAccessToken());
        HttpResponse response = this.httpClient.request(request);
        if (response.getStatusCode() != 200) {
            throw new OAuthTokenException("Token request failed with http error code: " + response.getStatusCode());
        }
        this.httpClient.releaseConnection();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public void setJsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public void setAuthorizationURL(String authorizationURL) {
        this.authorizationURL = authorizationURL;
    }

    public String getTokenURL() {
        return this.tokenURL;
    }

    public void setTokenURL(String tokenURL) {
        this.tokenURL = tokenURL;
    }
}

