/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.smartsheet.api.models.AbstractRow;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.Cell;
import com.smartsheet.api.models.Column;
import com.smartsheet.api.models.ContactObjectValue;
import com.smartsheet.api.models.CrossSheetReference;
import com.smartsheet.api.models.Discussion;
import com.smartsheet.api.models.NamedModel;
import com.smartsheet.api.models.ProjectSettings;
import com.smartsheet.api.models.SheetFilter;
import com.smartsheet.api.models.SheetSummary;
import com.smartsheet.api.models.SheetUserPermissions;
import com.smartsheet.api.models.SheetUserSettings;
import com.smartsheet.api.models.Source;
import com.smartsheet.api.models.Workspace;
import com.smartsheet.api.models.enums.AccessLevel;
import com.smartsheet.api.models.enums.AttachmentType;
import com.smartsheet.api.models.enums.ResourceManagementType;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public abstract class AbstractSheet<TRow extends AbstractRow<TColumn, TCell>, TColumn extends Column, TCell extends Cell>
extends NamedModel<Long> {
    private Long fromId;
    private Long ownerId;
    private AccessLevel accessLevel;
    private List<Attachment> attachments;
    private List<TColumn> columns;
    private List<ContactObjectValue> contactReferences;
    private Date createdAt;
    private List<CrossSheetReference> crossSheetReferences;
    private Boolean dependenciesEnabled;
    private List<Discussion> discussions;
    private EnumSet<AttachmentType> effectiveAttachmentOptions;
    private Boolean favorite;
    private List<SheetFilter> filters;
    private Boolean ganttEnabled;
    private Boolean hasSummaryFields;
    private Date modifiedAt;
    private String owner;
    private String permalink;
    private ProjectSettings projectSettings;
    private Boolean readOnly;
    private Boolean resourceManagementEnabled;
    private ResourceManagementType resourceManagementType;
    private List<TRow> rows;
    private Boolean showParentRowsForFilters;
    private Source source;
    private SheetSummary summary;
    private Integer totalRowCount;
    private SheetUserPermissions userPermissions;
    private SheetUserSettings userSettings;
    private Integer version;
    private Workspace workspace;

    public Long getFromId() {
        return this.fromId;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setFromId(Long fromId) {
        this.fromId = fromId;
        return (T)this;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setOwnerId(long ownerId) {
        this.ownerId = ownerId;
        return (T)this;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return (T)this;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return (T)this;
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setColumns(List<TColumn> columns) {
        this.columns = columns;
        return (T)this;
    }

    public List<ContactObjectValue> getContactReferences() {
        return this.contactReferences;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setContactReferences(List<ContactObjectValue> contactReferences) {
        this.contactReferences = contactReferences;
        return (T)this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return (T)this;
    }

    public List<CrossSheetReference> getCrossSheetReferences() {
        return this.crossSheetReferences;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setCrossSheetReferences(List<CrossSheetReference> crossSheetReferences) {
        this.crossSheetReferences = crossSheetReferences;
        return (T)this;
    }

    public Boolean getDependenciesEnabled() {
        return this.dependenciesEnabled;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setDependenciesEnabled(Boolean dependenciesEnabled) {
        this.dependenciesEnabled = dependenciesEnabled;
        return (T)this;
    }

    public List<Discussion> getDiscussions() {
        return this.discussions;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setDiscussions(List<Discussion> discussions) {
        this.discussions = discussions;
        return (T)this;
    }

    public EnumSet<AttachmentType> getEffectiveAttachmentOptions() {
        return this.effectiveAttachmentOptions;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setEffectiveAttachmentOptions(EnumSet<AttachmentType> effectiveAttachmentOptions) {
        this.effectiveAttachmentOptions = effectiveAttachmentOptions;
        return (T)this;
    }

    public Boolean isFavorite() {
        return this.favorite;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setFavorite(Boolean favorite) {
        this.favorite = favorite;
        return (T)this;
    }

    public List<SheetFilter> getFilters() {
        return this.filters;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setFilters(List<SheetFilter> filters) {
        this.filters = filters;
        return (T)this;
    }

    public Boolean getGanttEnabled() {
        return this.ganttEnabled;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setGanttEnabled(Boolean ganttEnabled) {
        this.ganttEnabled = ganttEnabled;
        return (T)this;
    }

    public Boolean getHasSummaryFields() {
        return this.hasSummaryFields;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setHasSummaryFields(Boolean hasSummaryFields) {
        this.hasSummaryFields = hasSummaryFields;
        return (T)this;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
        return (T)this;
    }

    public AbstractSheet<TRow, TColumn, TCell> setName(String name) {
        super.setName(name);
        return this;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setSheetName(String name) {
        super.setName(name);
        return (T)this;
    }

    @JsonIgnore(value=false)
    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setSheetId(Long id) {
        super.setId(id);
        return (T)this;
    }

    public String getOwner() {
        return this.owner;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setOwner(String owner) {
        this.owner = owner;
        return (T)this;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setPermalink(String permalink) {
        this.permalink = permalink;
        return (T)this;
    }

    public ProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setProjectSettings(ProjectSettings projectSettings) {
        this.projectSettings = projectSettings;
        return (T)this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (T)this;
    }

    public Boolean getResourceManagementEnabled() {
        return this.resourceManagementEnabled;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setResourceManagementEnabled(Boolean resourceManagementEnabled) {
        this.resourceManagementEnabled = resourceManagementEnabled;
        return (T)this;
    }

    public ResourceManagementType getResourceManagementType() {
        return this.resourceManagementType;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setResourceManagementType(ResourceManagementType resourceManagementType) {
        this.resourceManagementType = resourceManagementType;
        return (T)this;
    }

    public List<TRow> getRows() {
        return this.rows;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setRows(List<TRow> rows) {
        this.rows = rows;
        return (T)this;
    }

    public Boolean getShowParentRowsForFilters() {
        return this.showParentRowsForFilters;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setShowParentRowsForFilters(Boolean showParentRowsForFilters) {
        this.showParentRowsForFilters = showParentRowsForFilters;
        return (T)this;
    }

    public Source getSource() {
        return this.source;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setSource(Source source) {
        this.source = source;
        return (T)this;
    }

    public SheetSummary getSummary() {
        return this.summary;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setSummary(SheetSummary summary) {
        this.summary = summary;
        return (T)this;
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setTotalRowCount(Integer totalRowCount) {
        this.totalRowCount = totalRowCount;
        return (T)this;
    }

    public SheetUserPermissions getUserPermissions() {
        return this.userPermissions;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setUserPermissions(SheetUserPermissions userPermissions) {
        this.userPermissions = userPermissions;
        return (T)this;
    }

    public SheetUserSettings getUserSettings() {
        return this.userSettings;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setUserSettings(SheetUserSettings userSettings) {
        this.userSettings = userSettings;
        return (T)this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setVersion(Integer version) {
        this.version = version;
        return (T)this;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public <T extends AbstractSheet<TRow, TColumn, TCell>> T setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        return (T)this;
    }

    public TColumn getColumnByIndex(int index) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if (column.getIndex() != index) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public TColumn getColumnById(long columnId) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if ((Long)column.getId() != columnId) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public TRow getRowByRowNumber(int rowNumber) {
        if (this.rows == null) {
            return null;
        }
        AbstractRow result = null;
        for (AbstractRow row : this.rows) {
            if (row.getRowNumber() != rowNumber) continue;
            result = row;
            break;
        }
        return (TRow)result;
    }
}

