/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Errors;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;

public class FastLoadManagerPreparedStatement
implements PreparedStatement {
    private Connection managerCon = null;
    private PreparedStatement appPstmt = null;
    private boolean workloadEnabled = false;
    private ArrayList paramMetaData = null;
    private Connection m_conTera = null;
    private TDSession m_controlSession = null;
    private Connection[] fastloadCons = null;
    private boolean fastloading = false;
    private boolean checkFastloadErrorTables = false;
    private String machineName = null;
    private String userName = null;
    private String password = null;
    protected String tableName = null;
    private String tableNameErr1 = null;
    private String tableNameErr2 = null;
    private String beginLoading = null;
    private String usingInsertValues = null;
    private Statement controlStmt = null;
    protected PreparedStatement[] fastloadPrepStmts = null;
    private int fastloadPrepStmtIndex = 0;
    private int m_nCurrentRowNumber = 0;
    private int m_nFirstRowNumberInBatch = 0;
    private int numBatchedRows = 0;
    private int numBatchedRowsSent = 0;
    private int[] numBatchedRowsInPrepStmt = null;
    private boolean closed = false;
    private boolean connected = false;
    private boolean rollingback = false;
    private SQLWarning sqlWarnings = null;
    public static final int MAX_FASTLOAD_ERROR_TABLE_ROW_COUNT = Integer.MAX_VALUE;
    public static final int MAX_FASTLOAD_ERROR_TABLE_ARRAY_LENGTH = 64000;
    public static final int DEFAULT_FASTLOAD_MAX_SESSION_COUNT = 8;
    private static final int FROM_OBJECT = 1;
    private static final int FROM_STRING = 2;
    private static final int FROM_NUMBER = 3;
    private static final int FROM_DATE = 4;
    private static final int FROM_TIME = 5;
    private static final int FROM_TIMESTAMP = 6;
    public static final BigInteger MIN_BYTE_BIGINTEGER = BigInteger.valueOf(-128L);
    public static final BigInteger MAX_BYTE_BIGINTEGER = BigInteger.valueOf(127L);
    public static final BigInteger MIN_INTEGER_BIGINTEGER = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MAX_INTEGER_BIGINTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger MIN_LONG_BIGINTEGER = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger MAX_LONG_BIGINTEGER = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_SHORT_BIGINTEGER = BigInteger.valueOf(-32768L);
    public static final BigInteger MAX_SHORT_BIGINTEGER = BigInteger.valueOf(32767L);

    public FastLoadManagerPreparedStatement(FastLoadManagerConnection fastLoadManagerConnection, String string, String string2, String string3, String string4, String string5, String string6, PreparedStatement preparedStatement, ArrayList arrayList) throws SQLException {
        this.managerCon = fastLoadManagerConnection;
        this.machineName = string;
        this.userName = string2;
        this.password = string3;
        this.tableName = Utility.quoteName(string4) + "." + Utility.quoteName(string5);
        URLParameters uRLParameters = ((FastLoadManagerConnection)this.managerCon).getURLParameters();
        String string7 = uRLParameters.getErrorTableDatabase() != null ? uRLParameters.getErrorTableDatabase() : string4;
        this.tableNameErr1 = Utility.quoteName(string7) + "." + Utility.quoteName(string5 + uRLParameters.getErrorTable1Suffix());
        this.tableNameErr2 = Utility.quoteName(string7) + "." + Utility.quoteName(string5 + uRLParameters.getErrorTable2Suffix());
        this.beginLoading = "BEGIN LOADING " + this.tableName + " ERRORFILES " + this.tableNameErr1 + ", " + this.tableNameErr2 + " WITH INTERVAL";
        this.usingInsertValues = string6;
        this.appPstmt = preparedStatement;
        this.paramMetaData = arrayList;
    }

    private SQLException flatten(SQLException sQLException) {
        return ((FastLoadManagerConnection)this.managerCon).flatten(sQLException);
    }

    protected void abortIfClosed() throws SQLException {
        if (this.managerCon.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.closed) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfColumnTypeIsStruct(int n) throws SQLException {
        if (n < 1 || n > this.paramMetaData.size()) {
            return;
        }
        FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)this.paramMetaData.get(n - 1);
        if (FastLoadManagerPreparedStatement.preferredSqlType(JDBC4Constants.getJavaSQLType(fullContentMetadataItem.getDataType())) == 2002) {
            throw ErrorFactory.makeDriverJDBCException("TJ742", String.valueOf(n), fullContentMetadataItem.getCustomerVisibleColumnTypeName(), this.tableName);
        }
    }

    protected void initializeFastLoad() throws SQLException {
        try {
            this.connectFastLoad();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = ErrorFactory.makeDriverJDBCException("TJ459", this.tableName);
            sQLException2.setNextException(sQLException);
            sQLException2 = this.flatten(sQLException2);
            throw sQLException2;
        }
    }

    protected static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    private void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = sQLWarning;
        } else {
            this.sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSessionsCount(int n) throws SQLException {
        int n2;
        Object object;
        this.workloadEnabled = false;
        if (this.m_controlSession.useCheckWorkload()) {
            try (Statement statement = this.managerCon.createStatement();){
                Object object2;
                this.controlStmt.executeUpdate("SET QUERY_BAND='UtilityName=JDBCL;' FOR SESSION");
                object = statement.executeQuery("HELP SESSION");
                try {
                    if (object.next()) {
                        object2 = Utility.parseQueryBand(Utility.getQueryBandFromHelpSessionResultSet((ResultSet)object));
                        if (!object2[1].equals("")) {
                            this.controlStmt.executeUpdate("SET QUERY_BAND='" + object2[1] + "' UPDATE FOR SESSION");
                        }
                        if (Utility.getUnicodePassThroughFromHelpSessionResultSet((ResultSet)object)) {
                            this.controlStmt.executeUpdate("SET SESSION CHARACTER SET UNICODE PASS THROUGH ON");
                        }
                    }
                }
                finally {
                    object.close();
                }
                this.controlStmt.executeUpdate("CHECK WORKLOAD FOR " + this.beginLoading);
                object2 = (!((FastLoadManagerConnection)this.managerCon).getURLParameters().isGoverned() ? "{fn TERADATA_FAILFAST}" : "") + "CHECK WORKLOAD END";
                object = this.controlStmt.executeQuery((String)object2);
                try {
                    ResultSetMetaData resultSetMetaData = object.getMetaData();
                    if (object.next() && resultSetMetaData.getColumnCount() >= 2 && object.getString(1) != null) {
                        if (object.getString(1).trim().equalsIgnoreCase("Y")) {
                            int n3 = object.getInt(2);
                            if (n3 > 0) {
                                int n4 = n == 0 ? n3 : Math.min(n, n3);
                                this.workloadEnabled = true;
                                if (n4 < n) {
                                    SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ615", String.valueOf(n), String.valueOf(n4), this.usingInsertValues);
                                    this.chainSQLWarnings(sQLWarning);
                                }
                                int n5 = n4;
                                return n5;
                            }
                            ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad received no valid SESSIONS count from " + (String)object2 + ", thus assuming default SESSIONS count.");
                        } else {
                            ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad was told to assume default SESSIONS count by " + (String)object2 + ".");
                        }
                    } else {
                        ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad received no valid ResultSet from " + (String)object2 + ", thus assuming default SESSIONS count.");
                    }
                }
                finally {
                    object.close();
                }
            }
        }
        int n6 = Integer.parseInt(this.m_controlSession.getAMPCount());
        if (n == 0) {
            n2 = Math.min(8, n6);
        } else {
            n2 = Math.min(n, n6);
            if (n2 < n) {
                object = ErrorFactory.makeSQLWarning("TJ616", String.valueOf(n), String.valueOf(n2), this.usingInsertValues);
                this.chainSQLWarnings((SQLWarning)object);
            }
        }
        return n2;
    }

    private void connectFastLoad() throws SQLException {
        if (!this.connected) {
            SQLException sQLException = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            try {
                int n6;
                URLParameters uRLParameters = ((FastLoadManagerConnection)this.managerCon).getURLParameters();
                n3 = uRLParameters.getSessions();
                boolean bl = uRLParameters.isGoverned() || ((FastLoadManagerConnection)this.managerCon).isFailFastSupported();
                String string = bl ? ",LSS_TYPE=L" : "";
                this.connected = true;
                URLParameters uRLParameters2 = new URLParameters(uRLParameters.getDelegatedParameters() + "," + "TMODE" + "=TERA" + string + "," + "CONNECT_FUNCTION" + "=" + 1);
                this.m_controlSession = (TDSession)ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters2);
                URLParameters uRLParameters3 = new URLParameters(uRLParameters.getDelegatedParameters() + "," + "TMODE" + "=TERA" + string + "," + "CONNECT_FUNCTION" + "=" + 2 + "," + "LOGON_SEQUENCE_NUMBER" + "=" + this.m_controlSession.getLogonSequenceNumber());
                this.m_conTera = ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters3);
                n = Integer.parseInt(this.m_controlSession.getAMPCount());
                this.controlStmt = this.m_controlSession.createStatement();
                n2 = this.getSessionsCount(n3);
                URLParameters uRLParameters4 = new URLParameters(uRLParameters.getDelegatedParameters() + string + "," + "PARTITION" + "=" + "FASTLOAD" + "," + "CONNECT_FUNCTION" + "=" + 2 + "," + "LOGON_SEQUENCE_NUMBER" + "=" + this.m_controlSession.getLogonSequenceNumber());
                this.fastloadCons = new Connection[n2];
                for (n6 = 0; n6 < this.fastloadCons.length; ++n6) {
                    this.fastloadCons[n6] = ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters4);
                    ++n4;
                }
                this.fastloadPrepStmts = new PreparedStatement[this.fastloadCons.length];
                for (n6 = 0; n6 < this.fastloadPrepStmts.length; ++n6) {
                    this.fastloadPrepStmts[n6] = this.fastloadCons[n6].prepareStatement(null);
                    if (n6 > 0) {
                        ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).shareWorkingRow((FastLoadPreparedStatement)this.fastloadPrepStmts[0]);
                    }
                    ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).setParameterMetaData(this.paramMetaData);
                    ++n5;
                }
                ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad found " + n + " AMP(s) in " + this.machineName + " and created " + n4 + (this.workloadEnabled ? " workload" : "") + " FastLoadConnection(s) and " + n5 + " FastLoadPreparedStatement(s) with SESSIONS=" + n3 + ".");
                this.numBatchedRowsInPrepStmt = new int[this.fastloadPrepStmts.length];
                for (n6 = 0; n6 < this.numBatchedRowsInPrepStmt.length; ++n6) {
                    this.numBatchedRowsInPrepStmt[n6] = 0;
                }
            }
            catch (SQLException sQLException2) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                try {
                    this.closeFastLoad();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ518", this.tableName, String.valueOf(n), String.valueOf(n4), String.valueOf(n5), String.valueOf(n3));
                sQLException4.setNextException(sQLException);
                sQLException4 = this.flatten(sQLException4);
                throw sQLException4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFastLoad() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            try {
                SQLException sQLException2;
                if (this.m_conTera != null) {
                    try {
                        this.m_conTera.close();
                    }
                    catch (SQLException sQLException3) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
                if (this.fastloadPrepStmts != null) {
                    for (int i = 0; i < this.fastloadPrepStmts.length; ++i) {
                        if (this.fastloadPrepStmts[i] == null) continue;
                        try {
                            this.fastloadPrepStmts[i].close();
                            continue;
                        }
                        catch (SQLException sQLException4) {
                            sQLException2 = ErrorFactory.makeDriverJDBCException("TJ468", i, this.fastloadPrepStmts.length);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                        }
                    }
                }
                if (this.controlStmt != null) {
                    try {
                        this.controlStmt.close();
                    }
                    catch (SQLException sQLException5) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                    }
                }
                if (this.fastloadCons != null) {
                    for (int i = 0; i < this.fastloadCons.length; ++i) {
                        if (this.fastloadCons[i] == null) continue;
                        try {
                            this.fastloadCons[i].close();
                            continue;
                        }
                        catch (SQLException sQLException6) {
                            sQLException2 = ErrorFactory.makeDriverJDBCException("TJ470", i, this.fastloadCons.length);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                        }
                    }
                }
                if (this.m_controlSession != null) {
                    try {
                        this.m_controlSession.close();
                    }
                    catch (SQLException sQLException7) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException7);
                    }
                }
            }
            finally {
                this.connected = false;
                this.fastloadPrepStmts = null;
                this.controlStmt = null;
                this.fastloadCons = null;
                this.m_controlSession = null;
            }
            if (sQLException != null) {
                SQLException sQLException8 = ErrorFactory.makeDriverJDBCException("TJ519", this.tableName);
                sQLException8.setNextException(sQLException);
                sQLException8 = this.flatten(sQLException8);
                throw sQLException8;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryExecuteCreateOrDrop(Statement statement, String string) throws SQLException {
        SQLException sQLException = null;
        try {
            try {
                for (int i = 1; i <= 5; ++i) {
                    sQLException = null;
                    try {
                        statement.execute(string);
                        break;
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException2.getErrorCode() != 2631) {
                            throw sQLException2;
                        }
                        sQLException = sQLException2;
                        ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad is ignoring retryable error " + sQLException2.getErrorCode() + ". Now sleeping for 5 seconds to allow error condition to clear...");
                        Utility.sleepForSeconds(5);
                        continue;
                    }
                }
            }
            finally {
                statement.close();
            }
        }
        finally {
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    private void executeCreateOrDrop(Statement statement, String string) throws SQLException {
        try {
            this.retryExecuteCreateOrDrop(statement, string);
        }
        catch (SQLException sQLException) {
            switch (sQLException.getErrorCode()) {
                case 3807: {
                    break;
                }
                default: {
                    throw sQLException;
                }
            }
        }
    }

    private void dropFastLoadErrorTables() throws SQLException {
        this.executeCreateOrDrop(this.controlStmt, "DROP TABLE " + this.tableNameErr1);
        this.executeCreateOrDrop(this.controlStmt, "DROP TABLE " + this.tableNameErr2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFastLoadErrorTableRowCount(String string) throws SQLException {
        Object object;
        SQLException sQLException = null;
        int n = -1;
        String string2 = "LOCKING " + string + " FOR ACCESS SELECT COUNT(*) FROM " + string;
        try {
            object = this.controlStmt.executeQuery(string2);
            try {
                if (object.next()) {
                    n = object.getInt(1);
                }
            }
            finally {
                object.close();
            }
        }
        catch (SQLException sQLException2) {
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ517", string);
            ((SQLException)object).setNextException(sQLException);
            object = this.flatten((SQLException)object);
            throw object;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFastLoadErrorTable2Rows() throws SQLException {
        Object object;
        String string = "LOCKING " + this.tableNameErr2 + " FOR ACCESS SELECT * FROM " + this.tableNameErr2;
        SQLException sQLException = null;
        try {
            object = this.controlStmt.executeQuery(string);
            try {
                ResultSetMetaData resultSetMetaData = object.getMetaData();
                for (int i = 1; object.next() && i <= Integer.MAX_VALUE; ++i) {
                    SQLException sQLException2;
                    String[] stringArray = new String[resultSetMetaData.getColumnCount()];
                    Object[] objectArray = new Object[resultSetMetaData.getColumnCount()];
                    for (int j = 1; j <= resultSetMetaData.getColumnCount(); ++j) {
                        stringArray[j - 1] = resultSetMetaData.getColumnName(j);
                        objectArray[j - 1] = object.getObject(j);
                    }
                    String string2 = null;
                    for (int j = 0; j < resultSetMetaData.getColumnCount(); ++j) {
                        int n;
                        Object object2;
                        if (objectArray[j] instanceof byte[]) {
                            object2 = (byte[])objectArray[j];
                            n = object2 == null ? 0 : ((Object)object2).length;
                            int n2 = n = n < 64000 ? n : 64000;
                            if (j == 0) {
                                string2 = "\n" + Log.formatPartialByteArray(stringArray[j], (byte[])object2, 0, n);
                                continue;
                            }
                            string2 = string2 + "\n" + Log.formatPartialByteArray(stringArray[j], (byte[])object2, 0, n);
                            continue;
                        }
                        object2 = String.valueOf(objectArray[j]);
                        n = ((String)object2).length() < 64000 ? ((String)object2).length() : 64000;
                        String string3 = "";
                        if (objectArray[j] != null && n != 0 && ((String)object2).length() > 64000) {
                            string3 = " (only showing string length " + n + " of " + ((String)object2).length() + ")";
                        }
                        string2 = j == 0 ? "\n" + stringArray[j] + "=" + ((String)object2).substring(0, n) + string3 : string2 + "\n" + stringArray[j] + "=" + ((String)object2).substring(0, n) + string3;
                    }
                    if (this.rollingback) {
                        sQLException2 = ErrorFactory.makeSQLWarning("TJ473", this.tableNameErr2, string2);
                        ((FastLoadManagerConnection)this.managerCon).addWarning((SQLWarning)sQLException2);
                        continue;
                    }
                    sQLException2 = ErrorFactory.makeDriverJDBCException("TJ473", this.tableNameErr2, string2);
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            finally {
                object.close();
            }
        }
        catch (SQLException sQLException3) {
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ475", this.tableNameErr2);
            ((SQLException)object).setNextException(sQLException);
            object = this.flatten((SQLException)object);
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFastLoadErrorTable1RowCount(int n) throws SQLException {
        URLParameters uRLParameters = ((FastLoadManagerConnection)this.managerCon).getURLParameters();
        Log log = ((FastLoadManagerConnection)this.managerCon).getLog();
        String string = "LOCKING " + this.tableNameErr1 + " FOR ACCESS" + " SELECT COUNT(*) FROM " + this.tableNameErr1 + " WHERE CAST(SUBSTRING(DataParcel FROM BYTES(DataParcel) - 3 FOR 4) AS BYTE(4)) >= '" + Log.leadingZeros(Integer.toHexString(this.m_nFirstRowNumberInBatch), 8) + "'xb";
        try (Statement statement = this.m_conTera.createStatement();){
            try {
                int n2 = 0;
                for (int i = 1; n2 != n && i <= uRLParameters.getErrorQueryCount(); ++i) {
                    if (i > 1) {
                        Utility.sleepForMilliseconds(uRLParameters.getErrorQueryInterval());
                    }
                    if (log.canLog(1)) {
                        log.info(string);
                    }
                    try (ResultSet resultSet = statement.executeQuery(string);){
                        resultSet.next();
                        n2 = resultSet.getInt(1);
                        continue;
                    }
                }
                if (n2 != n) {
                    throw ErrorFactory.makeDriverJDBCException("TJ840", String.valueOf(n), String.valueOf(n2), this.tableNameErr1);
                }
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = ErrorFactory.makeDriverJDBCException("TJ517", this.tableNameErr1);
                sQLException2.setNextException(sQLException);
                sQLException2 = this.flatten(sQLException2);
                throw sQLException2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException selectFastLoadErrorTable1Rows(int[] nArray) throws SQLException {
        String string = "LOCKING " + this.tableNameErr1 + " FOR ACCESS " + "SELECT ErrorCode" + ", ErrorFieldName" + ", CAST(SUBSTRING(DataParcel FROM BYTES(DataParcel) - 3 FOR 4) AS BYTE(4)) AS RowNumber" + " FROM " + this.tableNameErr1 + " WHERE RowNumber >= '" + Log.leadingZeros(Integer.toHexString(this.m_nFirstRowNumberInBatch), 8) + "'xb" + " ORDER BY RowNumber";
        SQLException sQLException = null;
        try (Statement statement = this.m_conTera.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            Arrays.fill(nArray, 1);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (resultSet.next()) {
                SQLException sQLException2;
                int n = resultSet.getInt(1);
                String string2 = Utility.quoteName(resultSet.getString(2).substring(2));
                String string3 = n + "," + string2;
                String string4 = (String)hashMap.get(string3);
                if (string4 == null) {
                    sQLException2 = ErrorFactory.makeErrorCodeOnlyDatabaseSQLException(n, "TJ813", String.valueOf(n), this.tableName + "." + string2);
                    hashMap.put(string3, sQLException2.getMessage());
                } else {
                    sQLException2 = new SQLException(string4, Errors.getSQLState(n), n);
                }
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                nArray[ByteConverter.getInt((byte[])resultSet.getBytes((int)3), (int)0) - this.m_nFirstRowNumberInBatch] = -3;
            }
        }
        return sQLException;
    }

    private void selectFastLoadErrorTables() throws SQLException {
        SQLException sQLException = null;
        try {
            int n = this.getFastLoadErrorTableRowCount(this.tableNameErr2);
            if (n != 0) {
                SQLException sQLException2;
                if (this.rollingback) {
                    sQLException2 = ErrorFactory.makeSQLWarning("TJ562", String.valueOf(n), this.tableNameErr2, String.valueOf(Integer.MAX_VALUE));
                    ((FastLoadManagerConnection)this.managerCon).addWarning((SQLWarning)sQLException2);
                } else {
                    sQLException2 = ErrorFactory.makeDriverJDBCException("TJ472", String.valueOf(n), this.tableNameErr2, String.valueOf(Integer.MAX_VALUE));
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                try {
                    this.selectFastLoadErrorTable2Rows();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
            }
        }
        catch (SQLException sQLException4) {
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
        }
        if (sQLException != null) {
            sQLException = this.flatten(sQLException);
            throw sQLException;
        }
    }

    private void abortFastLoad() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            boolean bl = false;
            try {
                if (!this.fastloading) {
                    try {
                        this.controlStmt.executeQuery("SELECT 1 FROM " + this.tableName + " WHERE 1=2");
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException2.getErrorCode() == 2652) {
                            bl = true;
                        }
                        throw sQLException2;
                    }
                } else {
                    this.closeFastLoad();
                    this.connectFastLoad();
                }
                if (this.fastloading || bl) {
                    this.m_controlSession.setAutoCommit(true);
                    this.controlStmt.execute(this.beginLoading);
                    this.m_controlSession.setAutoCommit(false);
                    this.controlStmt.executeUpdate("END LOADING");
                    this.m_controlSession.commit();
                    this.m_controlSession.setAutoCommit(true);
                    if (this.checkFastloadErrorTables && !bl) {
                        try {
                            this.selectFastLoadErrorTables();
                        }
                        catch (SQLException sQLException3) {
                            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                        }
                    }
                    this.controlStmt.executeUpdate("DELETE " + this.tableName + " ALL");
                }
                this.dropFastLoadErrorTables();
            }
            catch (SQLException sQLException4) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
            }
            if (sQLException != null) {
                SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ477", this.tableName);
                sQLException5.setNextException(sQLException);
                sQLException5 = this.flatten(sQLException5);
                throw sQLException5;
            }
        }
    }

    private void beginFastLoad() throws SQLException {
        if (this.connected && !this.fastloading) {
            SQLException sQLException = null;
            try {
                this.abortFastLoad();
                try {
                    this.controlStmt.executeUpdate("SET SESSION DateForm = IntegerDate");
                    this.controlStmt.execute(this.beginLoading);
                    this.fastloading = true;
                    this.m_controlSession.setAutoCommit(false);
                    this.controlStmt.executeUpdate(this.usingInsertValues);
                    this.checkFastloadErrorTables = true;
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    try {
                        this.abortFastLoad();
                    }
                    catch (SQLException sQLException3) {
                        sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
            }
            catch (SQLException sQLException4) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
            }
            if (sQLException != null) {
                SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ460", this.tableName);
                sQLException5.setNextException(sQLException);
                sQLException5 = this.flatten(sQLException5);
                throw sQLException5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFastLoad() throws SQLException {
        if (this.connected && this.fastloading) {
            SQLException sQLException = null;
            try {
                this.controlStmt.executeUpdate("CHECKPOINT LOADING END");
                this.m_controlSession.commit();
                int n = this.controlStmt.executeUpdate("END LOADING");
                if (n != this.numBatchedRowsSent) {
                    SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ476", String.valueOf(this.numBatchedRowsSent - n), this.tableName, String.valueOf(this.numBatchedRowsSent), String.valueOf(n));
                    ((FastLoadManagerConnection)this.managerCon).addWarning(sQLWarning);
                }
                this.m_controlSession.commit();
                this.m_controlSession.setAutoCommit(true);
                try {
                    this.selectFastLoadErrorTables();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                this.dropFastLoadErrorTables();
                this.closeFastLoad();
            }
            catch (SQLException sQLException3) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                try {
                    this.abortFastLoad();
                }
                catch (SQLException sQLException4) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                }
            }
            finally {
                this.fastloading = false;
                this.numBatchedRowsSent = 0;
                this.m_nCurrentRowNumber = 0;
                this.checkFastloadErrorTables = false;
                if (this.closed) {
                    ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                }
            }
            if (sQLException != null) {
                SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ461", this.tableName);
                sQLException5.setNextException(sQLException);
                sQLException5 = this.flatten(sQLException5);
                throw sQLException5;
            }
        }
    }

    protected void rollbackFastLoad() throws SQLException {
        if (this.connected && this.fastloading) {
            SQLException sQLException = null;
            try {
                this.rollingback = true;
                this.abortFastLoad();
                if (this.closed) {
                    this.closeFastLoad();
                }
            }
            catch (SQLException sQLException2) {
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            finally {
                this.fastloading = false;
                this.numBatchedRowsSent = 0;
                this.m_nCurrentRowNumber = 0;
                this.checkFastloadErrorTables = false;
                this.rollingback = false;
                if (this.closed) {
                    ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
                }
            }
            if (sQLException != null) {
                SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ478", this.tableName);
                sQLException3.setNextException(sQLException);
                sQLException3 = this.flatten(sQLException3);
                throw sQLException3;
            }
        }
    }

    protected String getLogonSequenceNumber() {
        if (this.connected) {
            return this.m_controlSession.getLogonSequenceNumber();
        }
        return "";
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected boolean isFastLoading() {
        return this.fastloading;
    }

    @Override
    public void addBatch() throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        int n = this.fastloadPrepStmtIndex;
        try {
            boolean bl;
            this.fastloadPrepStmts[this.fastloadPrepStmtIndex].addBatch();
            int n2 = this.fastloadPrepStmtIndex;
            this.numBatchedRowsInPrepStmt[n2] = this.numBatchedRowsInPrepStmt[n2] + 1;
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[this.fastloadPrepStmtIndex]).addRowNumber(++this.m_nCurrentRowNumber);
            ++this.fastloadPrepStmtIndex;
            if (this.fastloadPrepStmtIndex >= this.fastloadPrepStmts.length) {
                this.fastloadPrepStmtIndex = 0;
            }
            ++this.numBatchedRows;
            boolean bl2 = bl = this.numBatchedRows == 1;
            if (bl) {
                this.m_nFirstRowNumberInBatch = this.m_nCurrentRowNumber;
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", n, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ462", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        if (this.connected) {
            SQLException sQLException = null;
            try {
                this.fastloadPrepStmts[0].clearParameters();
            }
            catch (SQLException sQLException2) {
                SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            if (sQLException != null) {
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ463", this.tableName);
                sQLException4.setNextException(sQLException);
                sQLException4 = this.flatten(sQLException4);
                throw sQLException4;
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getParameterMetaData();
    }

    private static int preferredSqlType(int n) {
        switch (n) {
            case -4: 
            case -2: {
                return -3;
            }
            case 7: 
            case 8: {
                return 6;
            }
            case -1: 
            case 1: 
            case 1111: {
                return 12;
            }
        }
        return n;
    }

    private Object automaticDataTypeConversion(int n, int n2, Object object) throws SQLException {
        ObjectWithAttributes objectWithAttributes = object instanceof ObjectWithAttributes ? (ObjectWithAttributes)object : new ObjectWithAttributes(object);
        object = objectWithAttributes.object;
        if (n2 < 1 || n2 > this.paramMetaData.size()) {
            return object;
        }
        FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)this.paramMetaData.get(n2 - 1);
        int n3 = FastLoadManagerPreparedStatement.preferredSqlType(JDBC4Constants.getJavaSQLType(fullContentMetadataItem.getDataType()));
        if (objectWithAttributes.bUserSpecifiedType) {
            objectWithAttributes.targetSqlType = FastLoadManagerPreparedStatement.preferredSqlType(objectWithAttributes.targetSqlType);
            if (objectWithAttributes.targetSqlType == 2 && n3 == 3) {
                objectWithAttributes.targetSqlType = n3;
            }
            if (objectWithAttributes.targetSqlType != n3) {
                throw ErrorFactory.makeDriverJDBCException("TJ532", String.valueOf(n2), String.valueOf(objectWithAttributes.targetSqlType), String.valueOf(n3), this.tableName);
            }
        } else {
            objectWithAttributes.targetSqlType = n3;
        }
        if (objectWithAttributes.bUserSpecifiedScale) {
            if (n3 == 3 && objectWithAttributes.targetScale != fullContentMetadataItem.getNumberOfFractionalDigits()) {
                throw ErrorFactory.makeDriverJDBCException("TJ533", String.valueOf(n2), String.valueOf(objectWithAttributes.targetScale), String.valueOf(fullContentMetadataItem.getNumberOfFractionalDigits()), this.tableName);
            }
        } else {
            objectWithAttributes.targetScale = fullContentMetadataItem.getNumberOfFractionalDigits();
        }
        if (n3 == 2002 && (object != null && !(object instanceof SQLData) && !(object instanceof Struct) || object == null && n != 1)) {
            throw ErrorFactory.makeDriverJDBCException("TJ742", String.valueOf(n2), fullContentMetadataItem.getCustomerVisibleColumnTypeName(), this.tableName);
        }
        try {
            if (n == 1 && object == null) {
                object = new SupportedButNull(objectWithAttributes);
            } else if (n == 2 || object instanceof String) {
                if (objectWithAttributes.targetSqlType == -6) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Byte.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == 5) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Short.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == 4) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Integer.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == -5) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Long.valueOf(new BigDecimal((String)object).toBigInteger().toString());
                } else if (objectWithAttributes.targetSqlType == 6) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Double.valueOf((String)object);
                } else if (objectWithAttributes.targetSqlType == 3 || objectWithAttributes.targetSqlType == 2) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new BigDecimal((String)object);
                } else if (objectWithAttributes.targetSqlType == 91) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Date.valueOf((String)object);
                } else if (objectWithAttributes.targetSqlType == 92) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Time.valueOf((String)object);
                } else if (objectWithAttributes.targetSqlType == 93) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : Timestamp.valueOf((String)object);
                }
            } else if (n == 3 || object instanceof Number) {
                if (objectWithAttributes.targetSqlType == 12) {
                    if (object instanceof BigDecimal && ((BigDecimal)object).scale() < 0) {
                        object = ((BigDecimal)object).movePointRight(0);
                    }
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == -6 && !(object instanceof Byte)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == 5 && !(object instanceof Short)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == 4 && !(object instanceof Integer)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == -5 && !(object instanceof Long)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : this.getIntegralObject(n2, object, objectWithAttributes.targetSqlType);
                } else if (objectWithAttributes.targetSqlType == 6 && !(object instanceof Double)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Double(Double.valueOf(object.toString()));
                } else if (!(objectWithAttributes.targetSqlType != 3 && objectWithAttributes.targetSqlType != 2 || object instanceof BigDecimal)) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new BigDecimal(object.toString());
                }
            } else if (n == 4 || object instanceof Date) {
                if (objectWithAttributes.targetSqlType == 12) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == 93) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Timestamp(((Date)object).getTime());
                }
            } else if (n == 5 || object instanceof Time) {
                if (objectWithAttributes.targetSqlType == 12) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == 93) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Timestamp(((Time)object).getTime());
                }
            } else if (n == 6 || object instanceof Timestamp) {
                if (objectWithAttributes.targetSqlType == 12) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : object.toString();
                } else if (objectWithAttributes.targetSqlType == 91) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Date(((Timestamp)object).getTime());
                } else if (objectWithAttributes.targetSqlType == 92) {
                    object = object == null ? new SupportedButNull(objectWithAttributes) : new Time(((Timestamp)object).getTime());
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ553", n2, objectWithAttributes.targetSqlType);
            sQLException.initCause(exception);
            throw sQLException;
        }
        if (object instanceof BigDecimal && n3 != 2) {
            boolean bl = false;
            if (objectWithAttributes.bUserSpecifiedScale) {
                if (objectWithAttributes.targetScale >= 0) {
                    bl = true;
                }
            } else {
                objectWithAttributes.targetScale = fullContentMetadataItem.getNumberOfFractionalDigits();
                bl = true;
            }
            if (bl) {
                object = ((BigDecimal)object).setScale(objectWithAttributes.targetScale, 4);
            }
        }
        return object;
    }

    private int getIntegralDataSize(Object object) {
        if (!(object instanceof BigDecimal)) {
            object = new BigDecimal(((Number)object).toString());
        }
        return ((BigDecimal)object).toBigInteger().bitLength() / 8 + 1;
    }

    private Object getIntegralObject(int n, Object object, int n2) throws SQLException {
        if (object instanceof BigDecimal || object instanceof Float || object instanceof Double) {
            BigInteger bigInteger = object instanceof BigDecimal ? ((BigDecimal)object).toBigInteger() : new BigDecimal(object.toString()).toBigInteger();
            switch (n2) {
                case -5: {
                    if (bigInteger.compareTo(MIN_LONG_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_LONG_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 8);
                    }
                    object = new Long(bigInteger.longValue());
                    break;
                }
                case 4: {
                    if (bigInteger.compareTo(MIN_INTEGER_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_INTEGER_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 4);
                    }
                    object = new Integer(bigInteger.intValue());
                    break;
                }
                case 5: {
                    if (bigInteger.compareTo(MIN_SHORT_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_SHORT_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 2);
                    }
                    object = new Short(bigInteger.shortValue());
                    break;
                }
                case -6: {
                    if (bigInteger.compareTo(MIN_BYTE_BIGINTEGER) < 0 || bigInteger.compareTo(MAX_BYTE_BIGINTEGER) > 0) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 1);
                    }
                    object = new Byte(bigInteger.byteValue());
                }
            }
        } else if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            long l = ((Number)object).longValue();
            switch (n2) {
                case -5: {
                    object = new Long(l);
                    break;
                }
                case 4: {
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 4);
                    }
                    object = new Integer(((Number)object).intValue());
                    break;
                }
                case 5: {
                    if (l < -32768L || l > 32767L) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 2);
                    }
                    object = new Short(((Number)object).shortValue());
                    break;
                }
                case -6: {
                    if (l < -128L || l > 127L) {
                        throw ErrorFactory.makeTDDataTruncation("TJ539", n, true, false, this.getIntegralDataSize(object), 1);
                    }
                    object = new Byte(((Number)object).byteValue());
                }
            }
        }
        return object;
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setArray(n, array);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, bigDecimal);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setBigDecimal(n, bigDecimal);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBlob(n, blob);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBoolean(n, bl);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Byte(by));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        this.abortIfColumnTypeIsStruct(n);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setBytes(n, byArray);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setClob(n, clob);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(4, n, date);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setDate(n, date);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        this.abortIfColumnTypeIsStruct(n);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setDate(n, date, calendar);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Double(d));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Float(f));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Integer(n2));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Long(l));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(1, n, new ObjectWithAttributes(null, n2));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else {
                this.fastloadPrepStmts[0].setNull(n, n2);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setNull(n, n2, string);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        object = this.automaticDataTypeConversion(1, n, object);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else {
                this.fastloadPrepStmts[0].setObject(n, object);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        String string = object instanceof String ? (String)object : null;
        boolean bl = string != null && n2 == 92;
        boolean bl2 = string != null && n2 == 93;
        int[] nArray = new int[]{0};
        Calendar[] calendarArray = new Calendar[]{null};
        if (bl) {
            try {
                object = TDResultSet.convertObjectToDateTimeValue(n, string, null, false, true, nArray, calendarArray);
            }
            catch (Exception exception) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
                sQLException.initCause(exception);
                throw sQLException;
            }
        } else if (bl2) {
            try {
                object = TDResultSet.convertObjectToDateTimeValue(n, string, null, false, false, null, calendarArray);
            }
            catch (Exception exception) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
                sQLException.initCause(exception);
                throw sQLException;
            }
        } else {
            object = this.automaticDataTypeConversion(1, n, new ObjectWithAttributes(object, n2));
        }
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (bl && nArray[0] <= 3) {
                this.setTime(n, (Time)object, calendarArray[0]);
            } else if (bl) {
                this.setObject(n, new Object[]{object, calendarArray[0], string});
            } else if (bl2) {
                this.fastloadPrepStmts[0].setTimestamp(n, (Timestamp)object, calendarArray[0]);
            } else {
                this.fastloadPrepStmts[0].setObject(n, object, n2);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        object = this.automaticDataTypeConversion(1, n, new ObjectWithAttributes(object, n2, n3));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else {
                this.fastloadPrepStmts[0].setObject(n, object, n2, n3);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setRef(n, ref);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(3, n, new Short(s));
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setObject(n, object);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(2, n, string);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setString(n, string);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(5, n, time);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setTime(n, time);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        this.abortIfColumnTypeIsStruct(n);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setTime(n, time, calendar);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        Object object = this.automaticDataTypeConversion(6, n, timestamp);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            if (object instanceof SupportedButNull) {
                this.fastloadPrepStmts[0].setObject(n, null, ((SupportedButNull)object).targetSqlType, ((SupportedButNull)object).targetScale);
            } else if (object != null) {
                this.fastloadPrepStmts[0].setObject(n, object);
            } else {
                this.fastloadPrepStmts[0].setTimestamp(n, timestamp);
            }
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        this.abortIfColumnTypeIsStruct(n);
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setURL(n, uRL);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        this.numBatchedRows = 0;
        this.fastloadPrepStmtIndex = 0;
        if (this.connected) {
            int n;
            SQLException sQLException = null;
            for (n = 0; n < this.fastloadPrepStmts.length; ++n) {
                try {
                    this.fastloadPrepStmts[n].clearBatch();
                    continue;
                }
                catch (SQLException sQLException2) {
                    SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", n, this.fastloadPrepStmts.length);
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            for (n = 0; n < this.numBatchedRowsInPrepStmt.length; ++n) {
                this.numBatchedRowsInPrepStmt[n] = 0;
            }
            if (sQLException != null) {
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ465", this.tableName);
                sQLException4.setNextException(sQLException);
                sQLException4 = this.flatten(sQLException4);
                throw sQLException4;
            }
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.sqlWarnings = null;
        if (this.connected) {
            this.controlStmt.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException sQLException = null;
        try {
            if (!this.fastloading) {
                try {
                    this.closeFastLoad();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            this.appPstmt.close();
        }
        catch (SQLException sQLException3) {
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
        }
        finally {
            this.closed = true;
            if (!this.fastloading) {
                ((FastLoadManagerConnection)this.managerCon).removeStatement(this);
            }
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ466", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Could not resolve type clashes
     */
    @Override
    public int[] executeBatch() throws SQLException {
        Object object;
        int[] nArray;
        SQLException sQLException;
        SQLException sQLException2;
        block50: {
            Object object2;
            int n;
            block49: {
                int n2;
                int n3;
                this.abortIfClosed();
                if (this.numBatchedRows == 0) {
                    throw ErrorFactory.makeDriverJDBCException("TJ416");
                }
                this.initializeFastLoad();
                sQLException2 = null;
                sQLException = null;
                n = 0;
                nArray = new int[this.numBatchedRows];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = -3;
                }
                TDPacket[] tDPacketArray = new TDPacket[this.fastloadCons.length];
                this.clearWarnings();
                this.beginFastLoad();
                object = new boolean[this.fastloadPrepStmts.length];
                object2 = new int[this.fastloadPrepStmts.length];
                int[] nArray2 = new int[this.fastloadPrepStmts.length];
                int[] nArray3 = new int[this.fastloadPrepStmts.length];
                int n4 = 0;
                int[][] nArrayArray = new int[this.fastloadPrepStmts.length][];
                for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                    nArrayArray[n3] = new int[this.numBatchedRowsInPrepStmt[n3]];
                    for (n2 = 0; n2 < nArrayArray[n3].length; ++n2) {
                        nArrayArray[n3][n2] = -3;
                    }
                    if (nArrayArray[n3].length <= 0) continue;
                    ++n4;
                }
                for (n3 = 0; n3 < tDPacketArray.length; ++n3) {
                    tDPacketArray[n3] = this.m_controlSession.createPacket(2);
                }
                boolean[] blArray = new boolean[this.fastloadPrepStmts.length];
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    blArray[n2] = true;
                }
                ((FastLoadManagerConnection)this.managerCon).getLog().info("FastLoad will use " + n4 + " FastLoadPreparedStatement(s) to insert data.");
                n2 = 0;
                int n5 = 0;
                do {
                    SQLException sQLException3;
                    int n6;
                    n5 = 0;
                    for (n6 = 0; n6 < this.fastloadPrepStmts.length; ++n6) {
                        object2[n6] = nArray2[n6];
                        if (nArray2[n6] < nArray3[n6]) {
                            nArray2[n6] = nArray3[n6];
                        }
                        if (!blArray[n6]) continue;
                        blArray[n6] = false;
                        if (sQLException2 != null || nArray2[n6] >= this.numBatchedRowsInPrepStmt[n6]) continue;
                        try {
                            nArray2[n6] = ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).bufferBatchedRows(tDPacketArray[n6], nArray2[n6]);
                            ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).sendBatchedRows(tDPacketArray[n6]);
                            this.numBatchedRowsSent += nArray2[n6] - object2[n6];
                            if (n2 != 0) continue;
                            n2 = 1;
                            continue;
                        }
                        catch (SQLException sQLException4) {
                            sQLException3 = ErrorFactory.makeDriverJDBCException("TJ471", n6, this.fastloadPrepStmts.length, n4);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException3);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException4);
                            object[n6] = true;
                        }
                    }
                    for (n6 = 0; n6 < this.fastloadPrepStmts.length; ++n6) {
                        if (sQLException2 != null || nArray2[n6] >= this.numBatchedRowsInPrepStmt[n6]) continue;
                        try {
                            nArray3[n6] = ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).bufferBatchedRows(tDPacketArray[n6], nArray2[n6]);
                            continue;
                        }
                        catch (SQLException sQLException5) {
                            sQLException3 = ErrorFactory.makeDriverJDBCException("TJ520", n6, this.fastloadPrepStmts.length, n4);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException3);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException5);
                        }
                    }
                    for (n6 = 0; n6 < this.fastloadPrepStmts.length && n2 != 0; ++n6) {
                        if (object[n6] != false || object2[n6] == nArray2[n6]) continue;
                        try {
                            ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).receiveBatchedRowUpdateCounts((int)object2[n6], nArrayArray[n6]);
                            if (sQLException2 == null && nArray2[n6] < nArray3[n6]) {
                                ((FastLoadPreparedStatement)this.fastloadPrepStmts[n6]).sendBatchedRows(tDPacketArray[n6]);
                                this.numBatchedRowsSent += nArray3[n6] - nArray2[n6];
                                if (n5 == 0) {
                                    n5 = 1;
                                }
                            }
                            int n7 = n6 % this.fastloadPrepStmts.length;
                            for (reference var17_29 = object2[n6]; var17_29 < nArray2[n6]; ++var17_29) {
                                nArray[var17_29 * this.fastloadPrepStmts.length + n7] = nArrayArray[n6][var17_29];
                                if (nArrayArray[n6][var17_29] == 1) continue;
                                ++n;
                            }
                            continue;
                        }
                        catch (SQLException sQLException6) {
                            SQLException sQLException7 = ErrorFactory.makeDriverJDBCException("TJ521", n6, this.fastloadPrepStmts.length, n4);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException7);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException6);
                            object[n6] = true;
                        }
                    }
                } while ((n2 = n5) != 0);
                if (n == 0) break block49;
                this.verifyFastLoadErrorTable1RowCount(n);
                sQLException = this.selectFastLoadErrorTable1Rows(nArray);
            }
            if (this.managerCon.getAutoCommit()) {
                try {
                    this.endFastLoad();
                }
                catch (SQLException sQLException8) {
                    if (sQLException != null) {
                        object2 = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n), this.tableName);
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, (SQLException)object2);
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException);
                        sQLException = null;
                    }
                    sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException8);
                }
            }
            try {
                this.clearBatch();
            }
            catch (SQLException sQLException9) {
                if (sQLException != null) {
                    object2 = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n), this.tableName);
                    sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, (SQLException)object2);
                    sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException);
                    sQLException = null;
                }
                sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException9);
            }
            break block50;
            catch (SQLException sQLException10) {
                try {
                    if (sQLException != null) {
                        object2 = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n), this.tableName);
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, (SQLException)object2);
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException);
                        sQLException = null;
                    }
                    sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException10);
                }
                catch (Throwable throwable) {
                    SQLException sQLException11;
                    if (this.managerCon.getAutoCommit()) {
                        try {
                            this.endFastLoad();
                        }
                        catch (SQLException sQLException12) {
                            if (sQLException != null) {
                                sQLException11 = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n), this.tableName);
                                sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException11);
                                sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException);
                                sQLException = null;
                            }
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException12);
                        }
                    }
                    try {
                        this.clearBatch();
                    }
                    catch (SQLException sQLException13) {
                        if (sQLException != null) {
                            sQLException11 = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n), this.tableName);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException11);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException);
                            sQLException = null;
                        }
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException13);
                    }
                    throw throwable;
                }
                if (this.managerCon.getAutoCommit()) {
                    try {
                        this.endFastLoad();
                    }
                    catch (SQLException sQLException14) {
                        if (sQLException != null) {
                            object2 = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n), this.tableName);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, (SQLException)object2);
                            sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException);
                            sQLException = null;
                        }
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException14);
                    }
                }
                try {
                    this.clearBatch();
                }
                catch (SQLException sQLException15) {
                    if (sQLException != null) {
                        object2 = ErrorFactory.makeDriverJDBCException("TJ561", String.valueOf(n), this.tableName);
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, (SQLException)object2);
                        sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException);
                        sQLException = null;
                    }
                    sQLException2 = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException2, sQLException15);
                }
            }
        }
        if (sQLException != null) {
            object = null;
            while (sQLException != null) {
                object = FastLoadManagerPreparedStatement.chainSQLExceptions((SQLException)object, ErrorFactory.cloneJDBCException(sQLException, -1));
                sQLException = sQLException.getNextException();
            }
            throw ErrorFactory.makeBatchUpdateException("TJ645", (SQLException)object, nArray);
        }
        if (sQLException2 != null) {
            object = ErrorFactory.makeBatchUpdateException("TJ467", nArray, this.tableName);
            sQLException2 = this.flatten(sQLException2);
            ((SQLException)object).setNextException(sQLException2);
            object = (BatchUpdateException)this.flatten((SQLException)object);
            ((Throwable)object).initCause(sQLException2);
            throw object;
        }
        return nArray;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.managerCon;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        if (this.connected) {
            this.chainSQLWarnings(this.controlStmt.getWarnings());
            this.controlStmt.clearWarnings();
        }
        return this.sqlWarnings;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchDirection(n);
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchSize(n);
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxFieldSize(n);
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxRows(n);
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return true;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setBlob(n, inputStream);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setCharacterStream(n, reader);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setClob(n, reader);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setClob(n, reader, l);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setNClob(n, reader);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setNClob(n, reader, l);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            ((FastLoadPreparedStatement)this.fastloadPrepStmts[0]).setNString(n, string);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setNClob(n, nClob);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setRowId(n, rowId);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        this.initializeFastLoad();
        SQLException sQLException = null;
        try {
            this.fastloadPrepStmts[0].setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException2) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ468", 0, this.fastloadPrepStmts.length);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            sQLException = FastLoadManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ464", this.tableName);
            sQLException4.setNextException(sQLException);
            sQLException4 = this.flatten(sQLException4);
            throw sQLException4;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    private static class SupportedButNull {
        public int targetSqlType;
        public int targetScale;

        public SupportedButNull(ObjectWithAttributes objectWithAttributes) {
            this.targetSqlType = objectWithAttributes.targetSqlType;
            this.targetScale = objectWithAttributes.targetScale;
        }
    }

    private static class ObjectWithAttributes {
        public Object object;
        public boolean bUserSpecifiedType = false;
        public int targetSqlType;
        public boolean bUserSpecifiedScale = false;
        public int targetScale;

        public ObjectWithAttributes(Object object) {
            this.object = object;
        }

        public ObjectWithAttributes(Object object, int n) {
            this(object);
            this.bUserSpecifiedType = true;
            this.targetSqlType = n;
        }

        public ObjectWithAttributes(Object object, int n, int n2) {
            this(object, n);
            this.bUserSpecifiedScale = true;
            this.targetScale = n2;
        }
    }
}

