/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.ifsupport.EscapeConverter;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.ifsupport.ManageEscapeState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.Map;
import java.util.StringTokenizer;

public class ConvertDateTimeLiterals
implements EscapeConverter {
    @Override
    public String processTokens(String string, StringTokenizer stringTokenizer, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        if (string.equals("T")) {
            return this.createNativeSQL(stringTokenizer, "TIME");
        }
        if (string.equals("D")) {
            return this.createNativeSQL(stringTokenizer, "DATE");
        }
        if (string.equals("TS")) {
            return this.createNativeSQL(stringTokenizer, "TIMESTAMP");
        }
        return null;
    }

    private String createNativeSQL(StringTokenizer stringTokenizer, String string) throws SQLException {
        boolean bl = true;
        ManageEscapeState manageEscapeState = new ManageEscapeState();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            manageEscapeState.setManageEscapeState(string2, bl);
            if (!"'".equals(string2) && n == 1) {
                n2 += string2.length();
                continue;
            }
            if (manageEscapeState.inEscapeState() || !"'".equals(string2)) continue;
            ++n;
        }
        if (n == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ381", string);
        }
        if (n2 == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ382", string);
        }
        return stringBuffer.toString();
    }
}

