/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapContext;
import com.teradata.tdgss.jgssp2ldap.LdapCredential;
import com.teradata.tdgss.jgssp2ldap.LdapMinorStatus;
import com.teradata.tdgss.jgssp2ldap.LdapName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class LdapMechanism
implements GSSMechanism {
    private final TdgssLogger logger;
    private static Oid _mechOid;
    protected static final int TDATMETHODMAXTOKEN = 80;
    protected static final Oid mechOid;
    protected static final short servicesAvailable = 99;
    protected static short servicesNeeded;

    public LdapMechanism(TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
        servicesNeeded = (short)99;
    }

    @Override
    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        if (object == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token is null");
            }
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (byArray.length <= 0 || byArray.length > 80) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof LdapCredential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIALmust be a credential created by this mech");
            }
            return false;
        }
        return true;
    }

    @Override
    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForAccept ");
        }
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, LdapMinorStatus.LDAPV3_ERR_INVALID_TOKEN);
        }
        return new LdapContext((LdapCredential)gSSCredential, objectArray, this.logger);
    }

    @Override
    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForInit ");
        }
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s = (short)(s & 0x63))) {
            throw new TdgssException(10, LdapMinorStatus.LDAPV3_ERR_INVALID_TOKEN);
        }
        return new LdapContext((LdapCredential)gSSCredential, (LdapName)gSSName, n, objectArray, s, this.logger);
    }

    @Override
    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        if (gSSCredential != null && !(gSSCredential instanceof LdapCredential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIAL: must be a credential created by this mech");
            }
            return false;
        }
        if (gSSName != null && !(gSSName instanceof LdapName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("must be a name created by this mech");
            }
            return false;
        }
        return true;
    }

    @Override
    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        LdapName ldapName;
        if (gSSName == null) {
            ldapName = null;
        } else if (gSSName instanceof LdapName) {
            ldapName = (LdapName)gSSName;
        } else {
            throw new TdgssException(3, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        return new LdapCredential(ldapName, n, n2, this.logger);
    }

    @Override
    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        if (oid != null && oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
            byte[] byArray2;
            try {
                String string = new String(byArray, "UTF-16");
                byArray2 = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.logger.error(unsupportedEncodingException.getMessage());
                throw new TdgssException(3, LdapMinorStatus.LDAPV3_ERR_INVALID_NAME_ENCODING, unsupportedEncodingException);
            }
            return new LdapName(byArray2, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, this.logger);
        }
        return new LdapName(byArray, oid, this.logger);
    }

    @Override
    public Oid[] getNames() {
        return new Oid[]{TdgssName.GSS_C_NT_TDAT_MECHDATA, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8};
    }

    @Override
    public Oid getMech() {
        return mechOid;
    }

    @Override
    public short getServices() {
        return 99;
    }

    static {
        try {
            _mechOid = new Oid("1.3.6.1.4.1.191.1.1012.1.20");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        mechOid = _mechOid;
        servicesNeeded = 0;
    }
}

