/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.AddressElement;
import com.vertica.core.VConnection;
import com.vertica.core.VConnectionPropertyValue;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Random;
import java.util.Stack;

public class AddressList {
    private Stack<AddressElement> m_addressStack;
    private VConnection m_conn;
    private VConnectionPropertyValue.AddressFamilyPreference m_afp;
    private boolean m_peekedLast;
    private ArrayList<FailedSocketEntry> m_failedSocketList;

    protected AddressList(String string, int n, String[] stringArray, VConnectionPropertyValue.AddressFamilyPreference addressFamilyPreference, VConnection vConnection) {
        ArrayList<String> arrayList = new ArrayList<String>(1 + stringArray.length);
        this.m_addressStack = new Stack();
        this.m_failedSocketList = new ArrayList();
        this.m_conn = vConnection;
        this.m_afp = addressFamilyPreference;
        this.m_peekedLast = false;
        for (int i = stringArray.length - 1; i > -1; --i) {
            arrayList.add(stringArray[i]);
        }
        try {
            URL uRL = new URL("http", string, n, "");
            arrayList.add(uRL.getHost() + ":" + n);
        }
        catch (MalformedURLException malformedURLException) {
            LogUtilities.logWarning("Error creating URL for " + string + ":" + n + " : " + malformedURLException.getLocalizedMessage(), (ILogger)this.m_conn.getConnectionLog());
        }
        for (String string2 : arrayList) {
            try {
                URL uRL = new URL("http://" + string2);
                int n2 = uRL.getPort();
                if (n2 == -1) {
                    n2 = n;
                }
                String string3 = uRL.getHost();
                this.add(string3, null, n2);
            }
            catch (MalformedURLException malformedURLException) {
                LogUtilities.logWarning("Error creating URL for " + string2 + ":" + n + " : " + malformedURLException.getLocalizedMessage(), (ILogger)this.m_conn.getConnectionLog());
            }
        }
    }

    public void add(String string, InetAddress inetAddress, int n) {
        AddressElement addressElement = new AddressElement(string, inetAddress, n);
        this.m_addressStack.push(addressElement);
    }

    public AddressElement getNext() {
        AddressElement addressElement = null;
        boolean bl = false;
        while (!bl) {
            try {
                if (this.m_addressStack.size() > 1) {
                    addressElement = this.m_addressStack.pop();
                } else {
                    this.m_peekedLast = true;
                    addressElement = this.m_addressStack.peek();
                    if (addressElement.getDNSFail()) {
                        return null;
                    }
                }
            }
            catch (EmptyStackException emptyStackException) {
                return null;
            }
            if (addressElement.getInetAddr() != null) {
                if (this.goodAddrAndPort(addressElement.getInetAddr(), addressElement.getPort())) {
                    return addressElement;
                }
                if (!this.m_peekedLast) continue;
                return null;
            }
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(addressElement.getIPAddrStr());
                this.shuffleDNSEntries(inetAddressArray);
                if (inetAddressArray.length > 1) {
                    int n = addressElement.getPort();
                    String string = addressElement.getIPAddrStr();
                    for (InetAddress inetAddress : inetAddressArray) {
                        if (this.m_afp == VConnectionPropertyValue.AddressFamilyPreference.IPv6 && inetAddress instanceof Inet4Address || this.m_afp == VConnectionPropertyValue.AddressFamilyPreference.IPv4 && inetAddress instanceof Inet6Address || !this.goodAddrAndPort(inetAddress, n)) continue;
                        this.m_addressStack.push(new AddressElement(string, inetAddress, n));
                        bl = true;
                    }
                    addressElement = this.m_addressStack.pop();
                    continue;
                }
                if (!(this.m_afp == VConnectionPropertyValue.AddressFamilyPreference.IPv6 && inetAddressArray[0] instanceof Inet4Address || this.m_afp == VConnectionPropertyValue.AddressFamilyPreference.IPv4 && inetAddressArray[0] instanceof Inet6Address || !this.goodAddrAndPort(inetAddressArray[0], addressElement.getPort()))) {
                    addressElement.setInetAddr(inetAddressArray[0]);
                    bl = true;
                    continue;
                }
                if (!this.m_peekedLast) continue;
                return null;
            }
            catch (UnknownHostException unknownHostException) {
                addressElement.setDNSFail();
            }
        }
        if (bl) {
            return addressElement;
        }
        return null;
    }

    public int size() {
        return this.m_addressStack.size();
    }

    public boolean isLastAddress() {
        return this.m_peekedLast;
    }

    private void shuffleDNSEntries(InetAddress[] inetAddressArray) {
        Random random = new Random();
        for (int i = inetAddressArray.length - 1; i > 0; --i) {
            int n = random.nextInt(i + 1);
            InetAddress inetAddress = inetAddressArray[n];
            inetAddressArray[n] = inetAddressArray[i];
            inetAddressArray[i] = inetAddress;
        }
    }

    public void reportSocketFailure(AddressElement addressElement) {
        this.m_failedSocketList.add(new FailedSocketEntry(addressElement.getInetAddr(), addressElement.getPort()));
    }

    private boolean goodAddrAndPort(InetAddress inetAddress, int n) {
        boolean bl = false;
        for (FailedSocketEntry failedSocketEntry : this.m_failedSocketList) {
            if (!failedSocketEntry.getInetAddress().equals(inetAddress) || failedSocketEntry.getPort() != n) continue;
            bl = true;
            break;
        }
        return !bl;
    }

    private class FailedSocketEntry {
        InetAddress m_inetAddr;
        int m_port;

        protected FailedSocketEntry(InetAddress inetAddress, int n) {
            this.m_inetAddr = inetAddress;
            this.m_port = n;
        }

        public InetAddress getInetAddress() {
            return this.m_inetAddr;
        }

        public int getPort() {
            return this.m_port;
        }
    }
}

