/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.datatype.BaseType;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.modules.jackson.api.impl.CustomExampleImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeExampleImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.DataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.EnumDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ExampleImpl;
import com.webcohesion.enunciate.modules.jackson.api.impl.ObjectDataTypeImpl;
import com.webcohesion.enunciate.modules.jackson.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import java.util.LinkedList;
import java.util.List;

public class DataTypeReferenceImpl
implements DataTypeReference {
    private final String label;
    private final String slug;
    private final List<DataTypeReference.ContainerType> containers;
    private final DataType dataType;
    private final JsonType jsonType;
    private final String dataTypeFormat;
    private final ApiRegistrationContext registrationContext;

    public DataTypeReferenceImpl(JsonType jsonType, ApiRegistrationContext registrationContext) {
        this(jsonType, null, registrationContext);
    }

    public DataTypeReferenceImpl(JsonType jsonType, String jsonStringFormat, ApiRegistrationContext registrationContext) {
        String label;
        LinkedList<DataTypeReference.ContainerType> containers = null;
        String slug = null;
        DataTypeImpl dataType = null;
        while (jsonType instanceof JsonArrayType || jsonType instanceof JsonMapType || jsonType instanceof JsonClassType && ((JsonClassType)jsonType).getTypeDefinition() instanceof SimpleTypeDefinition) {
            if (jsonType instanceof JsonArrayType) {
                containers = containers == null ? new LinkedList<DataTypeReference.ContainerType>() : containers;
                containers.add(DataTypeReference.ContainerType.array);
                jsonType = ((JsonArrayType)jsonType).getComponentType();
                continue;
            }
            if (jsonType instanceof JsonMapType) {
                containers = containers == null ? new LinkedList<DataTypeReference.ContainerType>() : containers;
                containers.add(DataTypeReference.ContainerType.map);
                jsonType = ((JsonMapType)jsonType).getValueType();
                continue;
            }
            if (((JsonClassType)jsonType).getTypeDefinition() instanceof EnumTypeDefinition) break;
            jsonType = ((SimpleTypeDefinition)((JsonClassType)jsonType).getTypeDefinition()).getBaseType();
        }
        if (jsonType instanceof JsonClassType) {
            TypeDefinition typeDef = ((JsonClassType)jsonType).getTypeDefinition();
            if (typeDef instanceof ObjectTypeDefinition) {
                dataType = new ObjectDataTypeImpl((ObjectTypeDefinition)typeDef, registrationContext);
            } else if (typeDef instanceof EnumTypeDefinition) {
                dataType = new EnumDataTypeImpl((EnumTypeDefinition)typeDef, registrationContext);
            } else {
                throw new IllegalStateException();
            }
            label = dataType.getLabel();
            slug = dataType.getSlug();
        } else if (jsonType instanceof JsonMapType) {
            label = "object";
        } else {
            String string = jsonType.isBoolean() ? "boolean" : (jsonType.isNumber() ? "number" : (label = jsonType.isString() ? "string" : "object"));
            if (jsonType.isArray()) {
                containers = containers == null ? new LinkedList<DataTypeReference.ContainerType>() : containers;
                containers.add(DataTypeReference.ContainerType.array);
            }
        }
        this.jsonType = jsonType;
        this.dataTypeFormat = jsonStringFormat == null ? jsonType.getFormat() : jsonStringFormat;
        this.label = label;
        this.slug = slug;
        this.containers = containers;
        this.dataType = dataType;
        this.registrationContext = registrationContext;
    }

    public JsonType getJsonType() {
        return this.jsonType;
    }

    public BaseType getBaseType() {
        return this.jsonType.isBoolean() ? BaseType.bool : (this.jsonType.isNumber() ? BaseType.number : (this.jsonType.isString() ? BaseType.string : BaseType.object));
    }

    public String getLabel() {
        return this.label;
    }

    public String getSlug() {
        return this.slug;
    }

    public List<DataTypeReference.ContainerType> getContainers() {
        return this.containers;
    }

    public DataType getValue() {
        return this.dataType;
    }

    public Example getExample() {
        ExampleImpl example = null;
        if (this.dataType instanceof ObjectDataTypeImpl) {
            ObjectTypeDefinition typeDefinition = ((ObjectDataTypeImpl)this.dataType).typeDefinition;
            example = typeDefinition == null || typeDefinition.getContext().isDisableExamples() ? null : new DataTypeExampleImpl(typeDefinition, this.containers, this.registrationContext);
        } else if (this.dataType instanceof EnumDataTypeImpl) {
            String body = "...";
            List values = this.dataType.getValues();
            if (values != null && !values.isEmpty()) {
                body = ((Value)values.get(0)).getValue();
            }
            example = new CustomExampleImpl('\"' + body + '\"');
        }
        return example;
    }

    public String getBaseTypeFormat() {
        return this.dataTypeFormat;
    }
}

