/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.ipc.javabridge;

import de.julielab.ipc.javabridge.Reader;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericCommunicator<O> {
    private static final Logger log = LoggerFactory.getLogger(GenericCommunicator.class);
    private final Reader<O> reader;
    private final Writer writer;
    private BlockingQueue<O> inputDeque;
    private Deque<byte[]> outputDeque = new ArrayDeque<byte[]>();
    private BufferedOutputStream bos;
    private String multilineResponseDelimiter;
    private boolean gzipSent;

    public GenericCommunicator(Reader<O> reader, BufferedOutputStream bos, String multilineResponseDelimiter, boolean gzipSent) {
        this.bos = bos;
        this.multilineResponseDelimiter = multilineResponseDelimiter;
        this.gzipSent = gzipSent;
        this.writer = new Writer();
        this.reader = reader;
        this.inputDeque = reader.getInputDeque();
        this.reader.start();
    }

    public void close() throws IOException {
        if (!this.inputDeque.isEmpty()) {
            log.warn("Python-Java bridge was closed before all data was received from the external program:" + this.inputDeque.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        this.reader.interrupt();
        this.reader.close();
        this.bos.close();
        if (!this.outputDeque.isEmpty()) {
            log.warn("Python-Java bridge was closed before all data was sent to the external program: " + this.outputDeque.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        this.inputDeque = null;
        this.outputDeque = null;
    }

    public void send(byte[] data) {
        this.outputDeque.add(data);
        this.writer.run();
    }

    public List<O> receive() throws InterruptedException {
        ArrayList<O> receivedData = new ArrayList<O>();
        if (this.inputDeque == null) {
            throw new IllegalStateException("This communicator has already been closed, further calls to receive() are not permitted.");
        }
        log.trace("Waiting for something to be read");
        if (this.multilineResponseDelimiter == null) {
            receivedData.add(this.inputDeque.take());
        } else {
            O response;
            while (!(response = this.inputDeque.take()).equals(this.multilineResponseDelimiter)) {
                receivedData.add(response);
            }
        }
        log.trace("Reading from internal buffer {} messages.", (Object)receivedData.size());
        return receivedData;
    }

    private class Writer {
        private ByteBuffer buffer = ByteBuffer.allocate(4);

        private Writer() {
        }

        public void run() {
            try {
                while (!GenericCommunicator.this.outputDeque.isEmpty()) {
                    byte[] toWrite = GenericCommunicator.this.outputDeque.pop();
                    log.trace("Writing: " + toWrite);
                    if (GenericCommunicator.this.gzipSent) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        BufferedOutputStream bos = new BufferedOutputStream(new GZIPOutputStream(baos));
                        bos.write(toWrite);
                        bos.close();
                        toWrite = baos.toByteArray();
                    }
                    this.buffer.putInt(toWrite.length);
                    long time = System.currentTimeMillis();
                    GenericCommunicator.this.bos.write(this.buffer.array());
                    GenericCommunicator.this.bos.write(toWrite);
                    this.buffer.clear();
                    GenericCommunicator.this.bos.flush();
                    time = System.currentTimeMillis() - time;
                    log.trace("Sending data over pipe took {}ms", (Object)time);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

