/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.googleai.GeminiCodeExecution;
import dev.langchain4j.model.googleai.GeminiFunctionCall;
import dev.langchain4j.model.googleai.GeminiFunctionDeclaration;
import dev.langchain4j.model.googleai.GeminiTool;
import dev.langchain4j.model.googleai.SchemaMapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class FunctionMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    FunctionMapper() {
    }

    static GeminiTool fromToolSepcsToGTool(List<ToolSpecification> specifications, boolean allowCodeExecution) {
        GeminiTool.GeminiToolBuilder tool = GeminiTool.builder();
        if (allowCodeExecution) {
            tool.codeExecution(new GeminiCodeExecution());
        }
        if (specifications == null || specifications.isEmpty()) {
            if (allowCodeExecution) {
                return tool.build();
            }
            return null;
        }
        List<GeminiFunctionDeclaration> functionDeclarations = specifications.stream().map(specification -> {
            GeminiFunctionDeclaration.GeminiFunctionDeclarationBuilder fnBuilder = GeminiFunctionDeclaration.builder().name(specification.name());
            if (specification.description() != null) {
                fnBuilder.description(specification.description());
            }
            if (specification.parameters() != null) {
                fnBuilder.parameters(SchemaMapper.fromJsonSchemaToGSchema((JsonSchemaElement)specification.parameters()));
            }
            return fnBuilder.build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!functionDeclarations.isEmpty()) {
            tool.functionDeclarations(functionDeclarations);
        }
        return tool.build();
    }

    static List<ToolExecutionRequest> fromToolExecReqToGFunCall(List<GeminiFunctionCall> functionCalls) {
        return functionCalls.stream().map(functionCall -> {
            try {
                return ToolExecutionRequest.builder().name(functionCall.getName()).arguments(MAPPER.writeValueAsString(functionCall.getArgs())).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

