/*
 * Decompiled with CFR 0.152.
 */
package im.chic.utils.crypto;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.BufferedBlockCipher;
import org.spongycastle.crypto.CipherKeyGenerator;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.KeyGenerationParameters;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.io.CipherInputStream;
import org.spongycastle.crypto.io.CipherOutputStream;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.crypto.paddings.BlockCipherPadding;
import org.spongycastle.crypto.paddings.PKCS7Padding;
import org.spongycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;

public class AesUtils {
    public static byte[] generateKey() {
        CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
        cipherKeyGenerator.init(new KeyGenerationParameters(new SecureRandom(), 128));
        return cipherKeyGenerator.generateKey();
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws InvalidCipherTextException {
        byte[] result;
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)key);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aesEngine, (BlockCipherPadding)new PKCS7Padding());
        cipher.init(true, (CipherParameters)new KeyParameter(key));
        byte[] outBuf = new byte[cipher.getOutputSize(data.length)];
        int l1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
        int l2 = cipher.doFinal(outBuf, l1);
        if (outBuf.length != l1 + l2) {
            result = new byte[l1 + l2];
            System.arraycopy(outBuf, 0, result, 0, result.length);
        } else {
            result = outBuf;
        }
        return result;
    }

    public static OutputStream encrypt(OutputStream outputStream, byte[] key) {
        Preconditions.checkNotNull((Object)outputStream);
        Preconditions.checkNotNull((Object)key);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aesEngine, (BlockCipherPadding)new PKCS7Padding());
        cipher.init(true, (CipherParameters)new KeyParameter(key));
        return new CipherOutputStream(outputStream, (BufferedBlockCipher)cipher);
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws InvalidCipherTextException {
        byte[] result;
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)key);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aesEngine, (BlockCipherPadding)new PKCS7Padding());
        cipher.init(false, (CipherParameters)new KeyParameter(key));
        byte[] outBuf = new byte[cipher.getOutputSize(data.length)];
        int l1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
        int l2 = cipher.doFinal(outBuf, l1);
        if (outBuf.length != l1 + l2) {
            result = new byte[l1 + l2];
            System.arraycopy(outBuf, 0, result, 0, result.length);
        } else {
            result = outBuf;
        }
        return result;
    }

    public static InputStream decrypt(InputStream inputStream, byte[] key) {
        Preconditions.checkNotNull((Object)inputStream);
        Preconditions.checkNotNull((Object)key);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)aesEngine, (BlockCipherPadding)new PKCS7Padding());
        cipher.init(false, (CipherParameters)new KeyParameter(key));
        return new CipherInputStream(inputStream, (BufferedBlockCipher)cipher);
    }

    public static byte[] encrypt(byte[] data, byte[] key, byte[] iv) throws InvalidCipherTextException {
        byte[] result;
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)iv);
        Preconditions.checkArgument((key.length == iv.length ? 1 : 0) != 0);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)aesEngine), (BlockCipherPadding)new PKCS7Padding());
        cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        byte[] outBuf = new byte[cipher.getOutputSize(data.length)];
        int l1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
        int l2 = cipher.doFinal(outBuf, l1);
        if (outBuf.length != l1 + l2) {
            result = new byte[l1 + l2];
            System.arraycopy(outBuf, 0, result, 0, result.length);
        } else {
            result = outBuf;
        }
        return result;
    }

    public static OutputStream encrypt(OutputStream outputStream, byte[] key, byte[] iv) {
        Preconditions.checkNotNull((Object)outputStream);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)iv);
        Preconditions.checkArgument((key.length == iv.length ? 1 : 0) != 0);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)aesEngine), (BlockCipherPadding)new PKCS7Padding());
        cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        return new CipherOutputStream(outputStream, (BufferedBlockCipher)cipher);
    }

    public static byte[] decrypt(byte[] data, byte[] key, byte[] iv) throws InvalidCipherTextException {
        byte[] result;
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)iv);
        Preconditions.checkArgument((key.length == iv.length ? 1 : 0) != 0);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)aesEngine), (BlockCipherPadding)new PKCS7Padding());
        cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        byte[] outBuf = new byte[cipher.getOutputSize(data.length)];
        int l1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
        int l2 = cipher.doFinal(outBuf, l1);
        if (outBuf.length != l1 + l2) {
            result = new byte[l1 + l2];
            System.arraycopy(outBuf, 0, result, 0, result.length);
        } else {
            result = outBuf;
        }
        return result;
    }

    public static InputStream decrypt(InputStream inputStream, byte[] key, byte[] iv) {
        Preconditions.checkNotNull((Object)inputStream);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)iv);
        Preconditions.checkArgument((key.length == iv.length ? 1 : 0) != 0);
        AESFastEngine aesEngine = new AESFastEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)aesEngine), (BlockCipherPadding)new PKCS7Padding());
        cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        return new CipherInputStream(inputStream, (BufferedBlockCipher)cipher);
    }
}

