/*
 * Decompiled with CFR 0.152.
 */
package im.chic.utils.crypto;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA1Digest;

public class DigestUtils {
    private static final int BUFFER_SIZE = 65536;

    public static byte[] sha1(InputStream is) throws IOException {
        return DigestUtils.dgst(is, (Digest)new SHA1Digest());
    }

    public static String sha1Hex(InputStream is) throws IOException {
        return DigestUtils.dgstHex(is, (Digest)new SHA1Digest());
    }

    public static byte[] sha1(byte[] input) {
        return DigestUtils.dgst(input, (Digest)new SHA1Digest());
    }

    public static String sha1Hex(byte[] input) {
        return DigestUtils.dgstHex(input, (Digest)new SHA1Digest());
    }

    public static byte[] dgst(InputStream is, Digest digest) throws IOException {
        Preconditions.checkNotNull((Object)is);
        int n = 0;
        byte[] buffer = new byte[65536];
        while (n >= 0) {
            n = is.read(buffer);
            if (n <= 0) continue;
            digest.update(buffer, 0, n);
        }
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    public static String dgstHex(InputStream is, Digest digest) throws IOException {
        Preconditions.checkNotNull((Object)is);
        byte[] dgstBytes = DigestUtils.dgst(is, digest);
        return BaseEncoding.base16().encode(dgstBytes);
    }

    public static byte[] dgst(byte[] input, Digest digest) {
        Preconditions.checkNotNull((Object)input);
        digest.update(input, 0, input.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    public static String dgstHex(byte[] input, Digest digest) {
        Preconditions.checkNotNull((Object)input);
        byte[] dgstBytes = DigestUtils.dgst(input, digest);
        return BaseEncoding.base16().encode(dgstBytes);
    }
}

