/*
 * Decompiled with CFR 0.152.
 */
package im.chic.utils.crypto;

import com.google.common.base.Preconditions;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.macs.HMac;
import org.spongycastle.crypto.params.KeyParameter;

public class HMacUtils {
    public static byte[] hmacSHA1(byte[] data, byte[] key) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)key);
        HMac hMac = new HMac((Digest)new SHA1Digest());
        KeyParameter keyParameter = new KeyParameter(key);
        hMac.init((CipherParameters)keyParameter);
        hMac.update(data, 0, data.length);
        byte[] result = new byte[hMac.getMacSize()];
        hMac.doFinal(result, 0);
        return result;
    }
}

