/*
 * Decompiled with CFR 0.152.
 */
package im.chic.utils.crypto;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import org.spongycastle.crypto.CipherKeyGenerator;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.KeyGenerationParameters;
import org.spongycastle.crypto.StreamCipher;
import org.spongycastle.crypto.engines.RC4Engine;
import org.spongycastle.crypto.io.CipherInputStream;
import org.spongycastle.crypto.io.CipherOutputStream;
import org.spongycastle.crypto.params.KeyParameter;

public class Rc4Utils {
    public static byte[] generateKey() {
        CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
        cipherKeyGenerator.init(new KeyGenerationParameters(new SecureRandom(), 128));
        return cipherKeyGenerator.generateKey();
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((key.length >= 5 && key.length <= 256 ? 1 : 0) != 0);
        RC4Engine rc4 = new RC4Engine();
        rc4.init(true, (CipherParameters)new KeyParameter(key));
        byte[] encrypted = new byte[data.length];
        rc4.processBytes(data, 0, data.length, encrypted, 0);
        return encrypted;
    }

    public static OutputStream encrypt(OutputStream outputStream, byte[] key) {
        Preconditions.checkNotNull((Object)outputStream);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((key.length >= 5 && key.length <= 256 ? 1 : 0) != 0);
        RC4Engine rc4 = new RC4Engine();
        rc4.init(true, (CipherParameters)new KeyParameter(key));
        return new CipherOutputStream(outputStream, (StreamCipher)rc4);
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((key.length >= 5 && key.length <= 256 ? 1 : 0) != 0);
        RC4Engine rc4 = new RC4Engine();
        rc4.init(false, (CipherParameters)new KeyParameter(key));
        byte[] decrypted = new byte[data.length];
        rc4.processBytes(data, 0, data.length, decrypted, 0);
        return decrypted;
    }

    public static InputStream decrypt(InputStream inputStream, byte[] key) {
        Preconditions.checkNotNull((Object)inputStream);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((key.length >= 5 && key.length <= 256 ? 1 : 0) != 0);
        RC4Engine rc4 = new RC4Engine();
        rc4.init(false, (CipherParameters)new KeyParameter(key));
        return new CipherInputStream(inputStream, (StreamCipher)rc4);
    }

    public static StreamCipher createRC4DropCipher(byte[] key, int drop) {
        Preconditions.checkArgument((key.length >= 5 && key.length <= 256 ? 1 : 0) != 0);
        Preconditions.checkArgument((drop > 0 ? 1 : 0) != 0);
        RC4Engine rc4Engine = new RC4Engine();
        rc4Engine.init(true, (CipherParameters)new KeyParameter(key));
        byte[] dropBytes = new byte[drop];
        Arrays.fill(dropBytes, (byte)0);
        rc4Engine.processBytes(dropBytes, 0, dropBytes.length, dropBytes, 0);
        return rc4Engine;
    }
}

