/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializerConfig;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaJsonSchemaDeserializer<T>
extends AbstractKafkaJsonSchemaDeserializer<T>
implements Deserializer<T> {
    public KafkaJsonSchemaDeserializer() {
    }

    public KafkaJsonSchemaDeserializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
    }

    public KafkaJsonSchemaDeserializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, null);
    }

    @VisibleForTesting
    public KafkaJsonSchemaDeserializer(SchemaRegistryClient client, Map<String, ?> props, Class<T> type) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
        this.configure(this.deserializerConfig(props), type);
    }

    public void configure(Map<String, ?> props, boolean isKey) {
        this.configure(new KafkaJsonSchemaDeserializerConfig(props), isKey);
    }

    protected void configure(KafkaJsonSchemaDeserializerConfig config, boolean isKey) {
        this.isKey = isKey;
        if (isKey) {
            this.configure(config, config.getClass("json.key.type"));
        } else {
            this.configure(config, config.getClass("json.value.type"));
        }
    }

    public T deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    public T deserialize(String topic, Headers headers, byte[] bytes) {
        return (T)this.deserialize(false, topic, this.isKey, headers, bytes);
    }

    public void close() {
        super.close();
    }
}

