/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import io.cryptoapis.sdk.ApiCallback;
import io.cryptoapis.sdk.ApiClient;
import io.cryptoapis.sdk.ApiException;
import io.cryptoapis.sdk.ApiResponse;
import io.cryptoapis.sdk.Configuration;
import io.cryptoapis.sdk.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.model.GetExchangeRateByAssetSymbolsR;
import org.openapitools.client.model.GetExchangeRateByAssetsIDsR;

public class ExchangeRatesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExchangeRatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExchangeRatesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getExchangeRateByAssetSymbolsCall(String fromAssetSymbol, String toAssetSymbol, String context, Integer calculationTimestamp, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/market-data/exchange-rates/by-symbols/{fromAssetSymbol}/{toAssetSymbol}".replaceAll("\\{fromAssetSymbol\\}", this.localVarApiClient.escapeString(fromAssetSymbol.toString())).replaceAll("\\{toAssetSymbol\\}", this.localVarApiClient.escapeString(toAssetSymbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if (calculationTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("calculationTimestamp", calculationTimestamp));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExchangeRateByAssetSymbolsValidateBeforeCall(String fromAssetSymbol, String toAssetSymbol, String context, Integer calculationTimestamp, ApiCallback _callback) throws ApiException {
        if (fromAssetSymbol == null) {
            throw new ApiException("Missing the required parameter 'fromAssetSymbol' when calling getExchangeRateByAssetSymbols(Async)");
        }
        if (toAssetSymbol == null) {
            throw new ApiException("Missing the required parameter 'toAssetSymbol' when calling getExchangeRateByAssetSymbols(Async)");
        }
        Call localVarCall = this.getExchangeRateByAssetSymbolsCall(fromAssetSymbol, toAssetSymbol, context, calculationTimestamp, _callback);
        return localVarCall;
    }

    public GetExchangeRateByAssetSymbolsR getExchangeRateByAssetSymbols(String fromAssetSymbol, String toAssetSymbol, String context, Integer calculationTimestamp) throws ApiException {
        ApiResponse<GetExchangeRateByAssetSymbolsR> localVarResp = this.getExchangeRateByAssetSymbolsWithHttpInfo(fromAssetSymbol, toAssetSymbol, context, calculationTimestamp);
        return localVarResp.getData();
    }

    public ApiResponse<GetExchangeRateByAssetSymbolsR> getExchangeRateByAssetSymbolsWithHttpInfo(String fromAssetSymbol, String toAssetSymbol, String context, Integer calculationTimestamp) throws ApiException {
        Call localVarCall = this.getExchangeRateByAssetSymbolsValidateBeforeCall(fromAssetSymbol, toAssetSymbol, context, calculationTimestamp, null);
        Type localVarReturnType = new TypeToken<GetExchangeRateByAssetSymbolsR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExchangeRateByAssetSymbolsAsync(String fromAssetSymbol, String toAssetSymbol, String context, Integer calculationTimestamp, ApiCallback<GetExchangeRateByAssetSymbolsR> _callback) throws ApiException {
        Call localVarCall = this.getExchangeRateByAssetSymbolsValidateBeforeCall(fromAssetSymbol, toAssetSymbol, context, calculationTimestamp, _callback);
        Type localVarReturnType = new TypeToken<GetExchangeRateByAssetSymbolsR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExchangeRateByAssetsIDsCall(String fromAssetId, String toAssetId, String context, Integer calculationTimestamp, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/market-data/exchange-rates/by-asset-ids/{fromAssetId}/{toAssetId}".replaceAll("\\{fromAssetId\\}", this.localVarApiClient.escapeString(fromAssetId.toString())).replaceAll("\\{toAssetId\\}", this.localVarApiClient.escapeString(toAssetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if (calculationTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("calculationTimestamp", calculationTimestamp));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExchangeRateByAssetsIDsValidateBeforeCall(String fromAssetId, String toAssetId, String context, Integer calculationTimestamp, ApiCallback _callback) throws ApiException {
        if (fromAssetId == null) {
            throw new ApiException("Missing the required parameter 'fromAssetId' when calling getExchangeRateByAssetsIDs(Async)");
        }
        if (toAssetId == null) {
            throw new ApiException("Missing the required parameter 'toAssetId' when calling getExchangeRateByAssetsIDs(Async)");
        }
        Call localVarCall = this.getExchangeRateByAssetsIDsCall(fromAssetId, toAssetId, context, calculationTimestamp, _callback);
        return localVarCall;
    }

    public GetExchangeRateByAssetsIDsR getExchangeRateByAssetsIDs(String fromAssetId, String toAssetId, String context, Integer calculationTimestamp) throws ApiException {
        ApiResponse<GetExchangeRateByAssetsIDsR> localVarResp = this.getExchangeRateByAssetsIDsWithHttpInfo(fromAssetId, toAssetId, context, calculationTimestamp);
        return localVarResp.getData();
    }

    public ApiResponse<GetExchangeRateByAssetsIDsR> getExchangeRateByAssetsIDsWithHttpInfo(String fromAssetId, String toAssetId, String context, Integer calculationTimestamp) throws ApiException {
        Call localVarCall = this.getExchangeRateByAssetsIDsValidateBeforeCall(fromAssetId, toAssetId, context, calculationTimestamp, null);
        Type localVarReturnType = new TypeToken<GetExchangeRateByAssetsIDsR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExchangeRateByAssetsIDsAsync(String fromAssetId, String toAssetId, String context, Integer calculationTimestamp, ApiCallback<GetExchangeRateByAssetsIDsR> _callback) throws ApiException {
        Call localVarCall = this.getExchangeRateByAssetsIDsValidateBeforeCall(fromAssetId, toAssetId, context, calculationTimestamp, _callback);
        Type localVarReturnType = new TypeToken<GetExchangeRateByAssetsIDsR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

