/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.AddressCoinsTransactionConfirmedDataItemMinedInBlock;

@ApiModel(description="Defines an `item` as one result.")
public class AddressCoinsTransactionConfirmedDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK = "minedInBlock";
    @SerializedName(value="minedInBlock")
    private AddressCoinsTransactionConfirmedDataItemMinedInBlock minedInBlock;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AddressCoinsTransactionConfirmedDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public AddressCoinsTransactionConfirmedDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"mordor\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public AddressCoinsTransactionConfirmedDataItem address(String address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bc1qmjhy4exylset37e6sfjdtfksm8kpcrxknj7cag", required=true, value="Defines the specific address to which the coin transaction has been sent and is confirmed.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AddressCoinsTransactionConfirmedDataItem minedInBlock(AddressCoinsTransactionConfirmedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public AddressCoinsTransactionConfirmedDataItemMinedInBlock getMinedInBlock() {
        return this.minedInBlock;
    }

    public void setMinedInBlock(AddressCoinsTransactionConfirmedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
    }

    public AddressCoinsTransactionConfirmedDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="b00d27cccd5e4f4fa1b28824d9a1e5fef88e6c37cdeb09e37eb39aa1d3d63448", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AddressCoinsTransactionConfirmedDataItem amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0.0315", required=true, value="Defines the amount of coins sent with the confirmed transaction.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public AddressCoinsTransactionConfirmedDataItem unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="BTC", required=true, value="Defines the unit of the transaction, e.g. BTC.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public AddressCoinsTransactionConfirmedDataItem direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="incoming", required=true, value="Defines whether the transaction is \"incoming\" or \"outgoing\".")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressCoinsTransactionConfirmedDataItem addressCoinsTransactionConfirmedDataItem = (AddressCoinsTransactionConfirmedDataItem)o;
        return Objects.equals(this.blockchain, addressCoinsTransactionConfirmedDataItem.blockchain) && Objects.equals(this.network, addressCoinsTransactionConfirmedDataItem.network) && Objects.equals(this.address, addressCoinsTransactionConfirmedDataItem.address) && Objects.equals(this.minedInBlock, addressCoinsTransactionConfirmedDataItem.minedInBlock) && Objects.equals(this.transactionId, addressCoinsTransactionConfirmedDataItem.transactionId) && Objects.equals(this.amount, addressCoinsTransactionConfirmedDataItem.amount) && Objects.equals(this.unit, addressCoinsTransactionConfirmedDataItem.unit) && Objects.equals((Object)this.direction, (Object)addressCoinsTransactionConfirmedDataItem.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.address, this.minedInBlock, this.transactionId, this.amount, this.unit, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressCoinsTransactionConfirmedDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    minedInBlock: ").append(this.toIndentedString(this.minedInBlock)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AddressCoinsTransactionConfirmedDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AddressCoinsTransactionConfirmedDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK) != null) {
            AddressCoinsTransactionConfirmedDataItemMinedInBlock.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIRECTION) != null && !jsonObj.get(SERIALIZED_NAME_DIRECTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `direction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIRECTION).toString()));
        }
    }

    public static AddressCoinsTransactionConfirmedDataItem fromJson(String jsonString) throws IOException {
        return (AddressCoinsTransactionConfirmedDataItem)JSON.getGson().fromJson(jsonString, AddressCoinsTransactionConfirmedDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_UNIT);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_UNIT);
        openapiRequiredFields.add(SERIALIZED_NAME_DIRECTION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AddressCoinsTransactionConfirmedDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AddressCoinsTransactionConfirmedDataItem.class));
            return new TypeAdapter<AddressCoinsTransactionConfirmedDataItem>(){

                public void write(JsonWriter out, AddressCoinsTransactionConfirmedDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AddressCoinsTransactionConfirmedDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AddressCoinsTransactionConfirmedDataItem.validateJsonObject(jsonObj);
                    return (AddressCoinsTransactionConfirmedDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }
}

