/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.AddressTokensTransactionUnconfirmedToken;

@ApiModel(description="Defines an `item` as one result.")
public class AddressTokensTransactionUnconfirmedDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
    @SerializedName(value="tokenType")
    private TokenTypeEnum tokenType;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private AddressTokensTransactionUnconfirmedToken token;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;
    public static final String SERIALIZED_NAME_FIRST_SEEN_IN_MEMPOOL_TIMESTAMP = "firstSeenInMempoolTimestamp";
    @SerializedName(value="firstSeenInMempoolTimestamp")
    private Integer firstSeenInMempoolTimestamp;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AddressTokensTransactionUnconfirmedDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ethereum", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public AddressTokensTransactionUnconfirmedDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ropsten", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public AddressTokensTransactionUnconfirmedDataItem address(String address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0x65b895f400dae5541d70cbbec07527210158f6e2", required=true, value="Defines the specific address to which the token transaction has been sent and is pending confirmation.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AddressTokensTransactionUnconfirmedDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0x76670f3bb45c09e69173fe74834face446edf251c5f02ec30384a0957fce482b", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AddressTokensTransactionUnconfirmedDataItem tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ERC-20", required=true, value="Defines the type of token sent with the transaction, e.g. ERC 20.")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public AddressTokensTransactionUnconfirmedDataItem token(AddressTokensTransactionUnconfirmedToken token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public AddressTokensTransactionUnconfirmedToken getToken() {
        return this.token;
    }

    public void setToken(AddressTokensTransactionUnconfirmedToken token) {
        this.token = token;
    }

    public AddressTokensTransactionUnconfirmedDataItem direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="incoming", required=true, value="Defines whether the transaction is \"incoming\" or \"outgoing\".")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public AddressTokensTransactionUnconfirmedDataItem firstSeenInMempoolTimestamp(Integer firstSeenInMempoolTimestamp) {
        this.firstSeenInMempoolTimestamp = firstSeenInMempoolTimestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1210363220", required=true, value="Defines the exact time the transaction has been first accepted into the mempool to await confirmation as timestamp.")
    public Integer getFirstSeenInMempoolTimestamp() {
        return this.firstSeenInMempoolTimestamp;
    }

    public void setFirstSeenInMempoolTimestamp(Integer firstSeenInMempoolTimestamp) {
        this.firstSeenInMempoolTimestamp = firstSeenInMempoolTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressTokensTransactionUnconfirmedDataItem addressTokensTransactionUnconfirmedDataItem = (AddressTokensTransactionUnconfirmedDataItem)o;
        return Objects.equals(this.blockchain, addressTokensTransactionUnconfirmedDataItem.blockchain) && Objects.equals(this.network, addressTokensTransactionUnconfirmedDataItem.network) && Objects.equals(this.address, addressTokensTransactionUnconfirmedDataItem.address) && Objects.equals(this.transactionId, addressTokensTransactionUnconfirmedDataItem.transactionId) && Objects.equals((Object)this.tokenType, (Object)addressTokensTransactionUnconfirmedDataItem.tokenType) && Objects.equals(this.token, addressTokensTransactionUnconfirmedDataItem.token) && Objects.equals((Object)this.direction, (Object)addressTokensTransactionUnconfirmedDataItem.direction) && Objects.equals(this.firstSeenInMempoolTimestamp, addressTokensTransactionUnconfirmedDataItem.firstSeenInMempoolTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.address, this.transactionId, this.tokenType, this.token, this.direction, this.firstSeenInMempoolTimestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressTokensTransactionUnconfirmedDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    firstSeenInMempoolTimestamp: ").append(this.toIndentedString(this.firstSeenInMempoolTimestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AddressTokensTransactionUnconfirmedDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AddressTokensTransactionUnconfirmedDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tokenType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN) != null) {
            AddressTokensTransactionUnconfirmedToken.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIRECTION) != null && !jsonObj.get(SERIALIZED_NAME_DIRECTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `direction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIRECTION).toString()));
        }
    }

    public static AddressTokensTransactionUnconfirmedDataItem fromJson(String jsonString) throws IOException {
        return (AddressTokensTransactionUnconfirmedDataItem)JSON.getGson().fromJson(jsonString, AddressTokensTransactionUnconfirmedDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_TOKEN_TYPE);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_FIRST_SEEN_IN_MEMPOOL_TIMESTAMP);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TOKEN_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_TOKEN);
        openapiRequiredFields.add(SERIALIZED_NAME_DIRECTION);
        openapiRequiredFields.add(SERIALIZED_NAME_FIRST_SEEN_IN_MEMPOOL_TIMESTAMP);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AddressTokensTransactionUnconfirmedDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AddressTokensTransactionUnconfirmedDataItem.class));
            return new TypeAdapter<AddressTokensTransactionUnconfirmedDataItem>(){

                public void write(JsonWriter out, AddressTokensTransactionUnconfirmedDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AddressTokensTransactionUnconfirmedDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AddressTokensTransactionUnconfirmedDataItem.validateJsonObject(jsonObj);
                    return (AddressTokensTransactionUnconfirmedDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        ERC_20("ERC-20"),
        ERC_721("ERC-721"),
        OMNI("OMNI");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(value);
            }
        }
    }
}

