/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="Defines an `item` as one result.")
public class CoinsForwardingFailDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_FROM_ADDRESS = "fromAddress";
    @SerializedName(value="fromAddress")
    private String fromAddress;
    public static final String SERIALIZED_NAME_TO_ADDRESS = "toAddress";
    @SerializedName(value="toAddress")
    private String toAddress;
    public static final String SERIALIZED_NAME_TRIGGER_TRANSACTION_ID = "triggerTransactionId";
    @SerializedName(value="triggerTransactionId")
    private String triggerTransactionId;
    public static final String SERIALIZED_NAME_ERROR_CODE = "errorCode";
    @SerializedName(value="errorCode")
    private ErrorCodeEnum errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CoinsForwardingFailDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public CoinsForwardingFailDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public CoinsForwardingFailDataItem fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="38RTQQ8915tEmKFMjpPJPfrh9yV5HbJCRb", required=true, value="Represents the hash of the address that provides the coins.")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public CoinsForwardingFailDataItem toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1PkLrGoEGiGdmqNXX8daYNFvVVTjmWjc7m", required=true, value="Represents the hash of the address to forward the coins to.")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public CoinsForwardingFailDataItem triggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="7e56c9cfaec36c77049ce5298bc153bb03b0b6b5dae760a62915617015f8e2a6", required=true, value="Defines the unique Transaction ID that triggered the coin forwarding.")
    public String getTriggerTransactionId() {
        return this.triggerTransactionId;
    }

    public void setTriggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
    }

    public CoinsForwardingFailDataItem errorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="blockchain_data_address_not_found", required=true, value="Represents the error code received for the failed coin forwarding.")
    public ErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
    }

    public CoinsForwardingFailDataItem errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Address not found", required=true, value="Represents the error message received for the failed coin forwarding.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoinsForwardingFailDataItem coinsForwardingFailDataItem = (CoinsForwardingFailDataItem)o;
        return Objects.equals(this.blockchain, coinsForwardingFailDataItem.blockchain) && Objects.equals(this.network, coinsForwardingFailDataItem.network) && Objects.equals(this.fromAddress, coinsForwardingFailDataItem.fromAddress) && Objects.equals(this.toAddress, coinsForwardingFailDataItem.toAddress) && Objects.equals(this.triggerTransactionId, coinsForwardingFailDataItem.triggerTransactionId) && Objects.equals((Object)this.errorCode, (Object)coinsForwardingFailDataItem.errorCode) && Objects.equals(this.errorMessage, coinsForwardingFailDataItem.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.fromAddress, this.toAddress, this.triggerTransactionId, this.errorCode, this.errorMessage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoinsForwardingFailDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    triggerTransactionId: ").append(this.toIndentedString(this.triggerTransactionId)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString((Object)this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CoinsForwardingFailDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CoinsForwardingFailDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fromAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_TO_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `toAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `triggerTransactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR_CODE) != null && !jsonObj.get(SERIALIZED_NAME_ERROR_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `errorCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `errorMessage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).toString()));
        }
    }

    public static CoinsForwardingFailDataItem fromJson(String jsonString) throws IOException {
        return (CoinsForwardingFailDataItem)JSON.getGson().fromJson(jsonString, CoinsForwardingFailDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_FROM_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_TO_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_ERROR_CODE);
        openapiFields.add(SERIALIZED_NAME_ERROR_MESSAGE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_FROM_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_TO_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ERROR_CODE);
        openapiRequiredFields.add(SERIALIZED_NAME_ERROR_MESSAGE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CoinsForwardingFailDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CoinsForwardingFailDataItem.class));
            return new TypeAdapter<CoinsForwardingFailDataItem>(){

                public void write(JsonWriter out, CoinsForwardingFailDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CoinsForwardingFailDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CoinsForwardingFailDataItem.validateJsonObject(jsonObj);
                    return (CoinsForwardingFailDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ErrorCodeEnum {
        NOT_ENOUGH_CREDITS("NOT_ENOUGH_CREDITS"),
        WRONG_ADDRESS_CREDENTIALS("WRONG_ADDRESS_CREDENTIALS");

        private String value;

        private ErrorCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ErrorCodeEnum fromValue(String value) {
            for (ErrorCodeEnum b : ErrorCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ErrorCodeEnum> {
            public void write(JsonWriter jsonWriter, ErrorCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ErrorCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ErrorCodeEnum.fromValue(value);
            }
        }
    }
}

