/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="Defines an `item` as one result.")
public class CoinsForwardingSuccessDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_FROM_ADDRESS = "fromAddress";
    @SerializedName(value="fromAddress")
    private String fromAddress;
    public static final String SERIALIZED_NAME_TO_ADDRESS = "toAddress";
    @SerializedName(value="toAddress")
    private String toAddress;
    public static final String SERIALIZED_NAME_FORWARDED_AMOUNT = "forwardedAmount";
    @SerializedName(value="forwardedAmount")
    private String forwardedAmount;
    public static final String SERIALIZED_NAME_FORWARDED_UNIT = "forwardedUnit";
    @SerializedName(value="forwardedUnit")
    private String forwardedUnit;
    public static final String SERIALIZED_NAME_SPENT_FEES_AMOUNT = "spentFeesAmount";
    @SerializedName(value="spentFeesAmount")
    private String spentFeesAmount;
    public static final String SERIALIZED_NAME_SPENT_FEES_UNIT = "spentFeesUnit";
    @SerializedName(value="spentFeesUnit")
    private String spentFeesUnit;
    public static final String SERIALIZED_NAME_TRIGGER_TRANSACTION_ID = "triggerTransactionId";
    @SerializedName(value="triggerTransactionId")
    private String triggerTransactionId;
    public static final String SERIALIZED_NAME_FORWARDING_TRANSACTION_ID = "forwardingTransactionId";
    @SerializedName(value="forwardingTransactionId")
    private String forwardingTransactionId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CoinsForwardingSuccessDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public CoinsForwardingSuccessDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public CoinsForwardingSuccessDataItem fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="mmd963W1fECjLyaDCHcioSCZYHkRwjkGST", required=true, value="Represents the hash of the address that provides the coins.")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public CoinsForwardingSuccessDataItem toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ms4KNsbNpoU8g424pzmEjbkFbfAHae1msB", required=true, value="Represents the hash of the address to forward the coins to.")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public CoinsForwardingSuccessDataItem forwardedAmount(String forwardedAmount) {
        this.forwardedAmount = forwardedAmount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="00059441", required=true, value="Represents the amount of coins that have been forwarded.")
    public String getForwardedAmount() {
        return this.forwardedAmount;
    }

    public void setForwardedAmount(String forwardedAmount) {
        this.forwardedAmount = forwardedAmount;
    }

    public CoinsForwardingSuccessDataItem forwardedUnit(String forwardedUnit) {
        this.forwardedUnit = forwardedUnit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="BTC", required=true, value="Represents the unit of coins that have been forwarded, e.g. BTC.")
    public String getForwardedUnit() {
        return this.forwardedUnit;
    }

    public void setForwardedUnit(String forwardedUnit) {
        this.forwardedUnit = forwardedUnit;
    }

    public CoinsForwardingSuccessDataItem spentFeesAmount(String spentFeesAmount) {
        this.spentFeesAmount = spentFeesAmount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0.00022827", required=true, value="Represents the amount of the fee spent for the coins to be forwarded.")
    public String getSpentFeesAmount() {
        return this.spentFeesAmount;
    }

    public void setSpentFeesAmount(String spentFeesAmount) {
        this.spentFeesAmount = spentFeesAmount;
    }

    public CoinsForwardingSuccessDataItem spentFeesUnit(String spentFeesUnit) {
        this.spentFeesUnit = spentFeesUnit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="BTC", required=true, value="Represents the unit of the fee spent for the coins to be forwarded, e.g. BTC.")
    public String getSpentFeesUnit() {
        return this.spentFeesUnit;
    }

    public void setSpentFeesUnit(String spentFeesUnit) {
        this.spentFeesUnit = spentFeesUnit;
    }

    public CoinsForwardingSuccessDataItem triggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="86a7546bde4ac28b34504909d138592a6d6fc1277ea1f8f2f9c75dc04bdf3b7b", required=true, value="Defines the unique Transaction ID that triggered the coin forwarding.")
    public String getTriggerTransactionId() {
        return this.triggerTransactionId;
    }

    public void setTriggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
    }

    public CoinsForwardingSuccessDataItem forwardingTransactionId(String forwardingTransactionId) {
        this.forwardingTransactionId = forwardingTransactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2241b5264fac8acb92e9fc597035b99cdd22f6578d63c6f52b099729f7c4f979", required=true, value="Defines the unique Transaction ID that forwarded the coins.")
    public String getForwardingTransactionId() {
        return this.forwardingTransactionId;
    }

    public void setForwardingTransactionId(String forwardingTransactionId) {
        this.forwardingTransactionId = forwardingTransactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoinsForwardingSuccessDataItem coinsForwardingSuccessDataItem = (CoinsForwardingSuccessDataItem)o;
        return Objects.equals(this.blockchain, coinsForwardingSuccessDataItem.blockchain) && Objects.equals(this.network, coinsForwardingSuccessDataItem.network) && Objects.equals(this.fromAddress, coinsForwardingSuccessDataItem.fromAddress) && Objects.equals(this.toAddress, coinsForwardingSuccessDataItem.toAddress) && Objects.equals(this.forwardedAmount, coinsForwardingSuccessDataItem.forwardedAmount) && Objects.equals(this.forwardedUnit, coinsForwardingSuccessDataItem.forwardedUnit) && Objects.equals(this.spentFeesAmount, coinsForwardingSuccessDataItem.spentFeesAmount) && Objects.equals(this.spentFeesUnit, coinsForwardingSuccessDataItem.spentFeesUnit) && Objects.equals(this.triggerTransactionId, coinsForwardingSuccessDataItem.triggerTransactionId) && Objects.equals(this.forwardingTransactionId, coinsForwardingSuccessDataItem.forwardingTransactionId);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.fromAddress, this.toAddress, this.forwardedAmount, this.forwardedUnit, this.spentFeesAmount, this.spentFeesUnit, this.triggerTransactionId, this.forwardingTransactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoinsForwardingSuccessDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    forwardedAmount: ").append(this.toIndentedString(this.forwardedAmount)).append("\n");
        sb.append("    forwardedUnit: ").append(this.toIndentedString(this.forwardedUnit)).append("\n");
        sb.append("    spentFeesAmount: ").append(this.toIndentedString(this.spentFeesAmount)).append("\n");
        sb.append("    spentFeesUnit: ").append(this.toIndentedString(this.spentFeesUnit)).append("\n");
        sb.append("    triggerTransactionId: ").append(this.toIndentedString(this.triggerTransactionId)).append("\n");
        sb.append("    forwardingTransactionId: ").append(this.toIndentedString(this.forwardingTransactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CoinsForwardingSuccessDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CoinsForwardingSuccessDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fromAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_TO_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `toAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORWARDED_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_FORWARDED_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `forwardedAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORWARDED_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORWARDED_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_FORWARDED_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `forwardedUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORWARDED_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SPENT_FEES_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_SPENT_FEES_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `spentFeesAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPENT_FEES_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SPENT_FEES_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_SPENT_FEES_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `spentFeesUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPENT_FEES_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `triggerTransactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORWARDING_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_FORWARDING_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `forwardingTransactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORWARDING_TRANSACTION_ID).toString()));
        }
    }

    public static CoinsForwardingSuccessDataItem fromJson(String jsonString) throws IOException {
        return (CoinsForwardingSuccessDataItem)JSON.getGson().fromJson(jsonString, CoinsForwardingSuccessDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_FROM_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_TO_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_FORWARDED_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_FORWARDED_UNIT);
        openapiFields.add(SERIALIZED_NAME_SPENT_FEES_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_SPENT_FEES_UNIT);
        openapiFields.add(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_FORWARDING_TRANSACTION_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_FROM_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_TO_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_FORWARDED_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_FORWARDED_UNIT);
        openapiRequiredFields.add(SERIALIZED_NAME_SPENT_FEES_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_SPENT_FEES_UNIT);
        openapiRequiredFields.add(SERIALIZED_NAME_TRIGGER_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_FORWARDING_TRANSACTION_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CoinsForwardingSuccessDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CoinsForwardingSuccessDataItem.class));
            return new TypeAdapter<CoinsForwardingSuccessDataItem>(){

                public void write(JsonWriter out, CoinsForwardingSuccessDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CoinsForwardingSuccessDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CoinsForwardingSuccessDataItem.validateJsonObject(jsonObj);
                    return (CoinsForwardingSuccessDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

