/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.AddressInternalTransactionConfirmedDataItemMinedInBlock;

@ApiModel(description="Defines an `item` as one result.")
public class ConfirmedInternalTransactionForCertainAmountOrHigherDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK = "minedInBlock";
    @SerializedName(value="minedInBlock")
    private AddressInternalTransactionConfirmedDataItemMinedInBlock minedInBlock;
    public static final String SERIALIZED_NAME_PARENT_TRANSACTION_ID = "parentTransactionId";
    @SerializedName(value="parentTransactionId")
    private String parentTransactionId;
    public static final String SERIALIZED_NAME_OPERATION_ID = "operationId";
    @SerializedName(value="operationId")
    private String operationId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ethereum", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ropsten", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\",\"mordor\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem address(String address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2", required=true, value="Defines the specific address of the internal transaction.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem minedInBlock(AddressInternalTransactionConfirmedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public AddressInternalTransactionConfirmedDataItemMinedInBlock getMinedInBlock() {
        return this.minedInBlock;
    }

    public void setMinedInBlock(AddressInternalTransactionConfirmedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
    }

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem parentTransactionId(String parentTransactionId) {
        this.parentTransactionId = parentTransactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0xc3be8371b32fa2238c44271643446b14c87ff11b77d58f9a1bceb1d1253e79b2", required=true, value="Defines the Parent Transaction's unique ID.")
    public String getParentTransactionId() {
        return this.parentTransactionId;
    }

    public void setParentTransactionId(String parentTransactionId) {
        this.parentTransactionId = parentTransactionId;
    }

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem operationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="call_5_0", required=true, value="Defines the specific operation's unique ID.")
    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0.94891479938916527", required=true, value="Defines the amount of coins sent with the confirmed transaction.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ETH", required=true, value="Defines the unit of the transaction, e.g. Gwei.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfirmedInternalTransactionForCertainAmountOrHigherDataItem confirmedInternalTransactionForCertainAmountOrHigherDataItem = (ConfirmedInternalTransactionForCertainAmountOrHigherDataItem)o;
        return Objects.equals(this.blockchain, confirmedInternalTransactionForCertainAmountOrHigherDataItem.blockchain) && Objects.equals(this.network, confirmedInternalTransactionForCertainAmountOrHigherDataItem.network) && Objects.equals(this.address, confirmedInternalTransactionForCertainAmountOrHigherDataItem.address) && Objects.equals(this.minedInBlock, confirmedInternalTransactionForCertainAmountOrHigherDataItem.minedInBlock) && Objects.equals(this.parentTransactionId, confirmedInternalTransactionForCertainAmountOrHigherDataItem.parentTransactionId) && Objects.equals(this.operationId, confirmedInternalTransactionForCertainAmountOrHigherDataItem.operationId) && Objects.equals(this.amount, confirmedInternalTransactionForCertainAmountOrHigherDataItem.amount) && Objects.equals(this.unit, confirmedInternalTransactionForCertainAmountOrHigherDataItem.unit);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.address, this.minedInBlock, this.parentTransactionId, this.operationId, this.amount, this.unit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfirmedInternalTransactionForCertainAmountOrHigherDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    minedInBlock: ").append(this.toIndentedString(this.minedInBlock)).append("\n");
        sb.append("    parentTransactionId: ").append(this.toIndentedString(this.parentTransactionId)).append("\n");
        sb.append("    operationId: ").append(this.toIndentedString(this.operationId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ConfirmedInternalTransactionForCertainAmountOrHigherDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ConfirmedInternalTransactionForCertainAmountOrHigherDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK) != null) {
            AddressInternalTransactionConfirmedDataItemMinedInBlock.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARENT_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_PARENT_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `parentTransactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARENT_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_OPERATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT).toString()));
        }
    }

    public static ConfirmedInternalTransactionForCertainAmountOrHigherDataItem fromJson(String jsonString) throws IOException {
        return (ConfirmedInternalTransactionForCertainAmountOrHigherDataItem)JSON.getGson().fromJson(jsonString, ConfirmedInternalTransactionForCertainAmountOrHigherDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
        openapiFields.add(SERIALIZED_NAME_PARENT_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_OPERATION_ID);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_UNIT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
        openapiRequiredFields.add(SERIALIZED_NAME_PARENT_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_OPERATION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_UNIT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ConfirmedInternalTransactionForCertainAmountOrHigherDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ConfirmedInternalTransactionForCertainAmountOrHigherDataItem.class));
            return new TypeAdapter<ConfirmedInternalTransactionForCertainAmountOrHigherDataItem>(){

                public void write(JsonWriter out, ConfirmedInternalTransactionForCertainAmountOrHigherDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ConfirmedInternalTransactionForCertainAmountOrHigherDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ConfirmedInternalTransactionForCertainAmountOrHigherDataItem.validateJsonObject(jsonObj);
                    return (ConfirmedInternalTransactionForCertainAmountOrHigherDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

