/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.AddressTokensTransactionConfirmedDataItemMinedInBlock;
import org.openapitools.client.model.ConfirmedTokensTransactionForCertainAmountOrHigherToken;

@ApiModel(description="Defines an `item` as one result.")
public class ConfirmedTokensTransactionForCertainAmountOrHigherDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK = "minedInBlock";
    @SerializedName(value="minedInBlock")
    private AddressTokensTransactionConfirmedDataItemMinedInBlock minedInBlock;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
    @SerializedName(value="tokenType")
    private TokenTypeEnum tokenType;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private ConfirmedTokensTransactionForCertainAmountOrHigherToken token;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ConfirmedTokensTransactionForCertainAmountOrHigherDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ethereum", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public ConfirmedTokensTransactionForCertainAmountOrHigherDataItem network(String network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ropsten", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"mordor\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public ConfirmedTokensTransactionForCertainAmountOrHigherDataItem minedInBlock(AddressTokensTransactionConfirmedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public AddressTokensTransactionConfirmedDataItemMinedInBlock getMinedInBlock() {
        return this.minedInBlock;
    }

    public void setMinedInBlock(AddressTokensTransactionConfirmedDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
    }

    public ConfirmedTokensTransactionForCertainAmountOrHigherDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0xbe38781783b1b9d480219255ff98e20335a39e13979a66112efa33f05fde0a33", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public ConfirmedTokensTransactionForCertainAmountOrHigherDataItem tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ERC-20", required=true, value="Defines the type of token sent with the transaction, e.g. ERC 20.")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public ConfirmedTokensTransactionForCertainAmountOrHigherDataItem token(ConfirmedTokensTransactionForCertainAmountOrHigherToken token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ConfirmedTokensTransactionForCertainAmountOrHigherToken getToken() {
        return this.token;
    }

    public void setToken(ConfirmedTokensTransactionForCertainAmountOrHigherToken token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfirmedTokensTransactionForCertainAmountOrHigherDataItem confirmedTokensTransactionForCertainAmountOrHigherDataItem = (ConfirmedTokensTransactionForCertainAmountOrHigherDataItem)o;
        return Objects.equals(this.blockchain, confirmedTokensTransactionForCertainAmountOrHigherDataItem.blockchain) && Objects.equals(this.network, confirmedTokensTransactionForCertainAmountOrHigherDataItem.network) && Objects.equals(this.minedInBlock, confirmedTokensTransactionForCertainAmountOrHigherDataItem.minedInBlock) && Objects.equals(this.transactionId, confirmedTokensTransactionForCertainAmountOrHigherDataItem.transactionId) && Objects.equals((Object)this.tokenType, (Object)confirmedTokensTransactionForCertainAmountOrHigherDataItem.tokenType) && Objects.equals(this.token, confirmedTokensTransactionForCertainAmountOrHigherDataItem.token);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.minedInBlock, this.transactionId, this.tokenType, this.token});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfirmedTokensTransactionForCertainAmountOrHigherDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    minedInBlock: ").append(this.toIndentedString(this.minedInBlock)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ConfirmedTokensTransactionForCertainAmountOrHigherDataItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ConfirmedTokensTransactionForCertainAmountOrHigherDataItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK) != null) {
            AddressTokensTransactionConfirmedDataItemMinedInBlock.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MINED_IN_BLOCK));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tokenType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN_TYPE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN) != null) {
            ConfirmedTokensTransactionForCertainAmountOrHigherToken.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN));
        }
    }

    public static ConfirmedTokensTransactionForCertainAmountOrHigherDataItem fromJson(String jsonString) throws IOException {
        return (ConfirmedTokensTransactionForCertainAmountOrHigherDataItem)JSON.getGson().fromJson(jsonString, ConfirmedTokensTransactionForCertainAmountOrHigherDataItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_TOKEN_TYPE);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_MINED_IN_BLOCK);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TOKEN_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_TOKEN);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ConfirmedTokensTransactionForCertainAmountOrHigherDataItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ConfirmedTokensTransactionForCertainAmountOrHigherDataItem.class));
            return new TypeAdapter<ConfirmedTokensTransactionForCertainAmountOrHigherDataItem>(){

                public void write(JsonWriter out, ConfirmedTokensTransactionForCertainAmountOrHigherDataItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ConfirmedTokensTransactionForCertainAmountOrHigherDataItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ConfirmedTokensTransactionForCertainAmountOrHigherDataItem.validateJsonObject(jsonObj);
                    return (ConfirmedTokensTransactionForCertainAmountOrHigherDataItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        ERC_20("ERC-20"),
        ERC_721("ERC-721"),
        BEP_20("BEP-20");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(value);
            }
        }
    }
}

