/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner;
import org.openapitools.client.model.CreateFungibleTokensTransactionRequestFromAddressRIS;
import org.openapitools.client.model.CreateFungibleTokensTransactionRequestFromAddressRISenders;

public class CreateFungibleTokensTransactionRequestFromAddressRI {
    public static final String SERIALIZED_NAME_CALLBACK_SECRET_KEY = "callbackSecretKey";
    @SerializedName(value="callbackSecretKey")
    private String callbackSecretKey;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    public static final String SERIALIZED_NAME_FEE_PRIORITY = "feePriority";
    @SerializedName(value="feePriority")
    private FeePriorityEnum feePriority;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
    @SerializedName(value="recipients")
    private List<CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner> recipients = new ArrayList<CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner>();
    public static final String SERIALIZED_NAME_SENDERS = "senders";
    @SerializedName(value="senders")
    private CreateFungibleTokensTransactionRequestFromAddressRISenders senders;
    public static final String SERIALIZED_NAME_TOKEN_TYPE_SPECIFIC_DATA = "tokenTypeSpecificData";
    @SerializedName(value="tokenTypeSpecificData")
    private CreateFungibleTokensTransactionRequestFromAddressRIS tokenTypeSpecificData;
    public static final String SERIALIZED_NAME_TRANSACTION_REQUEST_ID = "transactionRequestId";
    @SerializedName(value="transactionRequestId")
    private String transactionRequestId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateFungibleTokensTransactionRequestFromAddressRI callbackSecretKey(String callbackSecretKey) {
        this.callbackSecretKey = callbackSecretKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="yourSecretString", required=true, value="Represents the Secret Key value provided by the customer. This field is used for security purposes during the callback notification, in order to prove the sender of the callback as Crypto APIs. For more information please see our [Documentation](https://developers.cryptoapis.io/technical-documentation/general-information/callbacks#callback-security).")
    public String getCallbackSecretKey() {
        return this.callbackSecretKey;
    }

    public void setCallbackSecretKey(String callbackSecretKey) {
        this.callbackSecretKey = callbackSecretKey;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.com", required=true, value="Represents the URL that is set by the customer where the callback will be received at. The callback notification will be received only if and when the event occurs. `We support ONLY httpS type of protocol`.")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI feePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="fast", required=true, value="Represents the fee priority of the automation, whether it is \"slow\", \"standard\" or \"fast\".")
    public FeePriorityEnum getFeePriority() {
        return this.feePriority;
    }

    public void setFeePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI note(String note) {
        this.note = note;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="yourAdditionalInformationhere", value="Represents an optional note to add a free text in, explaining or providing additional detail on the transaction request.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI recipients(List<CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner> recipients) {
        this.recipients = recipients;
        return this;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI addRecipientsItem(CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0x1316bea88fb7cd4ccc4a57e2f9f4f43d1a86ee59", required=true, value="Defines the destination for the transaction, i.e. the recipient(s).")
    public List<CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner> recipients) {
        this.recipients = recipients;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI senders(CreateFungibleTokensTransactionRequestFromAddressRISenders senders) {
        this.senders = senders;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public CreateFungibleTokensTransactionRequestFromAddressRISenders getSenders() {
        return this.senders;
    }

    public void setSenders(CreateFungibleTokensTransactionRequestFromAddressRISenders senders) {
        this.senders = senders;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI tokenTypeSpecificData(CreateFungibleTokensTransactionRequestFromAddressRIS tokenTypeSpecificData) {
        this.tokenTypeSpecificData = tokenTypeSpecificData;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public CreateFungibleTokensTransactionRequestFromAddressRIS getTokenTypeSpecificData() {
        return this.tokenTypeSpecificData;
    }

    public void setTokenTypeSpecificData(CreateFungibleTokensTransactionRequestFromAddressRIS tokenTypeSpecificData) {
        this.tokenTypeSpecificData = tokenTypeSpecificData;
    }

    public CreateFungibleTokensTransactionRequestFromAddressRI transactionRequestId(String transactionRequestId) {
        this.transactionRequestId = transactionRequestId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="6038d09050653d1f0e40584c", required=true, value="Represents a unique identifier of the transaction request (the request sent to make a transaction), which helps in identifying which callback and which `referenceId` concern that specific transaction request.")
    public String getTransactionRequestId() {
        return this.transactionRequestId;
    }

    public void setTransactionRequestId(String transactionRequestId) {
        this.transactionRequestId = transactionRequestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFungibleTokensTransactionRequestFromAddressRI createFungibleTokensTransactionRequestFromAddressRI = (CreateFungibleTokensTransactionRequestFromAddressRI)o;
        return Objects.equals(this.callbackSecretKey, createFungibleTokensTransactionRequestFromAddressRI.callbackSecretKey) && Objects.equals(this.callbackUrl, createFungibleTokensTransactionRequestFromAddressRI.callbackUrl) && Objects.equals((Object)this.feePriority, (Object)createFungibleTokensTransactionRequestFromAddressRI.feePriority) && Objects.equals(this.note, createFungibleTokensTransactionRequestFromAddressRI.note) && Objects.equals(this.recipients, createFungibleTokensTransactionRequestFromAddressRI.recipients) && Objects.equals(this.senders, createFungibleTokensTransactionRequestFromAddressRI.senders) && Objects.equals(this.tokenTypeSpecificData, createFungibleTokensTransactionRequestFromAddressRI.tokenTypeSpecificData) && Objects.equals(this.transactionRequestId, createFungibleTokensTransactionRequestFromAddressRI.transactionRequestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.callbackSecretKey, this.callbackUrl, this.feePriority, this.note, this.recipients, this.senders, this.tokenTypeSpecificData, this.transactionRequestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFungibleTokensTransactionRequestFromAddressRI {\n");
        sb.append("    callbackSecretKey: ").append(this.toIndentedString(this.callbackSecretKey)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    feePriority: ").append(this.toIndentedString((Object)this.feePriority)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    senders: ").append(this.toIndentedString(this.senders)).append("\n");
        sb.append("    tokenTypeSpecificData: ").append(this.toIndentedString(this.tokenTypeSpecificData)).append("\n");
        sb.append("    transactionRequestId: ").append(this.toIndentedString(this.transactionRequestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateFungibleTokensTransactionRequestFromAddressRI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateFungibleTokensTransactionRequestFromAddressRI` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALLBACK_SECRET_KEY) != null && !jsonObj.get(SERIALIZED_NAME_CALLBACK_SECRET_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `callbackSecretKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALLBACK_SECRET_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALLBACK_URL) != null && !jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `callbackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEE_PRIORITY) != null && !jsonObj.get(SERIALIZED_NAME_FEE_PRIORITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `feePriority` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FEE_PRIORITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTE) != null && !jsonObj.get(SERIALIZED_NAME_NOTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `note` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTE).toString()));
        }
        JsonArray jsonArrayrecipients = jsonObj.getAsJsonArray(SERIALIZED_NAME_RECIPIENTS);
        if (jsonArrayrecipients != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECIPIENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `recipients` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECIPIENTS).toString()));
            }
            for (int i = 0; i < jsonArrayrecipients.size(); ++i) {
                CreateFungibleTokensTransactionRequestFromAddressRIRecipientsInner.validateJsonObject(jsonArrayrecipients.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SENDERS) != null) {
            CreateFungibleTokensTransactionRequestFromAddressRISenders.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SENDERS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN_TYPE_SPECIFIC_DATA) != null) {
            CreateFungibleTokensTransactionRequestFromAddressRIS.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN_TYPE_SPECIFIC_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_REQUEST_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_REQUEST_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionRequestId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_REQUEST_ID).toString()));
        }
    }

    public static CreateFungibleTokensTransactionRequestFromAddressRI fromJson(String jsonString) throws IOException {
        return (CreateFungibleTokensTransactionRequestFromAddressRI)JSON.getGson().fromJson(jsonString, CreateFungibleTokensTransactionRequestFromAddressRI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CALLBACK_SECRET_KEY);
        openapiFields.add(SERIALIZED_NAME_CALLBACK_URL);
        openapiFields.add(SERIALIZED_NAME_FEE_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_NOTE);
        openapiFields.add(SERIALIZED_NAME_RECIPIENTS);
        openapiFields.add(SERIALIZED_NAME_SENDERS);
        openapiFields.add(SERIALIZED_NAME_TOKEN_TYPE_SPECIFIC_DATA);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_REQUEST_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CALLBACK_SECRET_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_CALLBACK_URL);
        openapiRequiredFields.add(SERIALIZED_NAME_FEE_PRIORITY);
        openapiRequiredFields.add(SERIALIZED_NAME_RECIPIENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_SENDERS);
        openapiRequiredFields.add(SERIALIZED_NAME_TOKEN_TYPE_SPECIFIC_DATA);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_REQUEST_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateFungibleTokensTransactionRequestFromAddressRI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateFungibleTokensTransactionRequestFromAddressRI.class));
            return new TypeAdapter<CreateFungibleTokensTransactionRequestFromAddressRI>(){

                public void write(JsonWriter out, CreateFungibleTokensTransactionRequestFromAddressRI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateFungibleTokensTransactionRequestFromAddressRI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateFungibleTokensTransactionRequestFromAddressRI.validateJsonObject(jsonObj);
                    return (CreateFungibleTokensTransactionRequestFromAddressRI)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FeePriorityEnum {
        SLOW("slow"),
        STANDARD("standard"),
        FAST("fast");

        private String value;

        private FeePriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FeePriorityEnum fromValue(String value) {
            for (FeePriorityEnum b : FeePriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FeePriorityEnum> {
            public void write(JsonWriter jsonWriter, FeePriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FeePriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FeePriorityEnum.fromValue(value);
            }
        }
    }
}

