/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;
import org.openapitools.client.model.AbstractOpenApiSchema;
import org.openapitools.client.model.InvalidApiKey;
import org.openapitools.client.model.MissingApiKey;

public class DecodeRawTransactionHexE401
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(DecodeRawTransactionHexE401.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public DecodeRawTransactionHexE401() {
        super("oneOf", Boolean.FALSE);
    }

    public DecodeRawTransactionHexE401(InvalidApiKey o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public DecodeRawTransactionHexE401(MissingApiKey o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof InvalidApiKey) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof MissingApiKey) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be InvalidApiKey, MissingApiKey");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public InvalidApiKey getInvalidApiKey() throws ClassCastException {
        return (InvalidApiKey)super.getActualInstance();
    }

    public MissingApiKey getMissingApiKey() throws ClassCastException {
        return (MissingApiKey)super.getActualInstance();
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            InvalidApiKey.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for InvalidApiKey failed with `%s`.", e.getMessage()));
        }
        try {
            MissingApiKey.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for MissingApiKey failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for DecodeRawTransactionHexE401 with oneOf schemas: InvalidApiKey, MissingApiKey. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonObj.toString()));
        }
    }

    public static DecodeRawTransactionHexE401 fromJson(String jsonString) throws IOException {
        return (DecodeRawTransactionHexE401)JSON.getGson().fromJson(jsonString, DecodeRawTransactionHexE401.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("InvalidApiKey", (GenericType)new GenericType<InvalidApiKey>(){});
        schemas.put("MissingApiKey", (GenericType)new GenericType<MissingApiKey>(){});
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DecodeRawTransactionHexE401.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterInvalidApiKey = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InvalidApiKey.class));
            final TypeAdapter adapterMissingApiKey = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MissingApiKey.class));
            return new TypeAdapter<DecodeRawTransactionHexE401>(){

                public void write(JsonWriter out, DecodeRawTransactionHexE401 value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof InvalidApiKey) {
                        JsonObject obj = adapterInvalidApiKey.toJsonTree((Object)((InvalidApiKey)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    if (value.getActualInstance() instanceof MissingApiKey) {
                        JsonObject obj = adapterMissingApiKey.toJsonTree((Object)((MissingApiKey)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: InvalidApiKey, MissingApiKey");
                }

                public DecodeRawTransactionHexE401 read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        InvalidApiKey.validateJsonObject(jsonObject);
                        actualAdapter = adapterInvalidApiKey;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'InvalidApiKey'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for InvalidApiKey failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'InvalidApiKey'", e);
                    }
                    try {
                        MissingApiKey.validateJsonObject(jsonObject);
                        actualAdapter = adapterMissingApiKey;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'MissingApiKey'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for MissingApiKey failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'MissingApiKey'", e);
                    }
                    if (match == 1) {
                        DecodeRawTransactionHexE401 ret = new DecodeRawTransactionHexE401();
                        ret.setActualInstance(actualAdapter.fromJsonTree((JsonElement)jsonObject));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for DecodeRawTransactionHexE401: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonObject.toString()));
                }
            }.nullSafe();
        }
    }
}

