/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Binance Smart Chain")
public class DecodeRawTransactionHexRISB22 {
    public static final String SERIALIZED_NAME_APPROXIMATE_FEE = "approximateFee";
    @SerializedName(value="approximateFee")
    private String approximateFee;
    public static final String SERIALIZED_NAME_APPROXIMATE_MINIMUM_REQUIRED_FEE = "approximateMinimumRequiredFee";
    @SerializedName(value="approximateMinimumRequiredFee")
    private String approximateMinimumRequiredFee;
    public static final String SERIALIZED_NAME_GAS_LIMIT = "gasLimit";
    @SerializedName(value="gasLimit")
    private String gasLimit;
    public static final String SERIALIZED_NAME_GAS_PAID_FOR_DATA = "gasPaidForData";
    @SerializedName(value="gasPaidForData")
    private String gasPaidForData;
    public static final String SERIALIZED_NAME_GAS_PRICE = "gasPrice";
    @SerializedName(value="gasPrice")
    private String gasPrice;
    public static final String SERIALIZED_NAME_INPUT_DATA = "inputData";
    @SerializedName(value="inputData")
    private String inputData;
    public static final String SERIALIZED_NAME_NONCE = "nonce";
    @SerializedName(value="nonce")
    private Integer nonce;
    public static final String SERIALIZED_NAME_R = "r";
    @SerializedName(value="r")
    private String r;
    public static final String SERIALIZED_NAME_RECIPIENT = "recipient";
    @SerializedName(value="recipient")
    private String recipient;
    public static final String SERIALIZED_NAME_S = "s";
    @SerializedName(value="s")
    private String s;
    public static final String SERIALIZED_NAME_SENDER = "sender";
    @SerializedName(value="sender")
    private String sender;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_V = "v";
    @SerializedName(value="v")
    private String v;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DecodeRawTransactionHexRISB22 approximateFee(String approximateFee) {
        this.approximateFee = approximateFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.00016932", value="Defines the approximate fee value. When isConfirmed is True - Defines the amount of the transaction fee When isConfirmed is False - For ETH-based blockchains this attribute represents the max fee value.")
    public String getApproximateFee() {
        return this.approximateFee;
    }

    public void setApproximateFee(String approximateFee) {
        this.approximateFee = approximateFee;
    }

    public DecodeRawTransactionHexRISB22 approximateMinimumRequiredFee(String approximateMinimumRequiredFee) {
        this.approximateMinimumRequiredFee = approximateMinimumRequiredFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.000021", value="Defines the approximate minimum fee that is required for the transaction.")
    public String getApproximateMinimumRequiredFee() {
        return this.approximateMinimumRequiredFee;
    }

    public void setApproximateMinimumRequiredFee(String approximateMinimumRequiredFee) {
        this.approximateMinimumRequiredFee = approximateMinimumRequiredFee;
    }

    public DecodeRawTransactionHexRISB22 gasLimit(String gasLimit) {
        this.gasLimit = gasLimit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="552020", required=true, value="Represents the amount of gas used by this specific transaction alone.")
    public String getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(String gasLimit) {
        this.gasLimit = gasLimit;
    }

    public DecodeRawTransactionHexRISB22 gasPaidForData(String gasPaidForData) {
        this.gasPaidForData = gasPaidForData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="Represents the amount of gas paid for the data in the transaction.")
    public String getGasPaidForData() {
        return this.gasPaidForData;
    }

    public void setGasPaidForData(String gasPaidForData) {
        this.gasPaidForData = gasPaidForData;
    }

    public DecodeRawTransactionHexRISB22 gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2994782927", value="Represents the price offered to the miner to purchase this amount of gas.")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public DecodeRawTransactionHexRISB22 inputData(String inputData) {
        this.inputData = inputData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0x34", value="Represents additional information that is required for the transaction.")
    public String getInputData() {
        return this.inputData;
    }

    public void setInputData(String inputData) {
        this.inputData = inputData;
    }

    public DecodeRawTransactionHexRISB22 nonce(Integer nonce) {
        this.nonce = nonce;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="16", required=true, value="Represents the sequential running number for an address, starting from 0 for the first transaction. E.g., if the nonce of a transaction is 10, it would be the 11th transaction sent from the sender's address.")
    public Integer getNonce() {
        return this.nonce;
    }

    public void setNonce(Integer nonce) {
        this.nonce = nonce;
    }

    public DecodeRawTransactionHexRISB22 r(String r) {
        this.r = r;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0xc297031972fe2d4926e01e66768d669882ace256f8a8397f757af341f5e7c49", value="Represents output of an ECDSA signature.")
    public String getR() {
        return this.r;
    }

    public void setR(String r) {
        this.r = r;
    }

    public DecodeRawTransactionHexRISB22 recipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0x59d9d70DC4717cc9F3c1f7Bf3Fb9B62430872725", required=true, value="The address which receives this transaction. In UTXO-based protocols like Bitcoin there could be several senders while in account-based protocols like Ethereum there is always only one recipient.")
    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public DecodeRawTransactionHexRISB22 s(String s) {
        this.s = s;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0x7b717faa31c5edf9332e1cd5fa3f736838a9262834ece621bb3c30671b66ab05", value="Represents output of an ECDSA signature.")
    public String getS() {
        return this.s;
    }

    public void setS(String s) {
        this.s = s;
    }

    public DecodeRawTransactionHexRISB22 sender(String sender) {
        this.sender = sender;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0x4dF189c73C714dd636a99AA4f3317CcD72a05d62", required=true, value="Represents the address which sends this transaction. In UTXO-based protocols like Bitcoin there could be several senders while in account-based protocols like Ethereum there is always only one sender.")
    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public DecodeRawTransactionHexRISB22 type(Integer type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0", required=true, value="Specifies the transaction type as one from three options: if response returns a `\"0\"` it means the raw transaction includes legacy transaction data, if it is `\"1\"` - includes access lists for EIP2930, and if it is `\"2\"` - EIP1559 data.")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public DecodeRawTransactionHexRISB22 v(String v) {
        this.v = v;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0x26", value="Defines the the recovery id.")
    public String getV() {
        return this.v;
    }

    public void setV(String v) {
        this.v = v;
    }

    public DecodeRawTransactionHexRISB22 value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="11.25", value="Represents the sent/received amount.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecodeRawTransactionHexRISB22 decodeRawTransactionHexRISB22 = (DecodeRawTransactionHexRISB22)o;
        return Objects.equals(this.approximateFee, decodeRawTransactionHexRISB22.approximateFee) && Objects.equals(this.approximateMinimumRequiredFee, decodeRawTransactionHexRISB22.approximateMinimumRequiredFee) && Objects.equals(this.gasLimit, decodeRawTransactionHexRISB22.gasLimit) && Objects.equals(this.gasPaidForData, decodeRawTransactionHexRISB22.gasPaidForData) && Objects.equals(this.gasPrice, decodeRawTransactionHexRISB22.gasPrice) && Objects.equals(this.inputData, decodeRawTransactionHexRISB22.inputData) && Objects.equals(this.nonce, decodeRawTransactionHexRISB22.nonce) && Objects.equals(this.r, decodeRawTransactionHexRISB22.r) && Objects.equals(this.recipient, decodeRawTransactionHexRISB22.recipient) && Objects.equals(this.s, decodeRawTransactionHexRISB22.s) && Objects.equals(this.sender, decodeRawTransactionHexRISB22.sender) && Objects.equals(this.type, decodeRawTransactionHexRISB22.type) && Objects.equals(this.v, decodeRawTransactionHexRISB22.v) && Objects.equals(this.value, decodeRawTransactionHexRISB22.value);
    }

    public int hashCode() {
        return Objects.hash(this.approximateFee, this.approximateMinimumRequiredFee, this.gasLimit, this.gasPaidForData, this.gasPrice, this.inputData, this.nonce, this.r, this.recipient, this.s, this.sender, this.type, this.v, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecodeRawTransactionHexRISB22 {\n");
        sb.append("    approximateFee: ").append(this.toIndentedString(this.approximateFee)).append("\n");
        sb.append("    approximateMinimumRequiredFee: ").append(this.toIndentedString(this.approximateMinimumRequiredFee)).append("\n");
        sb.append("    gasLimit: ").append(this.toIndentedString(this.gasLimit)).append("\n");
        sb.append("    gasPaidForData: ").append(this.toIndentedString(this.gasPaidForData)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    inputData: ").append(this.toIndentedString(this.inputData)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    r: ").append(this.toIndentedString(this.r)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    s: ").append(this.toIndentedString(this.s)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    v: ").append(this.toIndentedString(this.v)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DecodeRawTransactionHexRISB22 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DecodeRawTransactionHexRISB22` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPROXIMATE_FEE) != null && !jsonObj.get(SERIALIZED_NAME_APPROXIMATE_FEE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `approximateFee` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPROXIMATE_FEE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPROXIMATE_MINIMUM_REQUIRED_FEE) != null && !jsonObj.get(SERIALIZED_NAME_APPROXIMATE_MINIMUM_REQUIRED_FEE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `approximateMinimumRequiredFee` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPROXIMATE_MINIMUM_REQUIRED_FEE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GAS_LIMIT) != null && !jsonObj.get(SERIALIZED_NAME_GAS_LIMIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gasLimit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GAS_LIMIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GAS_PAID_FOR_DATA) != null && !jsonObj.get(SERIALIZED_NAME_GAS_PAID_FOR_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gasPaidForData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GAS_PAID_FOR_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GAS_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_GAS_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gasPrice` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GAS_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INPUT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_INPUT_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `inputData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INPUT_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_R) != null && !jsonObj.get(SERIALIZED_NAME_R).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `r` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_R).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECIPIENT) != null && !jsonObj.get(SERIALIZED_NAME_RECIPIENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recipient` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECIPIENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_S) != null && !jsonObj.get(SERIALIZED_NAME_S).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `s` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_S).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SENDER) != null && !jsonObj.get(SERIALIZED_NAME_SENDER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sender` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SENDER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_V) != null && !jsonObj.get(SERIALIZED_NAME_V).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `v` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_V).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
        }
    }

    public static DecodeRawTransactionHexRISB22 fromJson(String jsonString) throws IOException {
        return (DecodeRawTransactionHexRISB22)JSON.getGson().fromJson(jsonString, DecodeRawTransactionHexRISB22.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APPROXIMATE_FEE);
        openapiFields.add(SERIALIZED_NAME_APPROXIMATE_MINIMUM_REQUIRED_FEE);
        openapiFields.add(SERIALIZED_NAME_GAS_LIMIT);
        openapiFields.add(SERIALIZED_NAME_GAS_PAID_FOR_DATA);
        openapiFields.add(SERIALIZED_NAME_GAS_PRICE);
        openapiFields.add(SERIALIZED_NAME_INPUT_DATA);
        openapiFields.add(SERIALIZED_NAME_NONCE);
        openapiFields.add(SERIALIZED_NAME_R);
        openapiFields.add(SERIALIZED_NAME_RECIPIENT);
        openapiFields.add(SERIALIZED_NAME_S);
        openapiFields.add(SERIALIZED_NAME_SENDER);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_V);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GAS_LIMIT);
        openapiRequiredFields.add(SERIALIZED_NAME_NONCE);
        openapiRequiredFields.add(SERIALIZED_NAME_RECIPIENT);
        openapiRequiredFields.add(SERIALIZED_NAME_SENDER);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DecodeRawTransactionHexRISB22.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DecodeRawTransactionHexRISB22.class));
            return new TypeAdapter<DecodeRawTransactionHexRISB22>(){

                public void write(JsonWriter out, DecodeRawTransactionHexRISB22 value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DecodeRawTransactionHexRISB22 read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DecodeRawTransactionHexRISB22.validateJsonObject(jsonObj);
                    return (DecodeRawTransactionHexRISB22)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

