/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.DecodeRawTransactionHexRISDVinInner;
import org.openapitools.client.model.DecodeRawTransactionHexRISDVoutInner;

@ApiModel(description="Dash")
public class DecodeRawTransactionHexRISD {
    public static final String SERIALIZED_NAME_LOCKTIME = "locktime";
    @SerializedName(value="locktime")
    private Integer locktime;
    public static final String SERIALIZED_NAME_TRANSACTION_HASH = "transactionHash";
    @SerializedName(value="transactionHash")
    private String transactionHash;
    public static final String SERIALIZED_NAME_V_SIZE = "vSize";
    @SerializedName(value="vSize")
    private Integer vSize;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_VIN = "vin";
    @SerializedName(value="vin")
    private List<DecodeRawTransactionHexRISDVinInner> vin = new ArrayList<DecodeRawTransactionHexRISDVinInner>();
    public static final String SERIALIZED_NAME_VOUT = "vout";
    @SerializedName(value="vout")
    private List<DecodeRawTransactionHexRISDVoutInner> vout = new ArrayList<DecodeRawTransactionHexRISDVoutInner>();
    public static final String SERIALIZED_NAME_WEIGHT = "weight";
    @SerializedName(value="weight")
    private Integer weight;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DecodeRawTransactionHexRISD locktime(Integer locktime) {
        this.locktime = locktime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0", required=true, value="Represents the time at which a particular transaction can be added to the blockchain.")
    public Integer getLocktime() {
        return this.locktime;
    }

    public void setLocktime(Integer locktime) {
        this.locktime = locktime;
    }

    public DecodeRawTransactionHexRISD transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1b2a8bd59c0d776015cfe6fd6b5b4f936ffcf8adf7a56a1eed460e915ce82ea7", required=true, value="Represents the same as transactionId for account-based protocols like Ethereum, while it could be different in UTXO-based protocols like Bitcoin. E.g., in UTXO-based protocols hash is different from transactionId for SegWit transactions.")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public DecodeRawTransactionHexRISD vSize(Integer vSize) {
        this.vSize = vSize;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="141", required=true, value="Represents the virtual size of this transaction.")
    public Integer getvSize() {
        return this.vSize;
    }

    public void setvSize(Integer vSize) {
        this.vSize = vSize;
    }

    public DecodeRawTransactionHexRISD version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Represents transaction version number.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DecodeRawTransactionHexRISD vin(List<DecodeRawTransactionHexRISDVinInner> vin) {
        this.vin = vin;
        return this;
    }

    public DecodeRawTransactionHexRISD addVinItem(DecodeRawTransactionHexRISDVinInner vinItem) {
        this.vin.add(vinItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents the transaction inputs.")
    public List<DecodeRawTransactionHexRISDVinInner> getVin() {
        return this.vin;
    }

    public void setVin(List<DecodeRawTransactionHexRISDVinInner> vin) {
        this.vin = vin;
    }

    public DecodeRawTransactionHexRISD vout(List<DecodeRawTransactionHexRISDVoutInner> vout) {
        this.vout = vout;
        return this;
    }

    public DecodeRawTransactionHexRISD addVoutItem(DecodeRawTransactionHexRISDVoutInner voutItem) {
        this.vout.add(voutItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents the transaction outputs.")
    public List<DecodeRawTransactionHexRISDVoutInner> getVout() {
        return this.vout;
    }

    public void setVout(List<DecodeRawTransactionHexRISDVoutInner> vout) {
        this.vout = vout;
    }

    public DecodeRawTransactionHexRISD weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="256", value="Represents the size of a block, measured in weight units and including the segwit discount.")
    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecodeRawTransactionHexRISD decodeRawTransactionHexRISD = (DecodeRawTransactionHexRISD)o;
        return Objects.equals(this.locktime, decodeRawTransactionHexRISD.locktime) && Objects.equals(this.transactionHash, decodeRawTransactionHexRISD.transactionHash) && Objects.equals(this.vSize, decodeRawTransactionHexRISD.vSize) && Objects.equals(this.version, decodeRawTransactionHexRISD.version) && Objects.equals(this.vin, decodeRawTransactionHexRISD.vin) && Objects.equals(this.vout, decodeRawTransactionHexRISD.vout) && Objects.equals(this.weight, decodeRawTransactionHexRISD.weight);
    }

    public int hashCode() {
        return Objects.hash(this.locktime, this.transactionHash, this.vSize, this.version, this.vin, this.vout, this.weight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecodeRawTransactionHexRISD {\n");
        sb.append("    locktime: ").append(this.toIndentedString(this.locktime)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    vSize: ").append(this.toIndentedString(this.vSize)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    vin: ").append(this.toIndentedString(this.vin)).append("\n");
        sb.append("    vout: ").append(this.toIndentedString(this.vout)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvout;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DecodeRawTransactionHexRISD is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DecodeRawTransactionHexRISD` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionHash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH).toString()));
        }
        JsonArray jsonArrayvin = jsonObj.getAsJsonArray(SERIALIZED_NAME_VIN);
        if (jsonArrayvin != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VIN).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `vin` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VIN).toString()));
            }
            for (int i = 0; i < jsonArrayvin.size(); ++i) {
                DecodeRawTransactionHexRISDVinInner.validateJsonObject(jsonArrayvin.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayvout = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOUT)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOUT).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `vout` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOUT).toString()));
            }
            for (int i = 0; i < jsonArrayvout.size(); ++i) {
                DecodeRawTransactionHexRISDVoutInner.validateJsonObject(jsonArrayvout.get(i).getAsJsonObject());
            }
        }
    }

    public static DecodeRawTransactionHexRISD fromJson(String jsonString) throws IOException {
        return (DecodeRawTransactionHexRISD)JSON.getGson().fromJson(jsonString, DecodeRawTransactionHexRISD.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LOCKTIME);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_HASH);
        openapiFields.add(SERIALIZED_NAME_V_SIZE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_VIN);
        openapiFields.add(SERIALIZED_NAME_VOUT);
        openapiFields.add(SERIALIZED_NAME_WEIGHT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LOCKTIME);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_HASH);
        openapiRequiredFields.add(SERIALIZED_NAME_V_SIZE);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_VIN);
        openapiRequiredFields.add(SERIALIZED_NAME_VOUT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DecodeRawTransactionHexRISD.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DecodeRawTransactionHexRISD.class));
            return new TypeAdapter<DecodeRawTransactionHexRISD>(){

                public void write(JsonWriter out, DecodeRawTransactionHexRISD value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DecodeRawTransactionHexRISD read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DecodeRawTransactionHexRISD.validateJsonObject(jsonObj);
                    return (DecodeRawTransactionHexRISD)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

