/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.DecodeRawTransactionHexRISLVinInner;
import org.openapitools.client.model.DecodeRawTransactionHexRISLVoutInner;

@ApiModel(description="Litecoin")
public class DecodeRawTransactionHexRISL {
    public static final String SERIALIZED_NAME_LOCKTIME = "locktime";
    @SerializedName(value="locktime")
    private Integer locktime;
    public static final String SERIALIZED_NAME_TRANSACTION_HASH = "transactionHash";
    @SerializedName(value="transactionHash")
    private String transactionHash;
    public static final String SERIALIZED_NAME_V_SIZE = "vSize";
    @SerializedName(value="vSize")
    private Integer vSize;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_VIN = "vin";
    @SerializedName(value="vin")
    private List<DecodeRawTransactionHexRISLVinInner> vin = new ArrayList<DecodeRawTransactionHexRISLVinInner>();
    public static final String SERIALIZED_NAME_VOUT = "vout";
    @SerializedName(value="vout")
    private List<DecodeRawTransactionHexRISLVoutInner> vout = new ArrayList<DecodeRawTransactionHexRISLVoutInner>();
    public static final String SERIALIZED_NAME_WEIGHT = "weight";
    @SerializedName(value="weight")
    private Integer weight;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DecodeRawTransactionHexRISL locktime(Integer locktime) {
        this.locktime = locktime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2", required=true, value="Represents the time at which a particular transaction can be added to the blockchain")
    public Integer getLocktime() {
        return this.locktime;
    }

    public void setLocktime(Integer locktime) {
        this.locktime = locktime;
    }

    public DecodeRawTransactionHexRISL transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1ec73b0f61359927d02376b35993b756b1097cb9a857bec23da4c98c4977d2b2", required=true, value="Represents the same as transactionId for account-based protocols like Ethereum, while it could be different in UTXO-based protocols like Bitcoin. E.g., in UTXO-based protocols hash is different from transactionId for SegWit transactions.")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public DecodeRawTransactionHexRISL vSize(Integer vSize) {
        this.vSize = vSize;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="141", required=true, value="Represents the virtual size of this transaction.")
    public Integer getvSize() {
        return this.vSize;
    }

    public void setvSize(Integer vSize) {
        this.vSize = vSize;
    }

    public DecodeRawTransactionHexRISL version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Represents transaction version number.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DecodeRawTransactionHexRISL vin(List<DecodeRawTransactionHexRISLVinInner> vin) {
        this.vin = vin;
        return this;
    }

    public DecodeRawTransactionHexRISL addVinItem(DecodeRawTransactionHexRISLVinInner vinItem) {
        this.vin.add(vinItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents the transaction inputs.")
    public List<DecodeRawTransactionHexRISLVinInner> getVin() {
        return this.vin;
    }

    public void setVin(List<DecodeRawTransactionHexRISLVinInner> vin) {
        this.vin = vin;
    }

    public DecodeRawTransactionHexRISL vout(List<DecodeRawTransactionHexRISLVoutInner> vout) {
        this.vout = vout;
        return this;
    }

    public DecodeRawTransactionHexRISL addVoutItem(DecodeRawTransactionHexRISLVoutInner voutItem) {
        this.vout.add(voutItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents the transaction outputs.")
    public List<DecodeRawTransactionHexRISLVoutInner> getVout() {
        return this.vout;
    }

    public void setVout(List<DecodeRawTransactionHexRISLVoutInner> vout) {
        this.vout = vout;
    }

    public DecodeRawTransactionHexRISL weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="245", value="Represents the size of a block, measured in weight units and including the segwit discount.")
    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecodeRawTransactionHexRISL decodeRawTransactionHexRISL = (DecodeRawTransactionHexRISL)o;
        return Objects.equals(this.locktime, decodeRawTransactionHexRISL.locktime) && Objects.equals(this.transactionHash, decodeRawTransactionHexRISL.transactionHash) && Objects.equals(this.vSize, decodeRawTransactionHexRISL.vSize) && Objects.equals(this.version, decodeRawTransactionHexRISL.version) && Objects.equals(this.vin, decodeRawTransactionHexRISL.vin) && Objects.equals(this.vout, decodeRawTransactionHexRISL.vout) && Objects.equals(this.weight, decodeRawTransactionHexRISL.weight);
    }

    public int hashCode() {
        return Objects.hash(this.locktime, this.transactionHash, this.vSize, this.version, this.vin, this.vout, this.weight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecodeRawTransactionHexRISL {\n");
        sb.append("    locktime: ").append(this.toIndentedString(this.locktime)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    vSize: ").append(this.toIndentedString(this.vSize)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    vin: ").append(this.toIndentedString(this.vin)).append("\n");
        sb.append("    vout: ").append(this.toIndentedString(this.vout)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvout;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DecodeRawTransactionHexRISL is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DecodeRawTransactionHexRISL` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionHash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH).toString()));
        }
        JsonArray jsonArrayvin = jsonObj.getAsJsonArray(SERIALIZED_NAME_VIN);
        if (jsonArrayvin != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VIN).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `vin` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VIN).toString()));
            }
            for (int i = 0; i < jsonArrayvin.size(); ++i) {
                DecodeRawTransactionHexRISLVinInner.validateJsonObject(jsonArrayvin.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayvout = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOUT)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOUT).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `vout` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOUT).toString()));
            }
            for (int i = 0; i < jsonArrayvout.size(); ++i) {
                DecodeRawTransactionHexRISLVoutInner.validateJsonObject(jsonArrayvout.get(i).getAsJsonObject());
            }
        }
    }

    public static DecodeRawTransactionHexRISL fromJson(String jsonString) throws IOException {
        return (DecodeRawTransactionHexRISL)JSON.getGson().fromJson(jsonString, DecodeRawTransactionHexRISL.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LOCKTIME);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_HASH);
        openapiFields.add(SERIALIZED_NAME_V_SIZE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_VIN);
        openapiFields.add(SERIALIZED_NAME_VOUT);
        openapiFields.add(SERIALIZED_NAME_WEIGHT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LOCKTIME);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_HASH);
        openapiRequiredFields.add(SERIALIZED_NAME_V_SIZE);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_VIN);
        openapiRequiredFields.add(SERIALIZED_NAME_VOUT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DecodeRawTransactionHexRISL.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DecodeRawTransactionHexRISL.class));
            return new TypeAdapter<DecodeRawTransactionHexRISL>(){

                public void write(JsonWriter out, DecodeRawTransactionHexRISL value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DecodeRawTransactionHexRISL read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DecodeRawTransactionHexRISL.validateJsonObject(jsonObj);
                    return (DecodeRawTransactionHexRISL)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

