/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class DeriveAndSyncNewReceivingAddressesRI {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_ADDRESS_FORMAT = "addressFormat";
    @SerializedName(value="addressFormat")
    private String addressFormat;
    public static final String SERIALIZED_NAME_ADDRESS_TYPE = "addressType";
    @SerializedName(value="addressType")
    private AddressTypeEnum addressType;
    public static final String SERIALIZED_NAME_DERIVATION_TYPE = "derivationType";
    @SerializedName(value="derivationType")
    private DerivationTypeEnum derivationType;
    public static final String SERIALIZED_NAME_INDEX = "index";
    @SerializedName(value="index")
    private String index;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DeriveAndSyncNewReceivingAddressesRI address(String address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="tb1qupysufr3palqvz08hk7seglvskkvah9hmt66s7", required=true, value="Represents the public address, which is a compressed and shortened form of a public key.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public DeriveAndSyncNewReceivingAddressesRI addressFormat(String addressFormat) {
        this.addressFormat = addressFormat;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="P2WPKH", required=true, value="Represents the format of the address.")
    public String getAddressFormat() {
        return this.addressFormat;
    }

    public void setAddressFormat(String addressFormat) {
        this.addressFormat = addressFormat;
    }

    public DeriveAndSyncNewReceivingAddressesRI addressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="change", required=true, value="Defines the address type.")
    public AddressTypeEnum getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
    }

    public DeriveAndSyncNewReceivingAddressesRI derivationType(DerivationTypeEnum derivationType) {
        this.derivationType = derivationType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bip32", required=true, value="Represents the derivation type")
    public DerivationTypeEnum getDerivationType() {
        return this.derivationType;
    }

    public void setDerivationType(DerivationTypeEnum derivationType) {
        this.derivationType = derivationType;
    }

    public DeriveAndSyncNewReceivingAddressesRI index(String index) {
        this.index = index;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Represents the output index. It refers to the UTXO sequence in the transaction outputs (vout).")
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeriveAndSyncNewReceivingAddressesRI deriveAndSyncNewReceivingAddressesRI = (DeriveAndSyncNewReceivingAddressesRI)o;
        return Objects.equals(this.address, deriveAndSyncNewReceivingAddressesRI.address) && Objects.equals(this.addressFormat, deriveAndSyncNewReceivingAddressesRI.addressFormat) && Objects.equals((Object)this.addressType, (Object)deriveAndSyncNewReceivingAddressesRI.addressType) && Objects.equals((Object)this.derivationType, (Object)deriveAndSyncNewReceivingAddressesRI.derivationType) && Objects.equals(this.index, deriveAndSyncNewReceivingAddressesRI.index);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.addressFormat, this.addressType, this.derivationType, this.index});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeriveAndSyncNewReceivingAddressesRI {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    addressFormat: ").append(this.toIndentedString(this.addressFormat)).append("\n");
        sb.append("    addressType: ").append(this.toIndentedString((Object)this.addressType)).append("\n");
        sb.append("    derivationType: ").append(this.toIndentedString((Object)this.derivationType)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DeriveAndSyncNewReceivingAddressesRI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DeriveAndSyncNewReceivingAddressesRI` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `addressFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS_FORMAT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `addressType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DERIVATION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DERIVATION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `derivationType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DERIVATION_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INDEX) != null && !jsonObj.get(SERIALIZED_NAME_INDEX).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `index` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INDEX).toString()));
        }
    }

    public static DeriveAndSyncNewReceivingAddressesRI fromJson(String jsonString) throws IOException {
        return (DeriveAndSyncNewReceivingAddressesRI)JSON.getGson().fromJson(jsonString, DeriveAndSyncNewReceivingAddressesRI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_ADDRESS_FORMAT);
        openapiFields.add(SERIALIZED_NAME_ADDRESS_TYPE);
        openapiFields.add(SERIALIZED_NAME_DERIVATION_TYPE);
        openapiFields.add(SERIALIZED_NAME_INDEX);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS_FORMAT);
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_DERIVATION_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_INDEX);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DeriveAndSyncNewReceivingAddressesRI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DeriveAndSyncNewReceivingAddressesRI.class));
            return new TypeAdapter<DeriveAndSyncNewReceivingAddressesRI>(){

                public void write(JsonWriter out, DeriveAndSyncNewReceivingAddressesRI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DeriveAndSyncNewReceivingAddressesRI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DeriveAndSyncNewReceivingAddressesRI.validateJsonObject(jsonObj);
                    return (DeriveAndSyncNewReceivingAddressesRI)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DerivationTypeEnum {
        ACCOUNT("account"),
        BIP32("bip32");

        private String value;

        private DerivationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DerivationTypeEnum fromValue(String value) {
            for (DerivationTypeEnum b : DerivationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DerivationTypeEnum> {
            public void write(JsonWriter jsonWriter, DerivationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DerivationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DerivationTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AddressTypeEnum {
        CHANGE("change");

        private String value;

        private AddressTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AddressTypeEnum fromValue(String value) {
            for (AddressTypeEnum b : AddressTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AddressTypeEnum> {
            public void write(JsonWriter jsonWriter, AddressTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AddressTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AddressTypeEnum.fromValue(value);
            }
        }
    }
}

