/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="Crypto Type Data")
public class GetAssetDetailsByAssetIDRISC {
    public static final String SERIALIZED_NAME_1HOUR_PRICE_CHANGE_IN_PERCENTAGE = "1HourPriceChangeInPercentage";
    @SerializedName(value="1HourPriceChangeInPercentage")
    private String _1hourPriceChangeInPercentage;
    public static final String SERIALIZED_NAME_1WEEK_PRICE_CHANGE_IN_PERCENTAGE = "1WeekPriceChangeInPercentage";
    @SerializedName(value="1WeekPriceChangeInPercentage")
    private String _1weekPriceChangeInPercentage;
    public static final String SERIALIZED_NAME_24HOURS_PRICE_CHANGE_IN_PERCENTAGE = "24HoursPriceChangeInPercentage";
    @SerializedName(value="24HoursPriceChangeInPercentage")
    private String _24hoursPriceChangeInPercentage;
    public static final String SERIALIZED_NAME_24HOURS_TRADING_VOLUME = "24HoursTradingVolume";
    @SerializedName(value="24HoursTradingVolume")
    private String _24hoursTradingVolume;
    public static final String SERIALIZED_NAME_ASSET_TYPE = "assetType";
    @SerializedName(value="assetType")
    private AssetTypeEnum assetType;
    public static final String SERIALIZED_NAME_CIRCULATING_SUPPLY = "circulatingSupply";
    @SerializedName(value="circulatingSupply")
    private String circulatingSupply;
    public static final String SERIALIZED_NAME_MARKET_CAP_IN_U_S_D = "marketCapInUSD";
    @SerializedName(value="marketCapInUSD")
    private String marketCapInUSD;
    public static final String SERIALIZED_NAME_MAX_SUPPLY = "maxSupply";
    @SerializedName(value="maxSupply")
    private String maxSupply;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GetAssetDetailsByAssetIDRISC _1hourPriceChangeInPercentage(String _1hourPriceChangeInPercentage) {
        this._1hourPriceChangeInPercentage = _1hourPriceChangeInPercentage;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="-0.4277852328344024", required=true, value="Represents the percentage of the asset's current price against the its price from 1 hour ago.")
    public String get1hourPriceChangeInPercentage() {
        return this._1hourPriceChangeInPercentage;
    }

    public void set1hourPriceChangeInPercentage(String _1hourPriceChangeInPercentage) {
        this._1hourPriceChangeInPercentage = _1hourPriceChangeInPercentage;
    }

    public GetAssetDetailsByAssetIDRISC _1weekPriceChangeInPercentage(String _1weekPriceChangeInPercentage) {
        this._1weekPriceChangeInPercentage = _1weekPriceChangeInPercentage;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1.6572304104646762", required=true, value="Represents the percentage of the asset's current price against the its price from 1 week ago.")
    public String get1weekPriceChangeInPercentage() {
        return this._1weekPriceChangeInPercentage;
    }

    public void set1weekPriceChangeInPercentage(String _1weekPriceChangeInPercentage) {
        this._1weekPriceChangeInPercentage = _1weekPriceChangeInPercentage;
    }

    public GetAssetDetailsByAssetIDRISC _24hoursPriceChangeInPercentage(String _24hoursPriceChangeInPercentage) {
        this._24hoursPriceChangeInPercentage = _24hoursPriceChangeInPercentage;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="-0.059688916478600924", required=true, value="Represents the percentage of the asset's current price against the its price from 24 hours ago.")
    public String get24hoursPriceChangeInPercentage() {
        return this._24hoursPriceChangeInPercentage;
    }

    public void set24hoursPriceChangeInPercentage(String _24hoursPriceChangeInPercentage) {
        this._24hoursPriceChangeInPercentage = _24hoursPriceChangeInPercentage;
    }

    public GetAssetDetailsByAssetIDRISC _24hoursTradingVolume(String _24hoursTradingVolume) {
        this._24hoursTradingVolume = _24hoursTradingVolume;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="3116834672.508857", required=true, value="Represents the trading volume of the asset for the time frame of 24 hours.")
    public String get24hoursTradingVolume() {
        return this._24hoursTradingVolume;
    }

    public void set24hoursTradingVolume(String _24hoursTradingVolume) {
        this._24hoursTradingVolume = _24hoursTradingVolume;
    }

    public GetAssetDetailsByAssetIDRISC assetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="coin", required=true, value="Represent a subtype of the crypto assets. Could be COIN or TOKEN.")
    public AssetTypeEnum getAssetType() {
        return this.assetType;
    }

    public void setAssetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
    }

    public GetAssetDetailsByAssetIDRISC circulatingSupply(String circulatingSupply) {
        this.circulatingSupply = circulatingSupply;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="18562881", required=true, value="Represents the amount of the asset that is circulating on the market and in public hands.")
    public String getCirculatingSupply() {
        return this.circulatingSupply;
    }

    public void setCirculatingSupply(String circulatingSupply) {
        this.circulatingSupply = circulatingSupply;
    }

    public GetAssetDetailsByAssetIDRISC marketCapInUSD(String marketCapInUSD) {
        this.marketCapInUSD = marketCapInUSD;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1146119021006.8835", required=true, value="Defines the total market value of the asset's circulating supply in USD.")
    public String getMarketCapInUSD() {
        return this.marketCapInUSD;
    }

    public void setMarketCapInUSD(String marketCapInUSD) {
        this.marketCapInUSD = marketCapInUSD;
    }

    public GetAssetDetailsByAssetIDRISC maxSupply(String maxSupply) {
        this.maxSupply = maxSupply;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="21000000", required=true, value="Represents the maximum amount of all coins of a specific asset that will ever exist in its lifetime.")
    public String getMaxSupply() {
        return this.maxSupply;
    }

    public void setMaxSupply(String maxSupply) {
        this.maxSupply = maxSupply;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAssetDetailsByAssetIDRISC getAssetDetailsByAssetIDRISC = (GetAssetDetailsByAssetIDRISC)o;
        return Objects.equals(this._1hourPriceChangeInPercentage, getAssetDetailsByAssetIDRISC._1hourPriceChangeInPercentage) && Objects.equals(this._1weekPriceChangeInPercentage, getAssetDetailsByAssetIDRISC._1weekPriceChangeInPercentage) && Objects.equals(this._24hoursPriceChangeInPercentage, getAssetDetailsByAssetIDRISC._24hoursPriceChangeInPercentage) && Objects.equals(this._24hoursTradingVolume, getAssetDetailsByAssetIDRISC._24hoursTradingVolume) && Objects.equals((Object)this.assetType, (Object)getAssetDetailsByAssetIDRISC.assetType) && Objects.equals(this.circulatingSupply, getAssetDetailsByAssetIDRISC.circulatingSupply) && Objects.equals(this.marketCapInUSD, getAssetDetailsByAssetIDRISC.marketCapInUSD) && Objects.equals(this.maxSupply, getAssetDetailsByAssetIDRISC.maxSupply);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._1hourPriceChangeInPercentage, this._1weekPriceChangeInPercentage, this._24hoursPriceChangeInPercentage, this._24hoursTradingVolume, this.assetType, this.circulatingSupply, this.marketCapInUSD, this.maxSupply});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAssetDetailsByAssetIDRISC {\n");
        sb.append("    _1hourPriceChangeInPercentage: ").append(this.toIndentedString(this._1hourPriceChangeInPercentage)).append("\n");
        sb.append("    _1weekPriceChangeInPercentage: ").append(this.toIndentedString(this._1weekPriceChangeInPercentage)).append("\n");
        sb.append("    _24hoursPriceChangeInPercentage: ").append(this.toIndentedString(this._24hoursPriceChangeInPercentage)).append("\n");
        sb.append("    _24hoursTradingVolume: ").append(this.toIndentedString(this._24hoursTradingVolume)).append("\n");
        sb.append("    assetType: ").append(this.toIndentedString((Object)this.assetType)).append("\n");
        sb.append("    circulatingSupply: ").append(this.toIndentedString(this.circulatingSupply)).append("\n");
        sb.append("    marketCapInUSD: ").append(this.toIndentedString(this.marketCapInUSD)).append("\n");
        sb.append("    maxSupply: ").append(this.toIndentedString(this.maxSupply)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GetAssetDetailsByAssetIDRISC is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetAssetDetailsByAssetIDRISC` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_1HOUR_PRICE_CHANGE_IN_PERCENTAGE) != null && !jsonObj.get(SERIALIZED_NAME_1HOUR_PRICE_CHANGE_IN_PERCENTAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `1HourPriceChangeInPercentage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_1HOUR_PRICE_CHANGE_IN_PERCENTAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_1WEEK_PRICE_CHANGE_IN_PERCENTAGE) != null && !jsonObj.get(SERIALIZED_NAME_1WEEK_PRICE_CHANGE_IN_PERCENTAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `1WeekPriceChangeInPercentage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_1WEEK_PRICE_CHANGE_IN_PERCENTAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_24HOURS_PRICE_CHANGE_IN_PERCENTAGE) != null && !jsonObj.get(SERIALIZED_NAME_24HOURS_PRICE_CHANGE_IN_PERCENTAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `24HoursPriceChangeInPercentage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_24HOURS_PRICE_CHANGE_IN_PERCENTAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_24HOURS_TRADING_VOLUME) != null && !jsonObj.get(SERIALIZED_NAME_24HOURS_TRADING_VOLUME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `24HoursTradingVolume` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_24HOURS_TRADING_VOLUME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ASSET_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `assetType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSET_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CIRCULATING_SUPPLY) != null && !jsonObj.get(SERIALIZED_NAME_CIRCULATING_SUPPLY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `circulatingSupply` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CIRCULATING_SUPPLY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MARKET_CAP_IN_U_S_D) != null && !jsonObj.get(SERIALIZED_NAME_MARKET_CAP_IN_U_S_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `marketCapInUSD` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MARKET_CAP_IN_U_S_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAX_SUPPLY) != null && !jsonObj.get(SERIALIZED_NAME_MAX_SUPPLY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maxSupply` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAX_SUPPLY).toString()));
        }
    }

    public static GetAssetDetailsByAssetIDRISC fromJson(String jsonString) throws IOException {
        return (GetAssetDetailsByAssetIDRISC)JSON.getGson().fromJson(jsonString, GetAssetDetailsByAssetIDRISC.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_1HOUR_PRICE_CHANGE_IN_PERCENTAGE);
        openapiFields.add(SERIALIZED_NAME_1WEEK_PRICE_CHANGE_IN_PERCENTAGE);
        openapiFields.add(SERIALIZED_NAME_24HOURS_PRICE_CHANGE_IN_PERCENTAGE);
        openapiFields.add(SERIALIZED_NAME_24HOURS_TRADING_VOLUME);
        openapiFields.add(SERIALIZED_NAME_ASSET_TYPE);
        openapiFields.add(SERIALIZED_NAME_CIRCULATING_SUPPLY);
        openapiFields.add(SERIALIZED_NAME_MARKET_CAP_IN_U_S_D);
        openapiFields.add(SERIALIZED_NAME_MAX_SUPPLY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_1HOUR_PRICE_CHANGE_IN_PERCENTAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_1WEEK_PRICE_CHANGE_IN_PERCENTAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_24HOURS_PRICE_CHANGE_IN_PERCENTAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_24HOURS_TRADING_VOLUME);
        openapiRequiredFields.add(SERIALIZED_NAME_ASSET_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_CIRCULATING_SUPPLY);
        openapiRequiredFields.add(SERIALIZED_NAME_MARKET_CAP_IN_U_S_D);
        openapiRequiredFields.add(SERIALIZED_NAME_MAX_SUPPLY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetAssetDetailsByAssetIDRISC.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GetAssetDetailsByAssetIDRISC.class));
            return new TypeAdapter<GetAssetDetailsByAssetIDRISC>(){

                public void write(JsonWriter out, GetAssetDetailsByAssetIDRISC value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GetAssetDetailsByAssetIDRISC read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GetAssetDetailsByAssetIDRISC.validateJsonObject(jsonObj);
                    return (GetAssetDetailsByAssetIDRISC)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AssetTypeEnum {
        COIN("coin"),
        TOKEN("token");

        private String value;

        private AssetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AssetTypeEnum fromValue(String value) {
            for (AssetTypeEnum b : AssetTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AssetTypeEnum> {
            public void write(JsonWriter jsonWriter, AssetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AssetTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AssetTypeEnum.fromValue(value);
            }
        }
    }
}

