/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.GetBlockDetailsByBlockHeightRIBS;

public class GetBlockDetailsByBlockHeightRI {
    public static final String SERIALIZED_NAME_HASH = "hash";
    @SerializedName(value="hash")
    private String hash;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_NEXT_BLOCK_HASH = "nextBlockHash";
    @SerializedName(value="nextBlockHash")
    private String nextBlockHash;
    public static final String SERIALIZED_NAME_PREVIOUS_BLOCK_HASH = "previousBlockHash";
    @SerializedName(value="previousBlockHash")
    private String previousBlockHash;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;
    public static final String SERIALIZED_NAME_TRANSACTIONS_COUNT = "transactionsCount";
    @SerializedName(value="transactionsCount")
    private Integer transactionsCount;
    public static final String SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC = "blockchainSpecific";
    @SerializedName(value="blockchainSpecific")
    private GetBlockDetailsByBlockHeightRIBS blockchainSpecific;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GetBlockDetailsByBlockHeightRI hash(String hash) {
        this.hash = hash;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="000000000000000cf507214c4f86a5048449230bc5c5dbbed59aa74421553f26", required=true, value="Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public GetBlockDetailsByBlockHeightRI height(Integer height) {
        this.height = height;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1939743", required=true, value="Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public GetBlockDetailsByBlockHeightRI nextBlockHash(String nextBlockHash) {
        this.nextBlockHash = nextBlockHash;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="000000000000000e2f2e4fab8eaaa6bb39632a79a825d34169d451a86959fe04", required=true, value="Represents the hash of the next block. When this is the last block of the blockchain this value will be an empty string.")
    public String getNextBlockHash() {
        return this.nextBlockHash;
    }

    public void setNextBlockHash(String nextBlockHash) {
        this.nextBlockHash = nextBlockHash;
    }

    public GetBlockDetailsByBlockHeightRI previousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="00000000b8c2337ed1221d1861105ad227dfff93b0a1798e78fb6edff58925f5", required=true, value="Represents the hash of the previous block, also known as the parent block.")
    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public GetBlockDetailsByBlockHeightRI timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1615378134", required=true, value="Defines the exact date/time when this block was mined in Unix")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public GetBlockDetailsByBlockHeightRI transactionsCount(Integer transactionsCount) {
        this.transactionsCount = transactionsCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="12", required=true, value="Represents the total number of all transactions as part of this block.")
    public Integer getTransactionsCount() {
        return this.transactionsCount;
    }

    public void setTransactionsCount(Integer transactionsCount) {
        this.transactionsCount = transactionsCount;
    }

    public GetBlockDetailsByBlockHeightRI blockchainSpecific(GetBlockDetailsByBlockHeightRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public GetBlockDetailsByBlockHeightRIBS getBlockchainSpecific() {
        return this.blockchainSpecific;
    }

    public void setBlockchainSpecific(GetBlockDetailsByBlockHeightRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetBlockDetailsByBlockHeightRI getBlockDetailsByBlockHeightRI = (GetBlockDetailsByBlockHeightRI)o;
        return Objects.equals(this.hash, getBlockDetailsByBlockHeightRI.hash) && Objects.equals(this.height, getBlockDetailsByBlockHeightRI.height) && Objects.equals(this.nextBlockHash, getBlockDetailsByBlockHeightRI.nextBlockHash) && Objects.equals(this.previousBlockHash, getBlockDetailsByBlockHeightRI.previousBlockHash) && Objects.equals(this.timestamp, getBlockDetailsByBlockHeightRI.timestamp) && Objects.equals(this.transactionsCount, getBlockDetailsByBlockHeightRI.transactionsCount) && Objects.equals(this.blockchainSpecific, getBlockDetailsByBlockHeightRI.blockchainSpecific);
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.height, this.nextBlockHash, this.previousBlockHash, this.timestamp, this.transactionsCount, this.blockchainSpecific);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetBlockDetailsByBlockHeightRI {\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    nextBlockHash: ").append(this.toIndentedString(this.nextBlockHash)).append("\n");
        sb.append("    previousBlockHash: ").append(this.toIndentedString(this.previousBlockHash)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transactionsCount: ").append(this.toIndentedString(this.transactionsCount)).append("\n");
        sb.append("    blockchainSpecific: ").append(this.toIndentedString(this.blockchainSpecific)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GetBlockDetailsByBlockHeightRI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetBlockDetailsByBlockHeightRI` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HASH) != null && !jsonObj.get(SERIALIZED_NAME_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HASH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEXT_BLOCK_HASH) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_BLOCK_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nextBlockHash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_BLOCK_HASH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREVIOUS_BLOCK_HASH) != null && !jsonObj.get(SERIALIZED_NAME_PREVIOUS_BLOCK_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `previousBlockHash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREVIOUS_BLOCK_HASH).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC) != null) {
            GetBlockDetailsByBlockHeightRIBS.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC));
        }
    }

    public static GetBlockDetailsByBlockHeightRI fromJson(String jsonString) throws IOException {
        return (GetBlockDetailsByBlockHeightRI)JSON.getGson().fromJson(jsonString, GetBlockDetailsByBlockHeightRI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HASH);
        openapiFields.add(SERIALIZED_NAME_HEIGHT);
        openapiFields.add(SERIALIZED_NAME_NEXT_BLOCK_HASH);
        openapiFields.add(SERIALIZED_NAME_PREVIOUS_BLOCK_HASH);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_TRANSACTIONS_COUNT);
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_HASH);
        openapiRequiredFields.add(SERIALIZED_NAME_HEIGHT);
        openapiRequiredFields.add(SERIALIZED_NAME_NEXT_BLOCK_HASH);
        openapiRequiredFields.add(SERIALIZED_NAME_PREVIOUS_BLOCK_HASH);
        openapiRequiredFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTIONS_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetBlockDetailsByBlockHeightRI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GetBlockDetailsByBlockHeightRI.class));
            return new TypeAdapter<GetBlockDetailsByBlockHeightRI>(){

                public void write(JsonWriter out, GetBlockDetailsByBlockHeightRI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GetBlockDetailsByBlockHeightRI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GetBlockDetailsByBlockHeightRI.validateJsonObject(jsonObj);
                    return (GetBlockDetailsByBlockHeightRI)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

