/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.GetTransactionRequestDetailsRIRecipientsInner;

public class GetTransactionRequestDetailsRI {
    public static final String SERIALIZED_NAME_ADDITIONAL_DETAILS = "additionalDetails";
    @SerializedName(value="additionalDetails")
    private String additionalDetails;
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private BlockchainEnum blockchain;
    public static final String SERIALIZED_NAME_FEE_PRIORITY = "feePriority";
    @SerializedName(value="feePriority")
    private FeePriorityEnum feePriority;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private NetworkEnum network;
    public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
    @SerializedName(value="recipients")
    private List<GetTransactionRequestDetailsRIRecipientsInner> recipients = new ArrayList<GetTransactionRequestDetailsRIRecipientsInner>();
    public static final String SERIALIZED_NAME_TOTAL_TRANSACTION_AMOUNT = "totalTransactionAmount";
    @SerializedName(value="totalTransactionAmount")
    private String totalTransactionAmount;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_TRANSACTION_REQUEST_STATUS = "transactionRequestStatus";
    @SerializedName(value="transactionRequestStatus")
    private TransactionRequestStatusEnum transactionRequestStatus;
    public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
    @SerializedName(value="transactionType")
    private TransactionTypeEnum transactionType;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static final String SERIALIZED_NAME_WALLET_ID = "walletId";
    @SerializedName(value="walletId")
    private String walletId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GetTransactionRequestDetailsRI additionalDetails(String additionalDetails) {
        this.additionalDetails = additionalDetails;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="yourExampleStringHere", required=true, value="Defines an optional note for additional details.")
    public String getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(String additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public GetTransactionRequestDetailsRI blockchain(BlockchainEnum blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public BlockchainEnum getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(BlockchainEnum blockchain) {
        this.blockchain = blockchain;
    }

    public GetTransactionRequestDetailsRI feePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="standard", required=true, value="Defines the priority for the fee, if it is \"slow\", \"standard\" or \"fast\".")
    public FeePriorityEnum getFeePriority() {
        return this.feePriority;
    }

    public void setFeePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
    }

    public GetTransactionRequestDetailsRI network(NetworkEnum network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.")
    public NetworkEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkEnum network) {
        this.network = network;
    }

    public GetTransactionRequestDetailsRI recipients(List<GetTransactionRequestDetailsRIRecipientsInner> recipients) {
        this.recipients = recipients;
        return this;
    }

    public GetTransactionRequestDetailsRI addRecipientsItem(GetTransactionRequestDetailsRIRecipientsInner recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents a list of recipient addresses with the respective amounts. In account-based protocols like Ethereum there is only one address in this list.")
    public List<GetTransactionRequestDetailsRIRecipientsInner> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<GetTransactionRequestDetailsRIRecipientsInner> recipients) {
        this.recipients = recipients;
    }

    public GetTransactionRequestDetailsRI totalTransactionAmount(String totalTransactionAmount) {
        this.totalTransactionAmount = totalTransactionAmount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0.001", required=true, value="Defines the total transaction amount.")
    public String getTotalTransactionAmount() {
        return this.totalTransactionAmount;
    }

    public void setTotalTransactionAmount(String totalTransactionAmount) {
        this.totalTransactionAmount = totalTransactionAmount;
    }

    public GetTransactionRequestDetailsRI transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="61922aa68f192800067a8404", value="Represents the unique identifier of a transaction, i.e. it could be transactionId in UTXO-based protocols like Bitcoin, and transaction hash in Ethereum blockchain.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public GetTransactionRequestDetailsRI transactionRequestStatus(TransactionRequestStatusEnum transactionRequestStatus) {
        this.transactionRequestStatus = transactionRequestStatus;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="created", required=true, value="Defines the status of the transaction request, e.g. pending.")
    public TransactionRequestStatusEnum getTransactionRequestStatus() {
        return this.transactionRequestStatus;
    }

    public void setTransactionRequestStatus(TransactionRequestStatusEnum transactionRequestStatus) {
        this.transactionRequestStatus = transactionRequestStatus;
    }

    public GetTransactionRequestDetailsRI transactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="coin", required=true, value="Defines the transaction type, if it is for coins or tokens.")
    public TransactionTypeEnum getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
    }

    public GetTransactionRequestDetailsRI unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="BTC", required=true, value="Defines the unit of the amount.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public GetTransactionRequestDetailsRI walletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="60c9d9921c38030006675ff6", required=true, value="Defines the unique ID of the Wallet.")
    public String getWalletId() {
        return this.walletId;
    }

    public void setWalletId(String walletId) {
        this.walletId = walletId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTransactionRequestDetailsRI getTransactionRequestDetailsRI = (GetTransactionRequestDetailsRI)o;
        return Objects.equals(this.additionalDetails, getTransactionRequestDetailsRI.additionalDetails) && Objects.equals((Object)this.blockchain, (Object)getTransactionRequestDetailsRI.blockchain) && Objects.equals((Object)this.feePriority, (Object)getTransactionRequestDetailsRI.feePriority) && Objects.equals((Object)this.network, (Object)getTransactionRequestDetailsRI.network) && Objects.equals(this.recipients, getTransactionRequestDetailsRI.recipients) && Objects.equals(this.totalTransactionAmount, getTransactionRequestDetailsRI.totalTransactionAmount) && Objects.equals(this.transactionId, getTransactionRequestDetailsRI.transactionId) && Objects.equals((Object)this.transactionRequestStatus, (Object)getTransactionRequestDetailsRI.transactionRequestStatus) && Objects.equals((Object)this.transactionType, (Object)getTransactionRequestDetailsRI.transactionType) && Objects.equals(this.unit, getTransactionRequestDetailsRI.unit) && Objects.equals(this.walletId, getTransactionRequestDetailsRI.walletId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalDetails, this.blockchain, this.feePriority, this.network, this.recipients, this.totalTransactionAmount, this.transactionId, this.transactionRequestStatus, this.transactionType, this.unit, this.walletId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTransactionRequestDetailsRI {\n");
        sb.append("    additionalDetails: ").append(this.toIndentedString(this.additionalDetails)).append("\n");
        sb.append("    blockchain: ").append(this.toIndentedString((Object)this.blockchain)).append("\n");
        sb.append("    feePriority: ").append(this.toIndentedString((Object)this.feePriority)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    totalTransactionAmount: ").append(this.toIndentedString(this.totalTransactionAmount)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionRequestStatus: ").append(this.toIndentedString((Object)this.transactionRequestStatus)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    walletId: ").append(this.toIndentedString(this.walletId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GetTransactionRequestDetailsRI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetTransactionRequestDetailsRI` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDITIONAL_DETAILS) != null && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_DETAILS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `additionalDetails` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDITIONAL_DETAILS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockchain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKCHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEE_PRIORITY) != null && !jsonObj.get(SERIALIZED_NAME_FEE_PRIORITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `feePriority` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FEE_PRIORITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK).toString()));
        }
        JsonArray jsonArrayrecipients = jsonObj.getAsJsonArray(SERIALIZED_NAME_RECIPIENTS);
        if (jsonArrayrecipients != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECIPIENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `recipients` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECIPIENTS).toString()));
            }
            for (int i = 0; i < jsonArrayrecipients.size(); ++i) {
                GetTransactionRequestDetailsRIRecipientsInner.validateJsonObject(jsonArrayrecipients.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TOTAL_TRANSACTION_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_TOTAL_TRANSACTION_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `totalTransactionAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOTAL_TRANSACTION_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_REQUEST_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_REQUEST_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionRequestStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_REQUEST_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WALLET_ID) != null && !jsonObj.get(SERIALIZED_NAME_WALLET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `walletId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WALLET_ID).toString()));
        }
    }

    public static GetTransactionRequestDetailsRI fromJson(String jsonString) throws IOException {
        return (GetTransactionRequestDetailsRI)JSON.getGson().fromJson(jsonString, GetTransactionRequestDetailsRI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DETAILS);
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiFields.add(SERIALIZED_NAME_FEE_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_RECIPIENTS);
        openapiFields.add(SERIALIZED_NAME_TOTAL_TRANSACTION_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_REQUEST_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_TYPE);
        openapiFields.add(SERIALIZED_NAME_UNIT);
        openapiFields.add(SERIALIZED_NAME_WALLET_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADDITIONAL_DETAILS);
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_FEE_PRIORITY);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_RECIPIENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_TOTAL_TRANSACTION_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_REQUEST_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_UNIT);
        openapiRequiredFields.add(SERIALIZED_NAME_WALLET_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetTransactionRequestDetailsRI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GetTransactionRequestDetailsRI.class));
            return new TypeAdapter<GetTransactionRequestDetailsRI>(){

                public void write(JsonWriter out, GetTransactionRequestDetailsRI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GetTransactionRequestDetailsRI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GetTransactionRequestDetailsRI.validateJsonObject(jsonObj);
                    return (GetTransactionRequestDetailsRI)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionTypeEnum {
        COIN("coin"),
        TOKEN("token");

        private String value;

        private TransactionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionTypeEnum fromValue(String value) {
            for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransactionTypeEnum> {
            public void write(JsonWriter jsonWriter, TransactionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionRequestStatusEnum {
        CREATED("created"),
        AWAIT_APPROVAL("await-approval"),
        PENDING("pending"),
        PREPARED("prepared"),
        SIGNED("signed"),
        BROADCASTED("broadcasted"),
        SUCCESS("success"),
        FAILED("failed"),
        REJECTED("rejected"),
        MINED("mined");

        private String value;

        private TransactionRequestStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionRequestStatusEnum fromValue(String value) {
            for (TransactionRequestStatusEnum b : TransactionRequestStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransactionRequestStatusEnum> {
            public void write(JsonWriter jsonWriter, TransactionRequestStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionRequestStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionRequestStatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NetworkEnum {
        MAINNET("mainnet"),
        TESTNET("testnet"),
        ROPSTEN("ropsten"),
        MORDOR("mordor");

        private String value;

        private NetworkEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NetworkEnum fromValue(String value) {
            for (NetworkEnum b : NetworkEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<NetworkEnum> {
            public void write(JsonWriter jsonWriter, NetworkEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NetworkEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NetworkEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FeePriorityEnum {
        SLOW("slow"),
        STANDARD("standard"),
        FAST("fast");

        private String value;

        private FeePriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FeePriorityEnum fromValue(String value) {
            for (FeePriorityEnum b : FeePriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FeePriorityEnum> {
            public void write(JsonWriter jsonWriter, FeePriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FeePriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FeePriorityEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BlockchainEnum {
        BITCOIN("bitcoin"),
        BITCOIN_CASH("bitcoin-cash"),
        LITECOIN("litecoin"),
        DOGECOIN("dogecoin"),
        DASH("dash"),
        ETHEREUM("ethereum"),
        ETHEREUM_CLASSIC("ethereum-classic"),
        XRP("xrp"),
        ZCASH("zcash");

        private String value;

        private BlockchainEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BlockchainEnum fromValue(String value) {
            for (BlockchainEnum b : BlockchainEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BlockchainEnum> {
            public void write(JsonWriter jsonWriter, BlockchainEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BlockchainEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BlockchainEnum.fromValue(value);
            }
        }
    }
}

