/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class ListSupportedAssetsRI {
    public static final String SERIALIZED_NAME_ASSET_ID = "assetId";
    @SerializedName(value="assetId")
    private String assetId;
    public static final String SERIALIZED_NAME_ASSET_NAME = "assetName";
    @SerializedName(value="assetName")
    private String assetName;
    public static final String SERIALIZED_NAME_ASSET_SYMBOL = "assetSymbol";
    @SerializedName(value="assetSymbol")
    private String assetSymbol;
    public static final String SERIALIZED_NAME_ASSET_TYPE = "assetType";
    @SerializedName(value="assetType")
    private AssetTypeEnum assetType;
    public static final String SERIALIZED_NAME_ORIGINAL_SYMBOL = "originalSymbol";
    @SerializedName(value="originalSymbol")
    private String originalSymbol;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ListSupportedAssetsRI assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="5b1ea92e584bf50020130615", required=true, value="Defines the unique ID of the specific asset.")
    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public ListSupportedAssetsRI assetName(String assetName) {
        this.assetName = assetName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Bitcoin", required=true, value="Specifies the name of the asset in question.")
    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public ListSupportedAssetsRI assetSymbol(String assetSymbol) {
        this.assetSymbol = assetSymbol;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="BTC", required=true, value="Specifies the asset's unique symbol in the Crypto APIs listings.")
    public String getAssetSymbol() {
        return this.assetSymbol;
    }

    public void setAssetSymbol(String assetSymbol) {
        this.assetSymbol = assetSymbol;
    }

    public ListSupportedAssetsRI assetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="crypto", required=true, value="Defines the type of the supported asset. This could be either \"crypto\" or \"fiat\".")
    public AssetTypeEnum getAssetType() {
        return this.assetType;
    }

    public void setAssetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
    }

    public ListSupportedAssetsRI originalSymbol(String originalSymbol) {
        this.originalSymbol = originalSymbol;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="BTC", required=true, value="Specifies the asset's original symbol as introduced by its founders.")
    public String getOriginalSymbol() {
        return this.originalSymbol;
    }

    public void setOriginalSymbol(String originalSymbol) {
        this.originalSymbol = originalSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListSupportedAssetsRI listSupportedAssetsRI = (ListSupportedAssetsRI)o;
        return Objects.equals(this.assetId, listSupportedAssetsRI.assetId) && Objects.equals(this.assetName, listSupportedAssetsRI.assetName) && Objects.equals(this.assetSymbol, listSupportedAssetsRI.assetSymbol) && Objects.equals((Object)this.assetType, (Object)listSupportedAssetsRI.assetType) && Objects.equals(this.originalSymbol, listSupportedAssetsRI.originalSymbol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetId, this.assetName, this.assetSymbol, this.assetType, this.originalSymbol});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListSupportedAssetsRI {\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    assetName: ").append(this.toIndentedString(this.assetName)).append("\n");
        sb.append("    assetSymbol: ").append(this.toIndentedString(this.assetSymbol)).append("\n");
        sb.append("    assetType: ").append(this.toIndentedString((Object)this.assetType)).append("\n");
        sb.append("    originalSymbol: ").append(this.toIndentedString(this.originalSymbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ListSupportedAssetsRI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ListSupportedAssetsRI` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET_ID) != null && !jsonObj.get(SERIALIZED_NAME_ASSET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `assetId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSET_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ASSET_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `assetName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSET_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_ASSET_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `assetSymbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSET_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ASSET_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `assetType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSET_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalSymbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_SYMBOL).toString()));
        }
    }

    public static ListSupportedAssetsRI fromJson(String jsonString) throws IOException {
        return (ListSupportedAssetsRI)JSON.getGson().fromJson(jsonString, ListSupportedAssetsRI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ASSET_ID);
        openapiFields.add(SERIALIZED_NAME_ASSET_NAME);
        openapiFields.add(SERIALIZED_NAME_ASSET_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_ASSET_TYPE);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_SYMBOL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ASSET_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ASSET_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_ASSET_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_ASSET_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_ORIGINAL_SYMBOL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ListSupportedAssetsRI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ListSupportedAssetsRI.class));
            return new TypeAdapter<ListSupportedAssetsRI>(){

                public void write(JsonWriter out, ListSupportedAssetsRI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ListSupportedAssetsRI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ListSupportedAssetsRI.validateJsonObject(jsonObj);
                    return (ListSupportedAssetsRI)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AssetTypeEnum {
        FIAT("fiat"),
        CRYPTO("crypto");

        private String value;

        private AssetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AssetTypeEnum fromValue(String value) {
            for (AssetTypeEnum b : AssetTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AssetTypeEnum> {
            public void write(JsonWriter jsonWriter, AssetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AssetTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AssetTypeEnum.fromValue(value);
            }
        }
    }
}

