/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cryptoapis.sdk.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openapitools.client.model.ListUnconfirmedTransactionsByAddressRIBS;
import org.openapitools.client.model.ListUnconfirmedTransactionsByAddressRIRecipientsInner;
import org.openapitools.client.model.ListUnconfirmedTransactionsByAddressRISendersInner;

public class ListUnconfirmedTransactionsByAddressRI {
    public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
    @SerializedName(value="recipients")
    private List<ListUnconfirmedTransactionsByAddressRIRecipientsInner> recipients = new ArrayList<ListUnconfirmedTransactionsByAddressRIRecipientsInner>();
    public static final String SERIALIZED_NAME_SENDERS = "senders";
    @SerializedName(value="senders")
    private List<ListUnconfirmedTransactionsByAddressRISendersInner> senders = new ArrayList<ListUnconfirmedTransactionsByAddressRISendersInner>();
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;
    public static final String SERIALIZED_NAME_TRANSACTION_HASH = "transactionHash";
    @SerializedName(value="transactionHash")
    private String transactionHash;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC = "blockchainSpecific";
    @SerializedName(value="blockchainSpecific")
    private ListUnconfirmedTransactionsByAddressRIBS blockchainSpecific;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ListUnconfirmedTransactionsByAddressRI recipients(List<ListUnconfirmedTransactionsByAddressRIRecipientsInner> recipients) {
        this.recipients = recipients;
        return this;
    }

    public ListUnconfirmedTransactionsByAddressRI addRecipientsItem(ListUnconfirmedTransactionsByAddressRIRecipientsInner recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents a list of recipient addresses with the respective amounts. In account-based protocols like Ethereum there is only one address in this list.")
    public List<ListUnconfirmedTransactionsByAddressRIRecipientsInner> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<ListUnconfirmedTransactionsByAddressRIRecipientsInner> recipients) {
        this.recipients = recipients;
    }

    public ListUnconfirmedTransactionsByAddressRI senders(List<ListUnconfirmedTransactionsByAddressRISendersInner> senders) {
        this.senders = senders;
        return this;
    }

    public ListUnconfirmedTransactionsByAddressRI addSendersItem(ListUnconfirmedTransactionsByAddressRISendersInner sendersItem) {
        this.senders.add(sendersItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents a list of sender addresses with the respective amounts. In account-based protocols like Ethereum there is only one address in this list.")
    public List<ListUnconfirmedTransactionsByAddressRISendersInner> getSenders() {
        return this.senders;
    }

    public void setSenders(List<ListUnconfirmedTransactionsByAddressRISendersInner> senders) {
        this.senders = senders;
    }

    public ListUnconfirmedTransactionsByAddressRI timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1633518942013", required=true, value="Defines the exact date/time in Unix Timestamp when this transaction was mined, confirmed or first seen in Mempool, if it is unconfirmed.")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public ListUnconfirmedTransactionsByAddressRI transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="3d74a44fe666308242b2c9dd0197a601779d17ba9fe8f7a23612c53a910bc98d", required=true, value="Represents the same as `transactionId` for account-based protocols like Ethereum, while it could be different in UTXO-based protocols like Bitcoin. E.g., in UTXO-based protocols `hash` is different from `transactionId` for SegWit transactions.")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public ListUnconfirmedTransactionsByAddressRI transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="3d74a44fe666308242b2c9dd0197a601779d17ba9fe8f7a23612c53a910bc98d", required=true, value="Represents the unique identifier of a transaction, i.e. it could be `transactionId` in UTXO-based protocols like Bitcoin, and transaction `hash` in Ethereum blockchain.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public ListUnconfirmedTransactionsByAddressRI blockchainSpecific(ListUnconfirmedTransactionsByAddressRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ListUnconfirmedTransactionsByAddressRIBS getBlockchainSpecific() {
        return this.blockchainSpecific;
    }

    public void setBlockchainSpecific(ListUnconfirmedTransactionsByAddressRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListUnconfirmedTransactionsByAddressRI listUnconfirmedTransactionsByAddressRI = (ListUnconfirmedTransactionsByAddressRI)o;
        return Objects.equals(this.recipients, listUnconfirmedTransactionsByAddressRI.recipients) && Objects.equals(this.senders, listUnconfirmedTransactionsByAddressRI.senders) && Objects.equals(this.timestamp, listUnconfirmedTransactionsByAddressRI.timestamp) && Objects.equals(this.transactionHash, listUnconfirmedTransactionsByAddressRI.transactionHash) && Objects.equals(this.transactionId, listUnconfirmedTransactionsByAddressRI.transactionId) && Objects.equals(this.blockchainSpecific, listUnconfirmedTransactionsByAddressRI.blockchainSpecific);
    }

    public int hashCode() {
        return Objects.hash(this.recipients, this.senders, this.timestamp, this.transactionHash, this.transactionId, this.blockchainSpecific);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListUnconfirmedTransactionsByAddressRI {\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    senders: ").append(this.toIndentedString(this.senders)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    blockchainSpecific: ").append(this.toIndentedString(this.blockchainSpecific)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysenders;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ListUnconfirmedTransactionsByAddressRI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ListUnconfirmedTransactionsByAddressRI` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayrecipients = jsonObj.getAsJsonArray(SERIALIZED_NAME_RECIPIENTS);
        if (jsonArrayrecipients != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECIPIENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `recipients` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECIPIENTS).toString()));
            }
            for (int i = 0; i < jsonArrayrecipients.size(); ++i) {
                ListUnconfirmedTransactionsByAddressRIRecipientsInner.validateJsonObject(jsonArrayrecipients.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraysenders = jsonObj.getAsJsonArray(SERIALIZED_NAME_SENDERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SENDERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `senders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SENDERS).toString()));
            }
            for (int i = 0; i < jsonArraysenders.size(); ++i) {
                ListUnconfirmedTransactionsByAddressRISendersInner.validateJsonObject(jsonArraysenders.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionHash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_HASH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC) != null) {
            ListUnconfirmedTransactionsByAddressRIBS.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC));
        }
    }

    public static ListUnconfirmedTransactionsByAddressRI fromJson(String jsonString) throws IOException {
        return (ListUnconfirmedTransactionsByAddressRI)JSON.getGson().fromJson(jsonString, ListUnconfirmedTransactionsByAddressRI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RECIPIENTS);
        openapiFields.add(SERIALIZED_NAME_SENDERS);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_HASH);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RECIPIENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_SENDERS);
        openapiRequiredFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_HASH);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ListUnconfirmedTransactionsByAddressRI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ListUnconfirmedTransactionsByAddressRI.class));
            return new TypeAdapter<ListUnconfirmedTransactionsByAddressRI>(){

                public void write(JsonWriter out, ListUnconfirmedTransactionsByAddressRI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ListUnconfirmedTransactionsByAddressRI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ListUnconfirmedTransactionsByAddressRI.validateJsonObject(jsonObj);
                    return (ListUnconfirmedTransactionsByAddressRI)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

